/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout.hierarchical.stage;

import com.mxgraph.layout.hierarchical.model.mxGraphAbstractHierarchyCell;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyModel;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyRank;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.hierarchical.stage.mxHierarchicalLayoutStage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class mxMedianHybridCrossingReduction
implements mxHierarchicalLayoutStage {
    protected mxHierarchicalLayout layout;
    protected int maxIterations = 24;
    protected mxGraphAbstractHierarchyCell[][] nestedBestRanks = null;
    protected int currentBestCrossings = 0;
    protected int iterationsWithoutImprovement = 0;
    protected int maxNoImprovementIterations = 2;

    public mxMedianHybridCrossingReduction(mxHierarchicalLayout mxHierarchicalLayout2) {
        this.layout = mxHierarchicalLayout2;
    }

    @Override
    public void execute(Object object) {
        int n;
        int n2;
        mxGraphHierarchyModel mxGraphHierarchyModel2 = this.layout.getModel();
        this.nestedBestRanks = new mxGraphAbstractHierarchyCell[mxGraphHierarchyModel2.ranks.size()][];
        for (n2 = 0; n2 < this.nestedBestRanks.length; ++n2) {
            mxGraphHierarchyRank mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(n2));
            this.nestedBestRanks[n2] = new mxGraphAbstractHierarchyCell[mxGraphHierarchyRank2.size()];
            mxGraphHierarchyRank2.toArray(this.nestedBestRanks[n2]);
        }
        this.iterationsWithoutImprovement = 0;
        this.currentBestCrossings = this.calculateCrossings(mxGraphHierarchyModel2);
        for (n2 = 0; n2 < this.maxIterations && this.iterationsWithoutImprovement < this.maxNoImprovementIterations; ++n2) {
            mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2;
            int n3;
            Iterator iterator;
            mxGraphHierarchyRank mxGraphHierarchyRank3;
            this.weightedMedian(n2, mxGraphHierarchyModel2);
            this.transpose(n2, mxGraphHierarchyModel2);
            int n4 = this.calculateCrossings(mxGraphHierarchyModel2);
            if (n4 < this.currentBestCrossings) {
                this.currentBestCrossings = n4;
                this.iterationsWithoutImprovement = 0;
                for (n = 0; n < this.nestedBestRanks.length; ++n) {
                    mxGraphHierarchyRank3 = mxGraphHierarchyModel2.ranks.get(new Integer(n));
                    iterator = mxGraphHierarchyRank3.iterator();
                    for (n3 = 0; n3 < mxGraphHierarchyRank3.size(); ++n3) {
                        this.nestedBestRanks[n][mxGraphAbstractHierarchyCell2.getGeneralPurposeVariable((int)n)] = mxGraphAbstractHierarchyCell2 = (mxGraphAbstractHierarchyCell)iterator.next();
                    }
                }
            } else {
                ++this.iterationsWithoutImprovement;
                for (n = 0; n < this.nestedBestRanks.length; ++n) {
                    mxGraphHierarchyRank3 = mxGraphHierarchyModel2.ranks.get(new Integer(n));
                    iterator = mxGraphHierarchyRank3.iterator();
                    for (n3 = 0; n3 < mxGraphHierarchyRank3.size(); ++n3) {
                        mxGraphAbstractHierarchyCell2 = (mxGraphAbstractHierarchyCell)iterator.next();
                        mxGraphAbstractHierarchyCell2.setGeneralPurposeVariable(n, n3);
                    }
                }
            }
            if (this.currentBestCrossings == 0) break;
        }
        LinkedHashMap<Integer, mxGraphHierarchyRank> linkedHashMap = new LinkedHashMap<Integer, mxGraphHierarchyRank>(mxGraphHierarchyModel2.maxRank + 1);
        mxGraphHierarchyRank[] mxGraphHierarchyRankArray = new mxGraphHierarchyRank[mxGraphHierarchyModel2.maxRank + 1];
        for (n = 0; n < mxGraphHierarchyModel2.maxRank + 1; ++n) {
            mxGraphHierarchyRankArray[n] = new mxGraphHierarchyRank();
            linkedHashMap.put(new Integer(n), mxGraphHierarchyRankArray[n]);
        }
        for (n = 0; n < this.nestedBestRanks.length; ++n) {
            for (int i = 0; i < this.nestedBestRanks[n].length; ++i) {
                mxGraphHierarchyRankArray[n].add(this.nestedBestRanks[n][i]);
            }
        }
        mxGraphHierarchyModel2.ranks = linkedHashMap;
    }

    private int calculateCrossings(mxGraphHierarchyModel mxGraphHierarchyModel2) {
        int n = mxGraphHierarchyModel2.ranks.size();
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            n2 += this.calculateRankCrossing(i, mxGraphHierarchyModel2);
        }
        return n2;
    }

    protected int calculateRankCrossing(int n, mxGraphHierarchyModel mxGraphHierarchyModel2) {
        int n2;
        int n3 = 0;
        mxGraphHierarchyRank mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(n));
        mxGraphHierarchyRank mxGraphHierarchyRank3 = mxGraphHierarchyModel2.ranks.get(new Integer(n - 1));
        int n4 = mxGraphHierarchyRank2.size();
        int n5 = mxGraphHierarchyRank3.size();
        int[][] nArray = new int[n4][n5];
        for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 : mxGraphHierarchyRank2) {
            n2 = mxGraphAbstractHierarchyCell2.getGeneralPurposeVariable(n);
            List<mxGraphAbstractHierarchyCell> list = mxGraphAbstractHierarchyCell2.getPreviousLayerConnectedCells(n);
            for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell3 : list) {
                int n6 = mxGraphAbstractHierarchyCell3.getGeneralPurposeVariable(n - 1);
                nArray[n2][n6] = 201207;
            }
        }
        for (int i = 0; i < n4; ++i) {
            for (n2 = 0; n2 < n5; ++n2) {
                int n7;
                if (nArray[i][n2] != 201207) continue;
                for (n7 = i + 1; n7 < n4; ++n7) {
                    for (int j = 0; j < n2; ++j) {
                        if (nArray[n7][j] != 201207) continue;
                        ++n3;
                    }
                }
                for (n7 = 0; n7 < i; ++n7) {
                    for (int j = n2 + 1; j < n5; ++j) {
                        if (nArray[n7][j] != 201207) continue;
                        ++n3;
                    }
                }
            }
        }
        return n3 / 2;
    }

    private void transpose(int n, mxGraphHierarchyModel mxGraphHierarchyModel2) {
        boolean bl = true;
        int n2 = 0;
        int n3 = 10;
        while (bl && n2++ < n3) {
            boolean bl2 = n % 2 == 1 && n2 % 2 == 1;
            bl = false;
            for (int i = 0; i < mxGraphHierarchyModel2.ranks.size(); ++i) {
                Object object;
                mxGraphHierarchyRank mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(i));
                mxGraphAbstractHierarchyCell[] mxGraphAbstractHierarchyCellArray = new mxGraphAbstractHierarchyCell[mxGraphHierarchyRank2.size()];
                Iterator iterator = mxGraphHierarchyRank2.iterator();
                for (int j = 0; j < mxGraphAbstractHierarchyCellArray.length; ++j) {
                    object = (mxGraphAbstractHierarchyCell)iterator.next();
                    mxGraphAbstractHierarchyCellArray[((mxGraphAbstractHierarchyCell)object).getGeneralPurposeVariable((int)i)] = object;
                }
                List<mxGraphAbstractHierarchyCell> list = null;
                object = null;
                List<mxGraphAbstractHierarchyCell> list2 = null;
                Object object2 = null;
                int[] nArray = null;
                int[] nArray2 = null;
                int[] nArray3 = null;
                int[] nArray4 = null;
                mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 = null;
                mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell3 = null;
                for (int j = 0; j < mxGraphHierarchyRank2.size() - 1; ++j) {
                    int n4;
                    int n5;
                    int n6;
                    if (j == 0) {
                        mxGraphAbstractHierarchyCell2 = mxGraphAbstractHierarchyCellArray[j];
                        list = mxGraphAbstractHierarchyCell2.getNextLayerConnectedCells(i);
                        object = mxGraphAbstractHierarchyCell2.getPreviousLayerConnectedCells(i);
                        nArray = new int[list.size()];
                        nArray2 = new int[object.size()];
                        for (n6 = 0; n6 < nArray.length; ++n6) {
                            nArray[n6] = list.get(n6).getGeneralPurposeVariable(i + 1);
                        }
                        for (n6 = 0; n6 < nArray2.length; ++n6) {
                            nArray2[n6] = ((mxGraphAbstractHierarchyCell)object.get(n6)).getGeneralPurposeVariable(i - 1);
                        }
                    } else {
                        list = list2;
                        object = object2;
                        nArray = nArray3;
                        nArray2 = nArray4;
                        mxGraphAbstractHierarchyCell2 = mxGraphAbstractHierarchyCell3;
                    }
                    mxGraphAbstractHierarchyCell3 = mxGraphAbstractHierarchyCellArray[j + 1];
                    list2 = mxGraphAbstractHierarchyCell3.getNextLayerConnectedCells(i);
                    object2 = mxGraphAbstractHierarchyCell3.getPreviousLayerConnectedCells(i);
                    nArray3 = new int[list2.size()];
                    nArray4 = new int[object2.size()];
                    for (n6 = 0; n6 < nArray3.length; ++n6) {
                        nArray3[n6] = list2.get(n6).getGeneralPurposeVariable(i + 1);
                    }
                    for (n6 = 0; n6 < nArray4.length; ++n6) {
                        nArray4[n6] = object2.get(n6).getGeneralPurposeVariable(i - 1);
                    }
                    n6 = 0;
                    int n7 = 0;
                    for (n5 = 0; n5 < nArray.length; ++n5) {
                        for (n4 = 0; n4 < nArray3.length; ++n4) {
                            if (nArray[n5] > nArray3[n4]) {
                                ++n6;
                            }
                            if (nArray[n5] >= nArray3[n4]) continue;
                            ++n7;
                        }
                    }
                    for (n5 = 0; n5 < nArray2.length; ++n5) {
                        for (n4 = 0; n4 < nArray4.length; ++n4) {
                            if (nArray2[n5] > nArray4[n4]) {
                                ++n6;
                            }
                            if (nArray2[n5] >= nArray4[n4]) continue;
                            ++n7;
                        }
                    }
                    if (n7 >= n6 && (n7 != n6 || !bl2)) continue;
                    n5 = mxGraphAbstractHierarchyCell2.getGeneralPurposeVariable(i);
                    mxGraphAbstractHierarchyCell2.setGeneralPurposeVariable(i, mxGraphAbstractHierarchyCell3.getGeneralPurposeVariable(i));
                    mxGraphAbstractHierarchyCell3.setGeneralPurposeVariable(i, n5);
                    list2 = list;
                    object2 = object;
                    nArray3 = nArray;
                    nArray4 = nArray2;
                    mxGraphAbstractHierarchyCell3 = mxGraphAbstractHierarchyCell2;
                    if (bl2) continue;
                    bl = true;
                }
            }
        }
    }

    private void weightedMedian(int n, mxGraphHierarchyModel mxGraphHierarchyModel2) {
        boolean bl;
        boolean bl2 = bl = n % 2 == 0;
        if (bl) {
            for (int i = mxGraphHierarchyModel2.maxRank - 1; i >= 0; --i) {
                this.medianRank(i, bl);
            }
        } else {
            for (int i = 1; i < mxGraphHierarchyModel2.maxRank; ++i) {
                this.medianRank(i, bl);
            }
        }
    }

    private void medianRank(int n, boolean bl) {
        int n2;
        int n3 = this.nestedBestRanks[n].length;
        Object[] objectArray = new MedianCellSorter[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 = this.nestedBestRanks[n][n2];
            objectArray[n2] = new MedianCellSorter();
            ((MedianCellSorter)objectArray[n2]).cell = mxGraphAbstractHierarchyCell2;
            List<mxGraphAbstractHierarchyCell> list = bl ? mxGraphAbstractHierarchyCell2.getNextLayerConnectedCells(n) : mxGraphAbstractHierarchyCell2.getPreviousLayerConnectedCells(n);
            int n4 = bl ? n + 1 : n - 1;
            ((MedianCellSorter)objectArray[n2]).medianValue = list != null && list.size() != 0 ? this.medianValue(list, n4) : -1.0;
        }
        Arrays.sort(objectArray);
        for (n2 = 0; n2 < n3; ++n2) {
            ((MedianCellSorter)objectArray[n2]).cell.setGeneralPurposeVariable(n, n2);
        }
    }

    private double medianValue(Collection<mxGraphAbstractHierarchyCell> collection, int n) {
        double[] dArray = new double[collection.size()];
        int n2 = 0;
        Iterator<mxGraphAbstractHierarchyCell> iterator = collection.iterator();
        while (iterator.hasNext()) {
            dArray[n2++] = iterator.next().getGeneralPurposeVariable(n);
        }
        Arrays.sort(dArray);
        if (n2 % 2 == 1) {
            return dArray[n2 / 2];
        }
        if (n2 == 2) {
            return (dArray[0] + dArray[1]) / 2.0;
        }
        int n3 = n2 / 2;
        double d = dArray[n3 - 1] - dArray[0];
        double d2 = dArray[n2 - 1] - dArray[n3];
        return (dArray[n3 - 1] * d2 + dArray[n3] * d) / (d + d2);
    }

    protected class MedianCellSorter
    implements Comparable<Object> {
        public double medianValue = 0.0;
        mxGraphAbstractHierarchyCell cell = null;

        protected MedianCellSorter() {
        }

        @Override
        public int compareTo(Object object) {
            if (object instanceof MedianCellSorter) {
                if (this.medianValue < ((MedianCellSorter)object).medianValue) {
                    return -1;
                }
                if (this.medianValue > ((MedianCellSorter)object).medianValue) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    }
}

