/*
 * Decompiled with CFR 0.152.
 */
package controller;

import events.ComponentState;
import events.EventArgs;
import events.PacketState;
import events.ProtocolState;
import events.ScenarioListChangeEventArgs;
import events.ScenarioState;
import events.Settings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import model.Model;
import view.GUI;

public class Controller {
    private GUI gui;
    private Model model;
    private boolean simulationMode = false;
    private boolean paused = false;
    public final int DEFAULT_SPEED = 100;
    private int speed = 100;
    private Timer stepTimer;
    private boolean stepForwardMode;
    private List<PacketState> packetStates = new LinkedList<PacketState>();

    public static void main(String[] args) {
        Controller c = new Controller();
        c.start();
    }

    protected Controller() {
        this.model = new Model();
        this.stepTimer = new Timer();
    }

    protected void start() {
        try {
            this.gui = new GUI(this.model.loadSettings(), this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.model.addObserver(this.gui);
    }

    public void endProgram() {
        if (this.simulationMode && !this.paused) {
            this.stepTimer.cancel();
        }
        System.exit(0);
    }

    public ComponentState getComponentState(int componentId) {
        for (PacketState s : this.packetStates) {
            if (s.getComponentId() != componentId) continue;
            return s;
        }
        return this.model.getComponentState(componentId);
    }

    public ProtocolState getProtocolState() {
        return this.model.getProtocolState();
    }

    public ScenarioState getScenarioState() {
        return this.model.getScenarioState();
    }

    public void setProtocol(int protocolId) throws IllegalStateException {
        if (this.simulationMode) {
            throw new IllegalStateException("Can't change the protocol while simulation is running;");
        }
        this.model.setProtocol(protocolId);
    }

    public void setProtocolSettings(ProtocolState s) throws IllegalStateException {
        if (this.simulationMode) {
            throw new IllegalStateException("Can't change the protocol settings while simulation is running;");
        }
        this.model.setProtocolSettings(s);
    }

    public void setScenarioName(String name) throws IllegalStateException {
        if (this.simulationMode) {
            throw new IllegalStateException("Can't change the scenario's name while simulation is running;");
        }
        this.model.setScenarioName(name);
    }

    public void setSpeed(int speed) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        if (speed >= 0 && speed <= 100) {
            this.speed = speed;
        } else if (speed == -1) {
            this.speed = 100;
        } else {
            error = true;
            errorMessage = "Value for speed is out of range: " + speed + ";";
        }
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
        if (this.simulationMode && !this.paused) {
            this.startTimer();
        }
    }

    public boolean isInSimulationMode() {
        return this.simulationMode;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void newScenario() {
        this.model.newScenario();
    }

    public void openScenario(String url) throws IOException {
        this.model.openScenario(url);
    }

    public void openScenario(int scenarioId) throws IOException {
        this.model.openScenario(scenarioId);
    }

    public void saveScenario(String url) throws IOException {
        this.model.saveScenario(url);
    }

    public void saveScenario(int scenarioId) throws FileNotFoundException, IOException {
        this.model.saveScenario(scenarioId);
    }

    public void importScenario(String url, int scenarioId) throws IOException {
        this.model.importScenario(url, scenarioId);
    }

    public void exportScenario(int scenarioId, String url) throws IOException {
        if (url != null) {
            this.model.exportScenario(scenarioId, url);
        }
    }

    public void shiftScenario(int oldId, int newId) throws IOException {
        this.model.shiftScenario(oldId, newId);
    }

    public void removeScenario(int scenarioId) throws IOException {
        this.model.removeScenario(scenarioId);
    }

    public ScenarioListChangeEventArgs getScenarioList() {
        return this.model.getScenarioList();
    }

    public void changeObjectState(EventArgs s) throws IllegalStateException {
        if (this.simulationMode && !(s instanceof PacketState) && !this.paused) {
            throw new IllegalStateException("Can't change Components while simulation is running;");
        }
        if (this.simulationMode && this.paused && s instanceof PacketState && ((PacketState)s).isLost()) {
            for (PacketState p : this.packetStates) {
                if (p.getComponentId() != ((PacketState)s).getComponentId()) continue;
                this.packetStates.remove(p);
                break;
            }
            this.packetStates.add((PacketState)s);
        } else {
            this.model.changeObjectState(s);
        }
    }

    public boolean startSimulation() {
        boolean stoppedMode = !this.simulationMode;
        this.simulationMode = true;
        this.paused = false;
        this.stepForwardMode = false;
        this.sendPacketStates();
        this.startTimer();
        return stoppedMode;
    }

    public boolean startOrPauseSimulation() {
        if (this.paused || !this.simulationMode) {
            return this.startSimulation();
        }
        this.pauseSimulation();
        return false;
    }

    public boolean stepForward() {
        boolean stoppedMode = !this.simulationMode;
        this.simulationMode = true;
        this.paused = false;
        this.stepForwardMode = true;
        this.sendPacketStates();
        this.startTimer();
        return stoppedMode;
    }

    public void pauseSimulation() {
        if (this.simulationMode) {
            this.paused = true;
            this.stepTimer.cancel();
        }
    }

    public void stopSimulation() {
        if (this.simulationMode) {
            this.stepTimer.cancel();
        }
        this.simulationMode = false;
        this.paused = false;
        this.model.resetScenario();
    }

    private void startTimer() {
        if (this.simulationMode && !this.paused) {
            this.stepTimer.cancel();
        }
        this.stepTimer = new Timer();
        this.stepTimer.schedule(this.getTimerTask(), 0L, this.getStepPeriodLength());
    }

    private void sendPacketStates() {
        for (PacketState s : this.packetStates) {
            this.model.changeObjectState(s);
        }
        this.packetStates.clear();
    }

    private long getStepPeriodLength() {
        float minStepLength = 33.0f;
        float maxStepLength = 1000.0f;
        float periodLength = (long)((double)minStepLength + (double)(maxStepLength - minStepLength) * ((double)((this.speed - 100) * (this.speed - 100)) / 10000.0));
        return (long)periodLength;
    }

    private TimerTask getTimerTask() {
        TimerTask ret = !this.stepForwardMode ? new TimerTask(){

            @Override
            public void run() {
                Controller.this.model.nextSimulationStep();
            }
        } : new TimerTask(){

            @Override
            public void run() {
                Controller.this.model.nextSimulationStep();
                if (Controller.this.model.getSignificantChange()) {
                    Controller.this.pauseSimulation();
                }
            }
        };
        return ret;
    }

    protected Model getModel() {
        return this.model;
    }

    protected void setModel(Model model) {
        this.model = model;
    }

    public Settings loadSettings() throws IOException {
        return this.model.loadSettings();
    }

    public void saveSettings(Settings s) throws IOException {
        this.model.saveSettings(s);
    }
}

