/*
 * Decompiled with CFR 0.152.
 */
package events;

import events.ComponentState;
import events.UnidirectionalLineState;
import java.util.List;

public class BidirectionalLineState
extends ComponentState {
    private int sourceDeviceId;
    private int targetDeviceId;
    private UnidirectionalLineState fromSourceToTargetLineState;
    private UnidirectionalLineState fromTargetToSourceLineState;

    public BidirectionalLineState(int ComponentId, boolean isNew, boolean isDeleted, int sourceDeviceId, int targetDeviceId, UnidirectionalLineState fromSourceToTargetLineState, UnidirectionalLineState fromTargetToSourceLineState) {
        super(ComponentId, isNew, isDeleted);
        this.sourceDeviceId = sourceDeviceId;
        this.targetDeviceId = targetDeviceId;
        this.fromSourceToTargetLineState = this.cloneLineState(fromSourceToTargetLineState);
        this.fromTargetToSourceLineState = this.cloneLineState(fromTargetToSourceLineState);
    }

    public int getSourceDeviceId() {
        return this.sourceDeviceId;
    }

    public int getTargetDeviceId() {
        return this.targetDeviceId;
    }

    public UnidirectionalLineState getFromSourceToTargetLineState() {
        return this.cloneLineState(this.fromSourceToTargetLineState);
    }

    public UnidirectionalLineState getFromTargetToSourceLineState() {
        return this.cloneLineState(this.fromTargetToSourceLineState);
    }

    private UnidirectionalLineState cloneLineState(UnidirectionalLineState lineState) {
        if (lineState == null) {
            return null;
        }
        int sourceComponentId = lineState.getSourceComponentId();
        int targetComponentId = lineState.getTargetComponentId();
        int bandwidth = lineState.getBandwidth();
        int damagePercentage = lineState.getDamagePercentage();
        int losePercentage = lineState.getLosePercentage();
        List<Integer> packets = lineState.getPackets();
        List<Integer> packetProgress = lineState.getPacketProgress();
        int length = lineState.getLength();
        return new UnidirectionalLineState(lineState.getComponentId(), lineState.isNew(), lineState.isDeleted(), sourceComponentId, targetComponentId, bandwidth, damagePercentage, losePercentage, length, packets, packetProgress);
    }

    @Override
    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof BidirectionalLineState) {
            BidirectionalLineState bState = (BidirectionalLineState)o;
            boolean bl = equals = super.equals(bState) && bState.sourceDeviceId == this.sourceDeviceId && bState.targetDeviceId == this.targetDeviceId;
            if (bState.fromSourceToTargetLineState == null || this.fromSourceToTargetLineState == null) {
                if (bState.fromSourceToTargetLineState != null || this.fromSourceToTargetLineState != null) {
                    equals = false;
                }
            } else if (!bState.fromSourceToTargetLineState.equals(this.fromSourceToTargetLineState)) {
                equals = false;
            }
            if (bState.fromTargetToSourceLineState == null || this.fromTargetToSourceLineState == null) {
                if (bState.fromTargetToSourceLineState != null || this.fromTargetToSourceLineState != null) {
                    equals = false;
                }
            } else if (!bState.fromTargetToSourceLineState.equals(this.fromTargetToSourceLineState)) {
                equals = false;
            }
        }
        return equals;
    }
}

