/*
 * Decompiled with CFR 0.152.
 */
package events;

import events.BufferState;
import events.ProtocolState;
import events.TraceData;
import java.util.List;

public class ConnectionData {
    private int bandwidth;
    private int targetHostId;
    private BufferState incomingBufferState;
    private BufferState outgoingBufferState;
    private TraceData traceData;
    private TraceData backTraceData;
    private ProtocolState protocolState;

    private ConnectionData() {
    }

    public ConnectionData(int bandwidth, int targetHostId, BufferState incomingBufferState, BufferState outgoingBufferState, TraceData traceData, TraceData backTraceData, ProtocolState protocolState) {
        this.bandwidth = bandwidth;
        this.targetHostId = targetHostId;
        this.incomingBufferState = this.cloneBufferState(incomingBufferState);
        this.outgoingBufferState = this.cloneBufferState(outgoingBufferState);
        this.traceData = this.cloneTraceData(traceData);
        this.backTraceData = this.cloneTraceData(backTraceData);
        this.protocolState = protocolState.clone();
    }

    public int getBandwidth() {
        return this.bandwidth;
    }

    public int getTargetHostId() {
        return this.targetHostId;
    }

    public BufferState getIncomingBufferState() {
        return this.cloneBufferState(this.incomingBufferState);
    }

    public BufferState getOutgoingBufferState() {
        return this.cloneBufferState(this.outgoingBufferState);
    }

    public TraceData getTraceData() {
        return this.cloneTraceData(this.traceData);
    }

    public TraceData getBackTraceData() {
        return this.cloneTraceData(this.backTraceData);
    }

    public ProtocolState getProtocolState() {
        return this.protocolState.clone();
    }

    private BufferState cloneBufferState(BufferState bufferState) {
        if (bufferState == null) {
            return null;
        }
        int componentId = bufferState.getComponentId();
        boolean isNew = bufferState.isNew();
        boolean isDeleted = bufferState.isDeleted();
        int capacity = bufferState.getCapacity();
        List<Integer> packets = bufferState.getPackets();
        return new BufferState(componentId, isNew, isDeleted, capacity, packets);
    }

    private TraceData cloneTraceData(TraceData traceData) {
        if (traceData == null) {
            return null;
        }
        return new TraceData(traceData.getLines());
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof ConnectionData) {
            ConnectionData cData = (ConnectionData)o;
            equals = cData.backTraceData.equals(this.backTraceData) && cData.bandwidth == this.bandwidth && cData.incomingBufferState.equals(this.incomingBufferState) && cData.outgoingBufferState.equals(this.outgoingBufferState) && cData.protocolState.equals(this.protocolState) && cData.targetHostId == this.targetHostId && cData.traceData.equals(this.traceData);
        }
        return equals;
    }
}

