/*
 * Decompiled with CFR 0.152.
 */
package events;

import events.BufferState;
import events.ConnectionData;
import events.DeviceState;
import events.TraceData;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;

public class HostState
extends DeviceState {
    private BufferState bufferState;
    private int lineId;
    private List<ConnectionData> connections;

    public HostState(int componentId, boolean isNew, boolean isDeleted, String name, Color color, int x, int y, BufferState bufferState, int lineId, List<ConnectionData> connections) {
        super(componentId, isNew, isDeleted, name, color, x, y);
        this.lineId = lineId;
        this.connections = this.cloneConnections(connections);
        this.bufferState = this.cloneBufferState(bufferState);
    }

    public BufferState getBufferState() {
        return this.cloneBufferState(this.bufferState);
    }

    public int getLineId() {
        return this.lineId;
    }

    public List<ConnectionData> getConnections() {
        return this.cloneConnections(this.connections);
    }

    private List<ConnectionData> cloneConnections(List<ConnectionData> connections) {
        if (connections == null) {
            return null;
        }
        LinkedList<ConnectionData> ret = new LinkedList<ConnectionData>();
        for (ConnectionData c : connections) {
            if (c == null) {
                ret.add(null);
                continue;
            }
            int bandwidth = c.getBandwidth();
            int targetHostId = c.getTargetHostId();
            TraceData traceData = c.getTraceData();
            TraceData backTraceData = c.getBackTraceData();
            BufferState incomingBufferState = c.getIncomingBufferState();
            BufferState outgoingBufferState = c.getOutgoingBufferState();
            ret.add(new ConnectionData(bandwidth, targetHostId, incomingBufferState, outgoingBufferState, traceData, backTraceData, c.getProtocolState()));
        }
        return ret;
    }

    private BufferState cloneBufferState(BufferState bufferState) {
        if (bufferState == null) {
            return null;
        }
        int componentId = bufferState.getComponentId();
        boolean isNew = bufferState.isNew();
        boolean isDeleted = bufferState.isDeleted();
        int capacity = bufferState.getCapacity();
        List<Integer> packets = bufferState.getPackets();
        return new BufferState(componentId, isNew, isDeleted, capacity, packets);
    }

    @Override
    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof HostState) {
            HostState hState = (HostState)o;
            equals = super.equals(hState) && hState.bufferState.equals(this.bufferState) && hState.connections.equals(this.connections) && hState.lineId == this.lineId;
        }
        return equals;
    }
}

