/*
 * Decompiled with CFR 0.152.
 */
package events;

import events.BufferState;
import events.DeviceState;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;

public class RouterState
extends DeviceState {
    private int processingTime;
    private List<Integer> lines;
    private List<BufferState> buffers = new LinkedList<BufferState>();

    public RouterState(int componentId, boolean isNew, boolean isDeleted, String name, Color color, int x, int y, int processingTime, List<Integer> lines, List<BufferState> buffers) {
        super(componentId, isNew, isDeleted, name, color, x, y);
        this.processingTime = processingTime;
        this.lines = this.cloneIntegerList(lines);
        this.buffers = this.cloneBufferList(buffers);
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public List<BufferState> getBuffers() {
        return this.cloneBufferList(this.buffers);
    }

    public List<Integer> getLines() {
        return this.cloneIntegerList(this.lines);
    }

    private List<BufferState> cloneBufferList(List<BufferState> bufferStates) {
        if (bufferStates == null || bufferStates.isEmpty()) {
            return null;
        }
        LinkedList<BufferState> list = new LinkedList<BufferState>();
        for (BufferState bufferState : bufferStates) {
            int componentId = bufferState.getComponentId();
            boolean isNew = bufferState.isNew();
            boolean isDeleted = bufferState.isDeleted();
            int capacity = bufferState.getCapacity();
            List<Integer> packets = bufferState.getPackets();
            list.add(new BufferState(componentId, isNew, isDeleted, capacity, packets));
        }
        return list;
    }

    private List<Integer> cloneIntegerList(List<Integer> list) {
        if (list == null) {
            return null;
        }
        LinkedList<Integer> ret = new LinkedList<Integer>();
        for (int i : list) {
            ret.add(i);
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof RouterState) {
            RouterState rState = (RouterState)o;
            equals = super.equals(rState) && (rState.buffers == null && this.buffers == null || rState.buffers.equals(this.buffers)) && rState.lines.equals(this.lines) && rState.processingTime == this.processingTime;
        }
        return equals;
    }
}

