/*
 * Decompiled with CFR 0.152.
 */
package events;

import events.ComponentState;
import java.util.LinkedList;
import java.util.List;

public class UnidirectionalLineState
extends ComponentState {
    private int sourceComponentId;
    private int targetComponentId;
    private int bandwidth;
    private int damagePercentage;
    private int losePercentage;
    private int length;
    private List<Integer> packets;
    private List<Integer> packetProgress;

    public UnidirectionalLineState(int ComponentId, boolean isNew, boolean isDeleted, int sourceComponentId, int targetComponentId, int bandwidth, int damagePercentage, int losePercentage, int length, List<Integer> packets, List<Integer> packetProgress) {
        super(ComponentId, isNew, isDeleted);
        this.sourceComponentId = sourceComponentId;
        this.targetComponentId = targetComponentId;
        this.bandwidth = bandwidth;
        this.damagePercentage = damagePercentage;
        this.losePercentage = losePercentage;
        this.length = length;
        this.packets = this.cloneIntegerList(packets);
        this.packetProgress = this.cloneIntegerList(packetProgress);
    }

    public int getSourceComponentId() {
        return this.sourceComponentId;
    }

    public int getTargetComponentId() {
        return this.targetComponentId;
    }

    public int getBandwidth() {
        return this.bandwidth;
    }

    public int getDamagePercentage() {
        return this.damagePercentage;
    }

    public int getLosePercentage() {
        return this.losePercentage;
    }

    public int getLength() {
        return this.length;
    }

    public List<Integer> getPackets() {
        return this.cloneIntegerList(this.packets);
    }

    public List<Integer> getPacketProgress() {
        return this.cloneIntegerList(this.packetProgress);
    }

    private List<Integer> cloneIntegerList(List<Integer> list) {
        if (list == null) {
            return null;
        }
        LinkedList<Integer> ret = new LinkedList<Integer>();
        for (int i : list) {
            ret.add(i);
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof UnidirectionalLineState) {
            UnidirectionalLineState uState = (UnidirectionalLineState)o;
            equals = super.equals(uState) && uState.bandwidth == this.bandwidth && uState.damagePercentage == this.damagePercentage && uState.length == this.length && uState.losePercentage == this.losePercentage && uState.packetProgress.equals(this.packetProgress) && uState.packets.equals(this.packets) && uState.sourceComponentId == this.sourceComponentId && uState.targetComponentId == this.targetComponentId;
        }
        return equals;
    }
}

