/*
 * Decompiled with CFR 0.152.
 */
package model;

import events.ComponentState;
import events.EventArgs;
import events.ProtocolState;
import events.ScenarioListChangeEventArgs;
import events.ScenarioState;
import events.Settings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import model.Scenario;
import model.parsing.ScenarioParser;
import model.parsing.xml.XmlParser;

public class Model
extends Observable
implements Observer {
    private Scenario activeScenario = new Scenario();

    public Model() {
        this.activeScenario.addObserver(this);
    }

    public void nextSimulationStep() {
        if (this.activeScenario != null) {
            this.activeScenario.step();
        }
    }

    public void resetScenario() {
        if (this.activeScenario != null) {
            this.activeScenario.reset();
        }
    }

    public void setProtocol(int protocolId) {
        if (this.activeScenario != null) {
            this.activeScenario.setProtocol(protocolId);
        }
    }

    public void setProtocolSettings(ProtocolState s) {
        if (this.activeScenario != null) {
            this.activeScenario.setProtocolSettings(s);
        }
    }

    public void changeObjectState(EventArgs e) {
        if (this.activeScenario != null) {
            this.activeScenario.changeObjectState(e);
        }
    }

    public ComponentState getComponentState(int componentId) {
        if (this.activeScenario != null) {
            return this.activeScenario.getComponentState(componentId);
        }
        return null;
    }

    public ProtocolState getProtocolState() {
        if (this.activeScenario != null) {
            return this.activeScenario.getProtocolState();
        }
        return null;
    }

    public ScenarioState getScenarioState() {
        if (this.activeScenario != null) {
            return this.activeScenario.getScenarioState();
        }
        return null;
    }

    public void setScenarioName(String name) {
        if (this.activeScenario != null) {
            this.activeScenario.setScenarioName(name);
        }
    }

    public boolean getSignificantChange() {
        if (this.activeScenario != null) {
            return this.activeScenario.getSignificantChange();
        }
        return false;
    }

    public void setActiveScenario(Scenario s) {
        if (this.activeScenario != null) {
            this.activeScenario.deleteObserver(this);
        }
        if (s != null) {
            s.addObserver(this);
        }
        this.activeScenario = s;
    }

    public void newScenario() {
        this.setActiveScenario(new Scenario());
    }

    public void openScenario(String path) throws IOException {
        XmlParser parser = new XmlParser(this);
        ((ScenarioParser)parser).loadScenario(path);
    }

    public void openScenario(int scenarioId) throws IOException {
        XmlParser parser = new XmlParser(this);
        ((ScenarioParser)parser).loadScenario(scenarioId);
    }

    public void exportScenario(int scenarioId, String path) throws IOException {
        XmlParser parser = new XmlParser(null);
        Scenario toSave = ((ScenarioParser)parser).loadScenario(scenarioId);
        ((ScenarioParser)parser).saveScenario(path, toSave);
    }

    public void saveScenario(String path) throws IOException {
        XmlParser parser = new XmlParser(null);
        ((ScenarioParser)parser).saveScenario(path, this.activeScenario);
    }

    public void saveScenario(int scenarioId) throws FileNotFoundException, IOException {
        XmlParser parser = new XmlParser(null);
        ((ScenarioParser)parser).saveScenario(scenarioId, this.activeScenario);
    }

    public void importScenario(String path, int scenarioId) throws IOException {
        XmlParser parser = new XmlParser(null);
        Scenario toSave = ((ScenarioParser)parser).loadScenario(path);
        ((ScenarioParser)parser).saveScenario(scenarioId, toSave);
    }

    public void removeScenario(int scenarioId) throws IOException {
        XmlParser parser = new XmlParser(null);
        ((ScenarioParser)parser).removeScenario(scenarioId);
    }

    public Settings loadSettings() throws IOException {
        XmlParser parser = new XmlParser(null);
        return ((ScenarioParser)parser).loadSettings();
    }

    public void saveSettings(Settings s) throws IOException {
        XmlParser parser = new XmlParser(null);
        ((ScenarioParser)parser).saveSettings(s);
    }

    public void renameScenario(String newName, int scenarioId) throws IOException {
        XmlParser parser = new XmlParser(null);
        ((ScenarioParser)parser).renameScenario(newName, scenarioId);
    }

    public void shiftScenario(int oldId, int newId) throws IOException {
        XmlParser parser = new XmlParser(null);
        ((ScenarioParser)parser).shiftScenario(oldId, newId);
    }

    @Override
    public void update(Observable o, Object arg1) {
        if (arg1 instanceof EventArgs) {
            this.sendNotify((EventArgs)arg1);
        }
    }

    public ScenarioListChangeEventArgs getScenarioList() {
        XmlParser parser = new XmlParser(null);
        LinkedList<String> list = new LinkedList();
        try {
            list = ((ScenarioParser)parser).getScenarioList();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ScenarioListChangeEventArgs(list);
    }

    private void sendNotify(EventArgs e) {
        this.setChanged();
        this.notifyObservers(e);
        this.clearChanged();
    }
}

