/*
 * Decompiled with CFR 0.152.
 */
package model;

import events.BidirectionalLineState;
import events.ComponentState;
import events.EventArgs;
import events.GoBackNState;
import events.HostState;
import events.PacketState;
import events.ProtocolState;
import events.RouterState;
import events.ScenarioState;
import events.SelectiveRepeatState;
import events.SignificantChangeEvent;
import events.StopAndWaitState;
import events.UnidirectionalLineState;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import model.Trace;
import model.TraceList;
import model.components.Component;
import model.components.devices.Device;
import model.components.devices.Host;
import model.components.devices.Router;
import model.components.devices.connections.GoBackN;
import model.components.devices.connections.Protocol;
import model.components.devices.connections.SelectiveRepeat;
import model.components.devices.connections.StopAndWait;
import model.components.lines.AbstractLine;
import model.components.lines.BidirectionalLine;
import model.components.lines.UnidirectionalLine;
import model.components.packets.Packet;

public class Scenario
extends Observable
implements Observer {
    protected final int STANDARD_TIMEOUT = 600;
    protected final int STANDARD_WINSIZE = 10;
    private String name = "";
    private int protocolId = 0;
    private Protocol protocol;
    private int protocolTimeout = 600;
    private int protocolWinSize = 10;
    private int stepCounter = 0;
    private boolean significantChange = false;
    private List<Device> devices = new LinkedList<Device>();
    private List<AbstractLine> lines = new LinkedList<AbstractLine>();
    private List<Packet> packets = new LinkedList<Packet>();

    public Scenario() {
        this.setProtocol(0);
    }

    public ScenarioState getScenarioState() {
        return new ScenarioState(this.name, this.protocolId);
    }

    public void setScenarioName(String name) {
        this.name = new String(name);
    }

    public void setProtocol(int protocolId) {
        if (this.protocol != null) {
            ProtocolState old = this.protocol.getProtocolSettings();
            this.protocolTimeout = old.getTimeout();
            switch (old.getProtocolId()) {
                case 1: 
                case 2: {
                    this.protocolWinSize = ((GoBackNState)old).getWinSize();
                    break;
                }
                case 3: 
                case 4: {
                    this.protocolWinSize = ((SelectiveRepeatState)old).getWinSize();
                }
            }
        }
        switch (protocolId) {
            case 0: {
                this.protocol = new StopAndWait(this);
                this.protocol.setProtocolSettings(new StopAndWaitState(this.protocolTimeout));
                break;
            }
            case 1: {
                this.protocol = new GoBackN(this);
                this.protocol.setProtocolSettings(new GoBackNState(this.protocolTimeout, this.protocolWinSize, false));
                break;
            }
            case 2: {
                this.protocol = new GoBackN(this);
                this.protocol.setProtocolSettings(new GoBackNState(this.protocolTimeout, this.protocolWinSize, true));
                break;
            }
            case 3: {
                this.protocol = new SelectiveRepeat(this);
                this.protocol.setProtocolSettings(new SelectiveRepeatState(this.protocolTimeout, this.protocolWinSize, false));
                break;
            }
            case 4: {
                this.protocol = new SelectiveRepeat(this);
                this.protocol.setProtocolSettings(new SelectiveRepeatState(this.protocolTimeout, this.protocolWinSize, true));
            }
        }
        this.protocolId = protocolId;
        for (Device d : this.devices) {
            d.setProtocol(this.protocol);
        }
        this.sendNotify(this.getProtocolState());
    }

    public ProtocolState getProtocolState() {
        return this.protocol.getProtocolSettings();
    }

    public void setProtocolSettings(ProtocolState s) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        try {
            this.protocol.setProtocolSettings(s);
        }
        catch (IllegalArgumentException e) {
            error = true;
            errorMessage = e.getMessage();
        }
        this.sendNotify(this.protocol.getProtocolSettings());
        for (Device d : this.devices) {
            try {
                d.setProtocolSettings(s);
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = e.getMessage();
            }
        }
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public void registerPacket(Packet p) {
        this.packets.add(p);
        p.addObserver(this);
        this.sendNotify(p.getComponentState());
    }

    public ComponentState getComponentState(int componentId) {
        Component c = this.getComponentById(componentId);
        if (c != null) {
            return c.getComponentState();
        }
        return null;
    }

    public void changeObjectState(EventArgs s) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        if (s instanceof ComponentState) {
            try {
                this.changeComponentState((ComponentState)s);
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
        } else {
            error = true;
            errorMessage = String.valueOf(errorMessage) + "Cannot handle with this type of EventArgs: " + s.getClass().getName();
        }
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public List<EventArgs> getWrapInformation() {
        LinkedList<EventArgs> eventArgs = new LinkedList<EventArgs>();
        for (Device device : this.devices) {
            eventArgs.add(device.getComponentState());
        }
        for (AbstractLine abstractLine : this.lines) {
            eventArgs.add(abstractLine.getComponentState());
        }
        for (Packet packet : this.packets) {
            eventArgs.add(packet.getComponentState());
        }
        eventArgs.add(new ScenarioState(this.getScenarioName(), this.protocolId));
        eventArgs.add(this.protocol.getProtocolSettings());
        return eventArgs;
    }

    public boolean getSignificantChange() {
        if (this.significantChange) {
            this.significantChange = false;
            return true;
        }
        return false;
    }

    @Override
    public void update(Observable observedObject, Object arg1) {
        if (arg1 instanceof EventArgs) {
            if (observedObject instanceof Packet && arg1 instanceof PacketState && ((PacketState)arg1).isDeleted()) {
                this.packets.remove((Packet)observedObject);
            }
            if (arg1 instanceof SignificantChangeEvent) {
                this.significantChange = true;
            } else {
                this.sendNotify((EventArgs)arg1);
            }
        }
    }

    public void step() {
        for (Device d : this.devices) {
            d.step(this.stepCounter);
        }
        for (AbstractLine l : this.lines) {
            l.step(this.stepCounter);
        }
        ++this.stepCounter;
    }

    public void reset() {
        for (Device d : this.devices) {
            d.reset();
        }
        for (AbstractLine l : this.lines) {
            l.reset();
        }
        this.stepCounter = 0;
        for (Packet p : this.packets) {
            this.sendRemoveNotify(p.getComponentState());
        }
        this.packets.clear();
    }

    private void changeComponentState(ComponentState s) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        if (s.isNew()) {
            try {
                this.createComponent(s);
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
        } else if (s.isDeleted()) {
            try {
                this.removeComponent(s);
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
        } else {
            try {
                this.getComponentById(s.getComponentId()).changeObjectState(s);
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
        }
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void createComponent(ComponentState s) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        if (s instanceof HostState) {
            try {
                this.createHost((HostState)s);
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
        } else if (s instanceof RouterState) {
            try {
                this.createRouter((RouterState)s);
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
        } else if (s instanceof BidirectionalLineState) {
            try {
                this.createBidirectionalLine((BidirectionalLineState)s);
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
        } else if (s instanceof UnidirectionalLineState) {
            try {
                this.createUnidirectionalLine((UnidirectionalLineState)s);
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
        }
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void createHost(HostState s) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        Host host = new Host();
        host.addObserver(this);
        this.devices.add(host);
        try {
            host.changeObjectState(s);
        }
        catch (IllegalArgumentException e) {
            error = true;
            errorMessage = String.valueOf(errorMessage) + e.getMessage();
        }
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void createRouter(RouterState s) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        Router router = new Router();
        router.addObserver(this);
        this.devices.add(router);
        try {
            router.changeObjectState(s);
        }
        catch (IllegalArgumentException e) {
            error = true;
            errorMessage = String.valueOf(errorMessage) + e.getMessage();
        }
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void createBidirectionalLine(BidirectionalLineState s) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        Device source = this.getDeviceById(s.getSourceDeviceId());
        Device target = this.getDeviceById(s.getTargetDeviceId());
        if (source instanceof Host && ((Host)source).hasLine()) {
            error = true;
            errorMessage = String.valueOf(errorMessage) + "Host " + ((Host)source).getComponentState().getName() + " already has a line";
        }
        if (target instanceof Host && ((Host)target).hasLine()) {
            error = true;
            errorMessage = String.valueOf(errorMessage) + "Host " + ((Host)target).getComponentState().getName() + " already has a line";
        }
        if (source == null || target == null) {
            error = true;
            errorMessage = String.valueOf(errorMessage) + "A Line needs two existing Devices";
        }
        if (!error) {
            BidirectionalLine line = new BidirectionalLine(source, target);
            line.addObserver(this);
            try {
                line.changeObjectState(s);
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
            source.addLine(line);
            target.addLine(line);
            this.lines.add(line);
            this.updateTraces();
        }
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void createUnidirectionalLine(UnidirectionalLineState s) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        Device source = this.getDeviceById(s.getSourceComponentId());
        Device target = this.getDeviceById(s.getTargetComponentId());
        if (source instanceof Host && ((Host)source).hasLine()) {
            error = true;
            errorMessage = String.valueOf(errorMessage) + "Host " + ((Host)source).getComponentState().getName() + " has already a line";
        }
        if (target instanceof Host && ((Host)target).hasLine()) {
            error = true;
            errorMessage = String.valueOf(errorMessage) + "Host " + ((Host)target).getComponentState().getName() + " has already a line";
        }
        if (source == null || target == null) {
            error = true;
            errorMessage = String.valueOf(errorMessage) + "A Line needs two existing Devices";
        }
        if (!error) {
            UnidirectionalLine line = new UnidirectionalLine(source, target);
            line.addObserver(this);
            this.lines.add(line);
            try {
                line.changeObjectState(s);
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
            source.addLine(line);
            target.addLine(line);
            this.updateTraces();
        }
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void removeComponent(ComponentState s) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        Component component = this.getComponentById(s.getComponentId());
        if (component == null) {
            error = true;
            errorMessage = String.valueOf(errorMessage) + "The Component that should be deleted does not exist!";
        }
        if (!error) {
            if (component instanceof Host) {
                this.removeHost((Host)component);
            } else if (component instanceof Router) {
                this.removeRouter((Router)component);
            } else if (component instanceof BidirectionalLine) {
                this.removeBidirectionalLine((BidirectionalLine)component);
            } else if (component instanceof UnidirectionalLine) {
                this.removeUnidirectionalLine((UnidirectionalLine)component);
            } else {
                error = true;
                errorMessage = String.valueOf(errorMessage) + "Cannot handle with this tpye of Component: " + component.getClass().getName();
            }
            if (error) {
                throw new IllegalArgumentException(errorMessage);
            }
            this.updateTraces();
        }
    }

    private void removeHost(Host host) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        HostState hostState = host.getComponentState();
        AbstractLine line = this.getLineById(hostState.getLineId());
        if (line != null) {
            try {
                if (line instanceof BidirectionalLine) {
                    this.removeBidirectionalLine((BidirectionalLine)line);
                } else if (line instanceof UnidirectionalLine) {
                    this.removeUnidirectionalLine((UnidirectionalLine)line);
                }
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
        }
        host.prepareToRemove();
        this.devices.remove(host);
        this.sendRemoveNotify(host.getComponentState());
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void removeRouter(Router router) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        RouterState routerState = router.getComponentState();
        for (int lineId : routerState.getLines()) {
            AbstractLine line = this.getLineById(lineId);
            if (line == null) continue;
            try {
                if (line instanceof BidirectionalLine) {
                    this.removeBidirectionalLine((BidirectionalLine)line);
                    continue;
                }
                if (!(line instanceof UnidirectionalLine)) continue;
                this.removeUnidirectionalLine((UnidirectionalLine)line);
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
        }
        this.devices.remove(router);
        this.sendRemoveNotify(router.getComponentState());
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void removeBidirectionalLine(BidirectionalLine line) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        BidirectionalLineState lineState = (BidirectionalLineState)line.getComponentState();
        Device device = this.getDeviceById(lineState.getSourceDeviceId());
        if (device != null) {
            device.removeLine(line);
        } else {
            error = true;
            errorMessage = "Device to remove line doesn't exist;";
        }
        device = this.getDeviceById(lineState.getTargetDeviceId());
        if (device != null) {
            device.removeLine(line);
        } else {
            error = true;
            errorMessage = "Device to remove line doesn't exist;";
        }
        this.lines.remove(line);
        this.sendRemoveNotify(line.getComponentState());
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void removeUnidirectionalLine(UnidirectionalLine line) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        UnidirectionalLineState lineState = line.getComponentState();
        Device device = this.getDeviceById(lineState.getSourceComponentId());
        if (device != null) {
            device.removeLine(line);
        } else {
            error = true;
            errorMessage = "Device to remove line doesn't exist;";
        }
        device = this.getDeviceById(lineState.getTargetComponentId());
        if (device != null) {
            device.removeLine(line);
        } else {
            error = true;
            errorMessage = "Device to remove line doesn't exist;";
        }
        this.lines.remove(line);
        this.sendRemoveNotify(line.getComponentState());
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void sendRemoveNotify(ComponentState c) {
        int componentId = c.getComponentId();
        ComponentState cRemove = null;
        if (c instanceof HostState) {
            cRemove = new HostState(componentId, false, true, null, null, -1, -1, null, -1, ((HostState)c).getConnections());
        } else if (c instanceof RouterState) {
            cRemove = new RouterState(componentId, false, true, null, null, -1, -1, -1, null, null);
        } else if (c instanceof BidirectionalLineState) {
            cRemove = new BidirectionalLineState(componentId, false, true, -1, -1, null, null);
        } else if (c instanceof UnidirectionalLineState) {
            cRemove = new UnidirectionalLineState(componentId, false, true, -1, -1, -1, -1, -1, -1, null, null);
        } else if (c instanceof PacketState) {
            cRemove = new PacketState(componentId, false, true, false, false, -1, -1, -1);
        }
        if (cRemove != null) {
            this.sendNotify(cRemove);
        }
    }

    private Component getComponentById(int componentId) {
        Component ret = null;
        ret = this.getDeviceById(componentId);
        if (ret == null && (ret = this.getLineById(componentId)) == null) {
            ret = this.getPacketById(componentId);
        }
        return ret;
    }

    private Device getDeviceById(int deviceId) {
        for (Device d : this.devices) {
            if (d.getId() != deviceId) continue;
            return d;
        }
        return null;
    }

    private AbstractLine getLineById(int lineId) {
        for (AbstractLine l : this.lines) {
            if (l.getId() != lineId) continue;
            return l;
        }
        return null;
    }

    private Packet getPacketById(int packetId) {
        for (Packet p : this.packets) {
            if (p.getId() != packetId) continue;
            return p;
        }
        return null;
    }

    private void updateTraces() {
        int deviceCount = this.devices.size();
        boolean[] deviceIsHost = new boolean[deviceCount];
        int[] deviceIds = new int[deviceCount];
        int i = 0;
        for (Device c : this.devices) {
            if (c instanceof Host) {
                deviceIsHost[i] = true;
            }
            deviceIds[i] = c.getId();
            ++i;
        }
        int[][] lineMatrix = new int[deviceCount][deviceCount];
        boolean[][] adjacencyMatrix = new boolean[deviceCount][deviceCount];
        i = 0;
        while (i < deviceCount) {
            List<Integer[]> targetDataList = this.getDeviceById(deviceIds[i]).getTargetDataList();
            if (targetDataList != null) {
                for (Integer[] targetData : targetDataList) {
                    int currentNewDeviceId = this.getNewDeviceId(targetData[0], deviceIds);
                    adjacencyMatrix[i][currentNewDeviceId] = true;
                    lineMatrix[i][currentNewDeviceId] = targetData[1];
                }
            }
            ++i;
        }
        TraceList[] allTraces = new TraceList[deviceCount];
        int newDeviceId = 0;
        while (newDeviceId < deviceCount) {
            if (this.getDeviceById(deviceIds[newDeviceId]) != null && this.getDeviceById(deviceIds[newDeviceId]) instanceof Host) {
                allTraces[newDeviceId] = new TraceList();
            }
            ++newDeviceId;
        }
        newDeviceId = 0;
        while (newDeviceId < deviceIds.length) {
            if (deviceIsHost[newDeviceId]) {
                List<Trace> hostTraces = this.findHostTraces(newDeviceId, deviceIds, adjacencyMatrix, lineMatrix, deviceIsHost);
                for (Trace t : hostTraces) {
                    allTraces[newDeviceId].addTrace(t);
                    allTraces[this.getNewDeviceId(t.getTargetHostId(), deviceIds)].addBackTrace(t);
                }
            }
            ++newDeviceId;
        }
        newDeviceId = 0;
        while (newDeviceId < deviceIds.length) {
            if (this.getDeviceById(deviceIds[newDeviceId]) instanceof Host) {
                ((Host)this.getDeviceById(deviceIds[newDeviceId])).updateTraceList(allTraces[newDeviceId].getTraces(), this.protocol.clone());
            }
            ++newDeviceId;
        }
    }

    private List<Trace> findHostTraces(int sourceHostId, int[] deviceIds, boolean[][] adjacencyMatrix, int[][] lineMatrix, boolean[] deviceIsHost) {
        boolean[] hasBeenVisited = new boolean[deviceIds.length];
        Trace[] traces = new Trace[deviceIds.length];
        hasBeenVisited[sourceHostId] = true;
        LinkedList<Integer> newVertices = new LinkedList<Integer>();
        newVertices.add(sourceHostId);
        while (!newVertices.isEmpty()) {
            LinkedList<Integer> nextNewVertices = new LinkedList<Integer>();
            Iterator iterator = newVertices.iterator();
            while (iterator.hasNext()) {
                int actualSourceVertex = (Integer)iterator.next();
                hasBeenVisited[actualSourceVertex] = true;
            }
            iterator = newVertices.iterator();
            while (iterator.hasNext()) {
                int currentSourceVertex = (Integer)iterator.next();
                int i = 0;
                while (i < adjacencyMatrix[currentSourceVertex].length) {
                    if (adjacencyMatrix[currentSourceVertex][i] && !hasBeenVisited[i]) {
                        nextNewVertices.add(i);
                        LinkedList<Integer> lineIds = traces[currentSourceVertex] != null ? new LinkedList<Integer>(traces[currentSourceVertex].getLineIds()) : new LinkedList<Integer>();
                        lineIds.add(lineMatrix[currentSourceVertex][i]);
                        traces[i] = new Trace(lineIds, deviceIds[sourceHostId]);
                    }
                    ++i;
                }
            }
            newVertices = nextNewVertices;
        }
        LinkedList<Trace> hostTraces = new LinkedList<Trace>();
        int i = 0;
        while (i < traces.length) {
            if (deviceIsHost[i] && traces[i] != null) {
                traces[i].setTargetHost((Host)this.getDeviceById(deviceIds[i]));
                hostTraces.add(traces[i]);
            }
            ++i;
        }
        return hostTraces;
    }

    private int getNewDeviceId(int hostId, int[] deviceIds) {
        int i = 0;
        while (i < deviceIds.length) {
            if (deviceIds[i] == hostId) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String getScenarioName() {
        if (this.name != null) {
            return new String(this.name);
        }
        return "";
    }

    private void sendNotify(EventArgs e) {
        this.setChanged();
        this.notifyObservers(e);
        this.clearChanged();
    }
}

