/*
 * Decompiled with CFR 0.152.
 */
package model;

import events.TraceData;
import java.util.LinkedList;
import java.util.List;
import model.components.devices.Host;

public class Trace {
    private List<Integer> lineIds = new LinkedList<Integer>();
    private Host targetHost;
    private int sourceHostId;

    private Trace() {
    }

    public Trace(Host targetHost, int sourceHostId) {
        this.targetHost = targetHost;
        this.sourceHostId = sourceHostId;
    }

    public Trace(Host targetHost, List<Integer> lineIds, int sourceHostId) {
        this.targetHost = targetHost;
        this.sourceHostId = sourceHostId;
        for (int i : lineIds) {
            this.lineIds.add(i);
        }
    }

    public Trace(List<Integer> lineIds, int sourceHostId) {
        this.sourceHostId = sourceHostId;
        for (int i : lineIds) {
            this.lineIds.add(i);
        }
    }

    public void addLine(int lineId) {
        if (this.targetHost == null) {
            this.lineIds.add(lineId);
        }
    }

    public int getLine(int index) {
        if (index < this.lineIds.size()) {
            return this.lineIds.get(index);
        }
        return -1;
    }

    public List<Integer> getLineIds() {
        return new LinkedList<Integer>(this.lineIds);
    }

    public Host getTargetHost() {
        return this.targetHost;
    }

    public void setTargetHost(Host targetHost) {
        if (this.targetHost == null) {
            this.targetHost = targetHost;
        }
    }

    public int getTargetHostId() {
        if (this.targetHost != null) {
            return this.targetHost.getId();
        }
        return -1;
    }

    public int getSourceHostId() {
        return this.sourceHostId;
    }

    public TraceData getData() {
        return new TraceData(new LinkedList<Integer>(this.lineIds));
    }
}

