/*
 * Decompiled with CFR 0.152.
 */
package model;

import events.TraceData;
import java.util.LinkedList;
import java.util.List;
import model.Trace;
import model.components.devices.Host;

class TraceList {
    private List<Trace[]> tracesList = new LinkedList<Trace[]>();
    private List<Trace[]> importantTracesList = new LinkedList<Trace[]>();

    TraceList() {
    }

    void addTrace(Trace t) {
        Trace[] traces = this.findTraces(t, true);
        if (traces != null) {
            traces[0] = this.clone(t);
        } else {
            traces = new Trace[2];
            traces[0] = this.clone(t);
            this.tracesList.add(traces);
        }
        this.importantTracesList.add(traces);
    }

    void addBackTrace(Trace t) {
        Trace[] traces = this.findTraces(t, false);
        if (traces != null) {
            traces[1] = this.clone(t);
        } else {
            traces = new Trace[2];
            traces[1] = this.clone(t);
            this.tracesList.add(traces);
        }
    }

    List<Trace[]> getTraces() {
        return this.importantTracesList;
    }

    private Trace[] findTraces(Trace t, boolean isSource) {
        if (isSource) {
            for (Trace[] traces : this.tracesList) {
                if (traces[1] == null || traces[1].getSourceHostId() != t.getTargetHostId()) continue;
                return traces;
            }
        } else {
            for (Trace[] traces : this.tracesList) {
                if (traces[0] == null || traces[0].getTargetHostId() != t.getSourceHostId()) continue;
                return traces;
            }
        }
        return null;
    }

    private Trace clone(Trace t) {
        TraceData data = t.getData();
        Host targetHost = t.getTargetHost();
        int sourceHostId = t.getSourceHostId();
        return new Trace(targetHost, data.getLines(), sourceHostId);
    }

    public String toString() {
        String ret = "";
        int i = 1;
        for (Trace[] traces : this.tracesList) {
            ret = String.valueOf(ret) + "zu Host" + i;
            if (traces[0] != null) {
                ret = String.valueOf(ret) + "   Trace IDs:" + traces[0].getLineIds() + "\n";
            }
            if (traces[1] != null) {
                ret = String.valueOf(ret) + "   BackTrace IDs:" + traces[1].getLineIds() + "\n";
            }
            ++i;
        }
        return ret;
    }
}

