/*
 * Decompiled with CFR 0.152.
 */
package model.components;

import events.ComponentState;
import events.EventArgs;
import events.ProtocolState;
import java.util.Observable;
import model.components.devices.connections.Protocol;
import model.components.lines.AbstractLine;
import model.components.packets.Packet;

public abstract class Component
extends Observable {
    private final int id = maxId++;
    private static int maxId = 0;
    private boolean isNew = true;

    public void setProtocol(Protocol p) {
    }

    public void setProtocolSettings(ProtocolState s) {
    }

    public abstract void step(int var1);

    public abstract void changeObjectState(ComponentState var1) throws IllegalArgumentException;

    public void reset() {
    }

    public abstract ComponentState getComponentState();

    public final int getId() {
        return this.id;
    }

    public void receive(Packet p, AbstractLine line) {
    }

    protected final boolean isNew() {
        if (this.isNew) {
            this.isNew = false;
            return true;
        }
        return false;
    }

    protected final void sendNotify(EventArgs e) {
        this.setChanged();
        this.notifyObservers(e);
        this.clearChanged();
    }
}

