/*
 * Decompiled with CFR 0.152.
 */
package model.components.buffers;

import events.BufferState;
import events.ComponentState;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import model.components.Component;
import model.components.packets.Packet;

public abstract class Buffer
extends Component {
    protected static final int DEFAULT_CAPACITY = 42;
    protected static final int NULL_CAPACITY = -1;
    protected int capacity = 42;
    protected List<Packet> packets = new LinkedList<Packet>();

    @Override
    public void changeObjectState(ComponentState s) throws IllegalArgumentException {
        if (s == null) {
            return;
        }
        boolean error = false;
        String errorMessage = "";
        if (s instanceof BufferState) {
            int capacity = ((BufferState)s).getCapacity();
            if (capacity > -1 && capacity <= 1000) {
                this.capacity = capacity;
            } else if (capacity < -1 || capacity > 1000) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + "Illegal value for capacity: " + capacity + ";";
                this.capacity = 42;
            }
        } else {
            error = true;
            errorMessage = String.valueOf(errorMessage) + "Wrong state-type for BufferState;";
        }
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public BufferState getComponentState() {
        return new BufferState(this.getId(), this.isNew(), false, this.capacity, this.getPacketIds());
    }

    @Override
    public void step(int counter) {
    }

    public Packet popFront() {
        Packet p = null;
        if (!this.packets.isEmpty()) {
            p = this.packets.get(0);
            this.packets.remove(0);
        }
        return p;
    }

    public Packet top() {
        Packet p = null;
        if (!this.packets.isEmpty()) {
            p = this.packets.get(0);
        }
        return p;
    }

    public boolean pushBack(Packet p) {
        boolean ret = false;
        if (this.packets.size() < this.capacity) {
            this.packets.add(p);
            ret = true;
        }
        return ret;
    }

    public void clearBuffer() {
        this.packets.clear();
    }

    public boolean deleteFromBuffer(int sequenceNumber) {
        boolean deleted = false;
        Iterator<Packet> itr = this.packets.iterator();
        while (itr.hasNext()) {
            Packet p = itr.next();
            if (p.getSequenceNumber() != sequenceNumber) continue;
            itr.remove();
            p.lose();
            deleted = true;
        }
        return deleted;
    }

    public boolean deleteFromBuffer(Packet packet) {
        boolean deleted = false;
        Iterator<Packet> itr = this.packets.iterator();
        while (itr.hasNext()) {
            Packet p = itr.next();
            if (!p.equalsPacket(packet)) continue;
            itr.remove();
            deleted = true;
        }
        return deleted;
    }

    public Packet getPacket(int sequenceNumber) {
        Packet returnPacket = null;
        Iterator<Packet> itr = this.packets.iterator();
        while (returnPacket == null && itr.hasNext()) {
            Packet p = itr.next();
            if (p.getSequenceNumber() != sequenceNumber) continue;
            returnPacket = p;
        }
        return returnPacket;
    }

    public List<Integer> getPacketSequenceNumbers() {
        LinkedList<Integer> sequenceNumbers = new LinkedList<Integer>();
        for (Packet p : this.packets) {
            sequenceNumbers.add(p.getSequenceNumber());
        }
        return sequenceNumbers;
    }

    public int getCapacity() {
        return this.capacity;
    }

    private List<Integer> getPacketIds() {
        LinkedList<Integer> packetIds = new LinkedList<Integer>();
        for (Packet p : this.packets) {
            packetIds.add(p.getId());
        }
        return packetIds;
    }
}

