/*
 * Decompiled with CFR 0.152.
 */
package model.components.devices;

import events.BidirectionalLineState;
import events.BufferState;
import events.ComponentState;
import events.ConnectionData;
import events.HostState;
import events.ProtocolState;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import model.Trace;
import model.components.buffers.SendBuffer;
import model.components.devices.Device;
import model.components.devices.connections.Connection;
import model.components.devices.connections.Protocol;
import model.components.lines.AbstractLine;
import model.components.packets.DataPacket;
import model.components.packets.Packet;
import model.components.packets.ResponsePacket;

public class Host
extends Device {
    private AbstractLine line;
    private SendBuffer sendBuffer = new SendBuffer();
    private List<Connection> outgoingConnections = new LinkedList<Connection>();
    private List<Connection> incomingConnections = new LinkedList<Connection>();

    public Host() {
        this.name = "Host " + this.getId();
    }

    @Override
    public void changeObjectState(ComponentState s) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        if (s instanceof HostState) {
            HostState state = (HostState)s;
            if (state.getName() != null) {
                try {
                    this.name = new String(state.getName());
                }
                catch (IllegalArgumentException e) {
                    error = true;
                    errorMessage = String.valueOf(errorMessage) + e.getMessage();
                }
            }
            if (state.getColor() != null) {
                try {
                    this.color = new Color(state.getColor().getRGB());
                }
                catch (IllegalArgumentException e) {
                    error = true;
                    errorMessage = String.valueOf(errorMessage) + e.getMessage();
                }
            }
            try {
                this.position.setX(state.getX());
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
            try {
                this.position.setY(state.getY());
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
            if (state.getBufferState() != null) {
                if (this.sendBuffer != null && this.sendBuffer.getId() == state.getBufferState().getComponentId()) {
                    try {
                        this.sendBuffer.changeObjectState(state.getBufferState());
                    }
                    catch (IllegalArgumentException e) {
                        error = true;
                        errorMessage = String.valueOf(errorMessage) + e.getMessage();
                    }
                } else {
                    error = true;
                    errorMessage = String.valueOf(errorMessage) + "Buffer " + state.getBufferState().getComponentId() + " does not exist in this Host;";
                }
            }
            if (state.getConnections() != null) {
                for (ConnectionData data : state.getConnections()) {
                    boolean connectionHasBeenFound = false;
                    for (Connection connection : this.outgoingConnections) {
                        if (data.getTargetHostId() != connection.getTargetHostId()) continue;
                        connectionHasBeenFound = true;
                        connection.changeState(data);
                    }
                    if (connectionHasBeenFound) continue;
                    error = true;
                    errorMessage = String.valueOf(errorMessage) + "The connection to a connection Data has not been found in Host " + this.getId() + "to Host " + data.getTargetHostId() + ";";
                }
            }
            this.sendNotify(this.getComponentState());
        } else {
            error = true;
            errorMessage = String.valueOf(errorMessage) + "Wrong state-type for HostState;";
        }
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public void addLine(AbstractLine line) {
        this.line = line;
        this.sendNotify(this.getComponentState());
    }

    @Override
    public List<Integer[]> getTargetDataList() {
        LinkedList<Integer[]> targetDataList = new LinkedList<Integer[]>();
        if (this.line != null) {
            int targetId = this.line.getTargetDeviceId(this.getId());
            if (this.getId() != targetId && targetId != -1) {
                Integer[] targetData = new Integer[]{targetId, this.line.getId()};
                targetDataList.add(targetData);
            }
        }
        return targetDataList;
    }

    @Override
    public HostState getComponentState() {
        int lineId = -1;
        if (this.line != null) {
            lineId = this.line.getId();
        }
        BufferState bufferState = null;
        if (this.sendBuffer != null) {
            bufferState = this.sendBuffer.getComponentState();
        }
        return new HostState(this.getId(), this.isNew(), false, new String(this.name), this.color, this.position.getX(), this.position.getY(), bufferState, lineId, this.getConnectionData());
    }

    @Override
    public void step(int counter) {
        Packet p = this.sendBuffer.top();
        if (p != null && counter > p.getCurrentStep() && this.line.send(p, this.getId())) {
            p.step(counter);
            this.sendBuffer.popFront();
        }
        for (Connection c : this.outgoingConnections) {
            c.step(counter);
        }
        this.sendNotify(this.getComponentState());
    }

    @Override
    public void removeLine(AbstractLine line) {
        this.line = null;
    }

    @Override
    public void setProtocol(Protocol p) {
        for (Connection c : this.outgoingConnections) {
            c.setProtocol(p);
        }
    }

    @Override
    public void setProtocolSettings(ProtocolState p) {
        for (Connection c : this.outgoingConnections) {
            c.setProtocolSettings(p);
        }
        this.sendNotify(this.getComponentState());
    }

    @Override
    public void receive(Packet p, AbstractLine line) {
        boolean received = false;
        if (p instanceof DataPacket) {
            Iterator<Connection> itr = this.incomingConnections.iterator();
            while (!received && itr.hasNext()) {
                received = itr.next().receive(p);
            }
        } else if (p instanceof ResponsePacket) {
            Iterator<Connection> itr = this.outgoingConnections.iterator();
            while (!received && itr.hasNext()) {
                received = itr.next().receiveResponse(p);
            }
        }
        this.sendNotify(this.getComponentState());
    }

    @Override
    public void reset() {
        this.sendBuffer.clearBuffer();
        for (Connection c : this.outgoingConnections) {
            c.reset();
        }
        this.sendNotify(this.getComponentState());
    }

    public void send(Packet p) {
        this.sendBuffer.pushBack(p);
    }

    public void updateTraceList(List<Trace[]> traceList, Protocol p) {
        LinkedList<Connection> newConnections = new LinkedList<Connection>();
        if (traceList != null) {
            for (Trace[] trace : traceList) {
                boolean traceTargetExists = false;
                if (this.outgoingConnections != null) {
                    for (Connection connection : this.outgoingConnections) {
                        if (traceTargetExists || !connection.updateTrace(trace)) continue;
                        newConnections.add(connection);
                        traceTargetExists = true;
                    }
                }
                if (traceTargetExists) continue;
                newConnections.add(new Connection(this, trace[0], trace[1], p));
            }
        }
        if (this.outgoingConnections != null) {
            for (Connection connection : this.outgoingConnections) {
                if (newConnections.contains(connection)) continue;
                ConnectionData cD = connection.getData();
                BufferState bS = cD.getIncomingBufferState();
                this.sendNotify(new BufferState(bS.getComponentId(), false, true, -1, null));
                bS = cD.getOutgoingBufferState();
                this.sendNotify(new BufferState(bS.getComponentId(), false, true, -1, null));
                connection.prepareToRemove();
            }
        }
        this.outgoingConnections = newConnections;
        this.sendNotify(this.getComponentState());
    }

    public void prepareToRemove() {
        if (this.outgoingConnections != null) {
            for (Connection c : this.outgoingConnections) {
                c.prepareToRemove();
            }
        }
    }

    public void addIncomingConnection(Connection c) {
        this.incomingConnections.add(c);
    }

    public void removeIncomingConnection(Connection c) {
        this.incomingConnections.remove(c);
    }

    public int getBandwidth() {
        int bandwidth = -1;
        if (this.line != null) {
            BidirectionalLineState lineState = (BidirectionalLineState)this.line.getComponentState();
            int sourceDeviceId = lineState.getSourceDeviceId();
            bandwidth = sourceDeviceId == this.getId() ? lineState.getFromSourceToTargetLineState().getBandwidth() : lineState.getFromTargetToSourceLineState().getBandwidth();
        }
        return bandwidth;
    }

    public boolean hasLine() {
        return this.line != null;
    }

    private List<ConnectionData> getConnectionData() {
        LinkedList<ConnectionData> connectionData = new LinkedList<ConnectionData>();
        for (Connection c : this.outgoingConnections) {
            ConnectionData cData = c.getData();
            connectionData.add(cData);
        }
        return connectionData;
    }

    public boolean deleteFromSendBuffer(Packet p) {
        return this.sendBuffer.deleteFromBuffer(p);
    }
}

