/*
 * Decompiled with CFR 0.152.
 */
package model.components.devices;

import events.BufferState;
import events.ComponentState;
import events.RouterState;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import model.components.buffers.Buffer;
import model.components.buffers.IncomingBuffer;
import model.components.buffers.SendBuffer;
import model.components.devices.Device;
import model.components.lines.AbstractLine;
import model.components.packets.Packet;

public class Router
extends Device {
    private final int MIN_PROCESSING_TIME = 0;
    private final int MAX_PROCESSING_TIME = 1000;
    private int processingTime;
    private List<AbstractLine> lines = new LinkedList<AbstractLine>();
    private List<IncomingBuffer> incomingBuffers = new LinkedList<IncomingBuffer>();
    private List<SendBuffer> sendBuffers = new LinkedList<SendBuffer>();
    private SendBuffer sendBuffer = new SendBuffer();
    private int timeLeft = this.processingTime;

    public Router() {
        this.name = "Router " + this.getId();
    }

    @Override
    public void receive(Packet p, AbstractLine line) {
        if (this.incomingBuffers.get(this.lines.indexOf(line)).pushBack(p)) {
            if (this.sendBuffer.top() == null) {
                this.timeLeft = this.processingTime;
            }
            this.sendBuffer.pushBack(p);
        } else {
            p.lose();
        }
        this.sendNotify(this.getComponentState());
    }

    @Override
    public void changeObjectState(ComponentState s) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        if (s instanceof RouterState) {
            RouterState state = (RouterState)s;
            if (state.getName() != null) {
                this.name = new String(state.getName());
            }
            if (state.getColor() != null) {
                try {
                    this.color = new Color(state.getColor().getRGB());
                }
                catch (IllegalArgumentException e) {
                    error = true;
                    errorMessage = String.valueOf(errorMessage) + e.getMessage();
                }
            }
            try {
                this.position.setX(state.getX());
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
            try {
                this.position.setY(state.getY());
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
            int processingTime = state.getProcessingTime();
            if (processingTime > -1 && processingTime <= 1000) {
                this.processingTime = processingTime;
            } else if (processingTime < -1) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + "Illegal value for processingTime: " + processingTime + ";";
                this.processingTime = 0;
            } else if (processingTime > 1000) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + "Illegal value for processingTime: " + processingTime + ";";
                this.processingTime = 1000;
            }
            if (state.getBuffers() != null && !state.getBuffers().isEmpty()) {
                for (BufferState bufferState : state.getBuffers()) {
                    if (bufferState != null) {
                        Buffer buffer = this.getBufferById(bufferState.getComponentId());
                        if (buffer != null) {
                            try {
                                buffer.changeObjectState(bufferState);
                            }
                            catch (IllegalArgumentException e) {
                                error = true;
                                errorMessage = String.valueOf(errorMessage) + e.getMessage();
                            }
                            continue;
                        }
                        error = true;
                        errorMessage = String.valueOf(errorMessage) + "Buffer " + bufferState.getComponentId() + " does not exist in this Router;";
                        continue;
                    }
                    error = true;
                    errorMessage = String.valueOf(errorMessage) + "BufferState shouldn't be null;";
                }
            }
            this.sendNotify(this.getComponentState());
        } else {
            error = true;
            errorMessage = String.valueOf(errorMessage) + "Wrong state-type for HostState;";
        }
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public RouterState getComponentState() {
        return new RouterState(this.getId(), this.isNew(), false, new String(this.name), this.color, this.position.getX(), this.position.getY(), this.processingTime, this.getLineIds(), this.getBufferStates());
    }

    @Override
    public void step(int counter) {
        boolean stateChanged = false;
        Packet p = this.sendBuffer.top();
        if (p != null) {
            --this.timeLeft;
            if (this.timeLeft < 0) {
                int nextLineId = p.getNextLineId();
                AbstractLine nextLine = null;
                for (AbstractLine a : this.lines) {
                    if (a.getId() != nextLineId) continue;
                    nextLine = a;
                }
                boolean sent = nextLine.send(p, this.getId());
                if (sent) {
                    this.sendBuffer.popFront();
                    for (IncomingBuffer b : this.incomingBuffers) {
                        if (b.top() != p) continue;
                        b.popFront();
                    }
                    p.step(counter);
                    this.timeLeft = this.processingTime;
                    stateChanged = true;
                }
            }
        }
        if (stateChanged) {
            this.sendNotify(this.getComponentState());
        }
    }

    @Override
    public void reset() {
        this.timeLeft = this.processingTime;
        this.sendBuffer.clearBuffer();
        for (Buffer buffer : this.incomingBuffers) {
            buffer.clearBuffer();
        }
        this.sendNotify(this.getComponentState());
    }

    @Override
    public void addLine(AbstractLine line) {
        this.lines.add(line);
        this.incomingBuffers.add(new IncomingBuffer());
        this.sendBuffers.add(new SendBuffer());
        this.sendNotify(this.getComponentState());
    }

    @Override
    public void removeLine(AbstractLine line) {
        int index = this.lines.indexOf(line);
        if (index >= 0) {
            this.lines.remove(index);
            Buffer b = this.incomingBuffers.get(index);
            BufferState bs = new BufferState(b.getId(), false, true, -1, null);
            this.sendNotify(bs);
            this.incomingBuffers.remove(index);
            this.sendBuffers.remove(index);
        }
        this.sendNotify(this.getComponentState());
    }

    @Override
    public List<Integer[]> getTargetDataList() {
        LinkedList<Integer[]> targetDataList = new LinkedList<Integer[]>();
        for (AbstractLine line : this.lines) {
            if (line == null) continue;
            int targetId = line.getTargetDeviceId(this.getId());
            if (this.getId() == targetId) continue;
            Integer[] targetData = new Integer[]{targetId, line.getId()};
            targetDataList.add(targetData);
        }
        return targetDataList;
    }

    private List<Integer> getLineIds() {
        LinkedList<Integer> lineIds = new LinkedList<Integer>();
        for (AbstractLine line : this.lines) {
            lineIds.add(line.getId());
        }
        return lineIds;
    }

    private List<BufferState> getBufferStates() {
        LinkedList<BufferState> bufferStates = new LinkedList<BufferState>();
        for (Buffer buffer : this.incomingBuffers) {
            if (buffer == null) continue;
            bufferStates.add(buffer.getComponentState());
        }
        return bufferStates;
    }

    private Buffer getBufferById(int bufferId) {
        for (Buffer buffer : this.incomingBuffers) {
            if (buffer.getId() != bufferId) continue;
            return buffer;
        }
        return null;
    }
}

