/*
 * Decompiled with CFR 0.152.
 */
package model.components.devices.connections;

import events.BufferState;
import events.ConnectionData;
import events.ProtocolState;
import events.TraceData;
import java.util.List;
import model.Trace;
import model.components.buffers.IncomingBuffer;
import model.components.buffers.OutgoingBuffer;
import model.components.devices.Host;
import model.components.devices.connections.Protocol;
import model.components.devices.connections.ProtocolHandler;
import model.components.packets.Packet;
import model.components.packets.SimpleDataPacket;

public class Connection {
    private Host sourceHost;
    private Host targetHost;
    private Trace trace;
    private Trace backTrace;
    private final int MAX_BANDWIDTH = 100;
    private final int DEFAULT_BANDWIDTH = 50;
    private int bandwidth = 50;
    private IncomingBuffer incomingBuffer;
    private OutgoingBuffer outgoingBuffer;
    private ProtocolHandler protocolHandler;

    public Connection(Host sourceHost, Trace trace, Trace backTrace, Protocol protocol) {
        this.trace = trace;
        this.backTrace = backTrace;
        this.protocolHandler = new ProtocolHandler(this, protocol);
        this.sourceHost = sourceHost;
        if (this.trace != null) {
            this.targetHost = this.trace.getTargetHost();
            this.targetHost.addIncomingConnection(this);
        }
        this.incomingBuffer = new IncomingBuffer();
        this.outgoingBuffer = new OutgoingBuffer();
    }

    public void setProtocol(Protocol p) {
        this.protocolHandler.setProtocol(p);
    }

    public void setProtocolSettings(ProtocolState s) {
        this.protocolHandler.setProtocolSettings(s);
    }

    public boolean receive(Packet p) {
        boolean ret = false;
        if (p.getSource() == this.sourceHost) {
            if (this.incomingBuffer.pushBack(p)) {
                ret = this.protocolHandler.receivePacket(p);
            } else {
                p.lose();
                ret = true;
            }
        }
        return ret;
    }

    public boolean receiveResponse(Packet p) {
        if (p.getSource() == this.targetHost) {
            return this.protocolHandler.receiveResponsePacket(p);
        }
        return false;
    }

    public void step(int stepcount) {
        if (this.bandwidth > 0) {
            this.incomingBuffer.step(stepcount);
            this.outgoingBuffer.step(stepcount);
            this.protocolHandler.step(stepcount);
        }
    }

    public void reset() {
        this.protocolHandler.resetProtocol();
    }

    protected void clearOutgoingBuffer() {
        this.deleteFromSendBuffer();
        this.outgoingBuffer.clearBuffer();
    }

    protected void clearIncomingBuffer() {
        this.incomingBuffer.clearBuffer();
    }

    protected boolean deleteFromIncomingBuffer(int sequenceNumber) {
        return this.incomingBuffer.deleteFromBuffer(sequenceNumber);
    }

    protected boolean deleteFromOutgoingBuffer(int sequenceNumber) {
        Packet p = this.outgoingBuffer.getPacket(sequenceNumber);
        if (p instanceof SimpleDataPacket) {
            this.sourceHost.deleteFromSendBuffer((SimpleDataPacket)p);
        }
        return this.outgoingBuffer.deleteFromBuffer(sequenceNumber);
    }

    protected void deleteFromSendBuffer() {
        List<Integer> pNums = this.outgoingBuffer.getPacketSequenceNumbers();
        for (Integer i : pNums) {
            this.sourceHost.deleteFromSendBuffer(this.outgoingBuffer.getPacket(i));
        }
    }

    protected List<Integer> getSequenceNumbersFromIncomingBuffer() {
        return this.incomingBuffer.getPacketSequenceNumbers();
    }

    protected List<Integer> getSequenceNumbersFromOutgoingBuffer() {
        return this.outgoingBuffer.getPacketSequenceNumbers();
    }

    public void changeState(ConnectionData data) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        if (data instanceof ConnectionData) {
            int tmp = data.getBandwidth();
            if (tmp > -1 && tmp <= 100) {
                if (tmp > 0 && this.bandwidth <= 0) {
                    this.outgoingBuffer = new OutgoingBuffer();
                    this.incomingBuffer = new IncomingBuffer();
                }
                this.bandwidth = tmp;
            } else if (tmp < -1 || tmp > 100) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + "Illegal value for bandwidth in Connection: " + tmp + ";";
                this.bandwidth = 50;
            }
            try {
                this.incomingBuffer.changeObjectState(data.getIncomingBufferState());
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
            try {
                this.outgoingBuffer.changeObjectState(data.getOutgoingBufferState());
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
            try {
                this.protocolHandler.setProtocolSettings(data.getProtocolState());
            }
            catch (IllegalArgumentException e) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
        } else {
            error = true;
            errorMessage = String.valueOf(errorMessage) + "Wrong state-type in Connection;";
        }
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public ConnectionData getData() {
        TraceData traceData = null;
        TraceData backTraceData = null;
        if (this.trace != null) {
            traceData = this.trace.getData();
        }
        if (this.backTrace != null) {
            backTraceData = this.backTrace.getData();
        }
        BufferState outBufferState = this.outgoingBuffer.getComponentState();
        BufferState inBufferState = this.incomingBuffer.getComponentState();
        if (this.bandwidth <= 0) {
            outBufferState = new BufferState(outBufferState.getComponentId(), false, true, outBufferState.getCapacity(), null);
            inBufferState = new BufferState(inBufferState.getComponentId(), false, true, inBufferState.getCapacity(), null);
        }
        return new ConnectionData(this.bandwidth, this.trace.getTargetHostId(), inBufferState, outBufferState, traceData, backTraceData, this.protocolHandler.getProtocolSettings());
    }

    public boolean updateTrace(Trace[] trace) {
        boolean isTarget = false;
        if (this.trace.getTargetHostId() == trace[0].getTargetHostId()) {
            isTarget = true;
            this.backTrace = trace[1];
            this.trace = trace[0];
        }
        return isTarget;
    }

    public void prepareToRemove() {
        if (this.trace.getTargetHost() != null) {
            this.trace.getTargetHost().removeIncomingConnection(this);
        }
    }

    public int getTargetHostId() {
        return this.targetHost.getId();
    }

    protected int getBandwidth() {
        return this.bandwidth;
    }

    protected int getStepAmount() {
        return 100 - this.bandwidth;
    }

    protected boolean send(Packet p) throws UnsupportedOperationException {
        if (this.trace == null) {
            UnsupportedOperationException e = new UnsupportedOperationException("send() can not be executed without a trace from source to target host");
            throw e;
        }
        SimpleDataPacket packet = new SimpleDataPacket(p.getSequenceNumber());
        packet.addTrace(this.trace);
        packet.addSource(this.sourceHost);
        boolean isAbleToSend = this.outgoingBuffer.pushBack(packet);
        if (isAbleToSend) {
            p.addTrace(this.trace);
            p.addSource(this.sourceHost);
            this.sourceHost.send(p);
        }
        return isAbleToSend;
    }

    protected void sendResponse(Packet p) throws UnsupportedOperationException {
        if (this.backTrace == null) {
            UnsupportedOperationException e = new UnsupportedOperationException("sendResponse() can not be executed without a trace from target to source host.");
            throw e;
        }
        p.addTrace(this.backTrace);
        p.addSource(this.targetHost);
        this.targetHost.send(p);
    }
}

