/*
 * Decompiled with CFR 0.152.
 */
package model.components.devices.connections;

import events.GoBackNState;
import events.ProtocolState;
import model.Scenario;
import model.components.devices.connections.Protocol;
import model.components.devices.connections.SlidingWindow;
import model.components.packets.ACK;
import model.components.packets.DataPacket;
import model.components.packets.NAK;
import model.components.packets.ResponsePacket;
import model.components.packets.SimpleDataPacket;

public class GoBackN
extends Protocol {
    protected final int STANDARD_WINSIZE = 10;
    protected final boolean STANDARD_NAK = false;
    private int winSize = 10;
    private boolean useNAK = false;
    private SlidingWindow sendWindow = new SlidingWindow(this.winSize, this.timeout);
    private int expectedNumber = 0;

    public GoBackN(Scenario s) {
        super(s);
    }

    @Override
    public GoBackN clone() {
        GoBackN newProtocol = new GoBackN(this.scenario);
        newProtocol.setProtocolSettings(this.getProtocolSettings());
        return newProtocol;
    }

    @Override
    public void reset() {
        super.reset();
        this.sendWindow = new SlidingWindow(this.winSize, this.timeout);
        this.expectedNumber = 0;
    }

    @Override
    public GoBackNState getProtocolSettings() {
        return new GoBackNState(this.timeout, this.winSize, this.useNAK);
    }

    @Override
    public void setProtocolSettings(ProtocolState s) {
        super.setProtocolSettings(s);
        if (s instanceof GoBackNState) {
            GoBackNState state = (GoBackNState)s;
            if (state.getWinSize() >= 0) {
                this.winSize = state.getWinSize();
                this.useNAK = state.getNAK();
            }
            this.sendWindow = new SlidingWindow(this.winSize, this.timeout);
        }
    }

    @Override
    public void step(int stepCount) {
        if (--this.stepsUntilNextPacket >= 0) {
            return;
        }
        int timeoutNumber = this.sendWindow.step(stepCount);
        if (timeoutNumber >= 0) {
            this.connection.deleteFromOutgoingBuffer(timeoutNumber);
            if (timeoutNumber == this.sendWindow.firstNumber()) {
                this.nextSequenceNumber = timeoutNumber;
            }
        }
        if (this.sendWindow.isReady(this.nextSequenceNumber) && this.send(new SimpleDataPacket(this.nextSequenceNumber))) {
            this.sendWindow.send(this.nextSequenceNumber++);
            this.stepsUntilNextPacket = this.connection.getStepAmount();
        }
    }

    @Override
    protected void receiveResponse(ResponsePacket p) {
        int sequenceNumber = p.getSequenceNumber();
        if (p.isDamaged() || p instanceof NAK) {
            this.sendWindow.drop(sequenceNumber);
        } else if (p instanceof ACK) {
            int i = 0;
            while (i <= sequenceNumber) {
                this.sendWindow.receive(i);
                ++i;
            }
        }
        this.connection.deleteFromOutgoingBuffer(sequenceNumber);
    }

    @Override
    protected void receive(DataPacket p) {
        int sequenceNumber = p.getSequenceNumber();
        if (sequenceNumber <= this.expectedNumber) {
            if (!p.isDamaged()) {
                this.send(new ACK(sequenceNumber));
                if (sequenceNumber == this.expectedNumber) {
                    ++this.expectedNumber;
                }
            } else if (this.useNAK) {
                this.send(new NAK(sequenceNumber));
            }
        } else if (this.expectedNumber > 0) {
            this.send(new ACK(this.expectedNumber - 1));
        }
        this.connection.deleteFromIncomingBuffer(sequenceNumber);
    }
}

