/*
 * Decompiled with CFR 0.152.
 */
package model.components.devices.connections;

import events.ProtocolState;
import model.Scenario;
import model.components.devices.connections.Connection;
import model.components.devices.connections.ProtocolHandler;
import model.components.packets.DataPacket;
import model.components.packets.Packet;
import model.components.packets.ResponsePacket;

public abstract class Protocol {
    protected final int STANDARD_TIMEOUT = 600;
    protected int timeout = 600;
    protected int stepsUntilNextPacket = 0;
    protected int nextSequenceNumber = 0;
    protected ProtocolHandler protocolHandler;
    protected Connection connection;
    protected Scenario scenario;

    Protocol(Scenario scenario) {
        this.scenario = scenario;
    }

    public abstract void step(int var1);

    public void reset() {
        this.connection.clearIncomingBuffer();
        this.connection.clearOutgoingBuffer();
        this.stepsUntilNextPacket = 0;
        this.nextSequenceNumber = 0;
    }

    public boolean receivePacket(Packet p) {
        boolean isData = p instanceof DataPacket;
        if (isData) {
            this.receive((DataPacket)p);
        }
        return isData;
    }

    public boolean receiveResponsePacket(Packet p) {
        boolean isResponse = p instanceof ResponsePacket;
        if (isResponse) {
            this.receiveResponse((ResponsePacket)p);
            p.lose();
        }
        return isResponse;
    }

    public void setProtocolSettings(ProtocolState s) {
        if (s != null && s.getTimeout() >= 0) {
            this.timeout = s.getTimeout();
        }
    }

    public abstract ProtocolState getProtocolSettings();

    public void setProtocolHandler(ProtocolHandler protocolHandler, Connection connection) {
        this.protocolHandler = protocolHandler;
        this.connection = connection;
    }

    public abstract Protocol clone();

    protected boolean send(Packet packet) {
        boolean sent = false;
        if (packet instanceof DataPacket) {
            sent = this.connection.send(packet);
        } else if (packet instanceof ResponsePacket) {
            this.connection.sendResponse(packet);
            sent = true;
        }
        if (sent) {
            this.scenario.registerPacket(packet);
        }
        return sent;
    }

    protected abstract void receive(DataPacket var1);

    protected abstract void receiveResponse(ResponsePacket var1);
}

