/*
 * Decompiled with CFR 0.152.
 */
package model.components.devices.connections;

import events.ProtocolState;
import model.components.devices.connections.Connection;
import model.components.devices.connections.Protocol;
import model.components.packets.Packet;

public class ProtocolHandler {
    private Connection connection;
    private Protocol protocol;

    public ProtocolHandler(Connection c, Protocol p) {
        this.connection = c;
        this.setProtocol(p);
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol.clone();
        this.protocol.setProtocolHandler(this, this.connection);
    }

    public void setProtocolSettings(ProtocolState s) {
        this.protocol.setProtocolSettings(s);
    }

    public ProtocolState getProtocolSettings() {
        return this.protocol.getProtocolSettings();
    }

    public void step(int stepcount) {
        this.protocol.step(stepcount);
    }

    public void resetProtocol() {
        this.protocol.reset();
    }

    public boolean receivePacket(Packet p) {
        return this.protocol.receivePacket(p);
    }

    public boolean receiveResponsePacket(Packet p) {
        return this.protocol.receiveResponsePacket(p);
    }
}

