/*
 * Decompiled with CFR 0.152.
 */
package model.components.devices.connections;

import events.ProtocolState;
import events.SelectiveRepeatState;
import model.Scenario;
import model.components.devices.connections.Protocol;
import model.components.devices.connections.SlidingWindow;
import model.components.packets.ACK;
import model.components.packets.DataPacket;
import model.components.packets.NAK;
import model.components.packets.ResponsePacket;
import model.components.packets.SimpleDataPacket;

public class SelectiveRepeat
extends Protocol {
    protected final int STANDARD_WINSIZE = 10;
    protected final boolean STANDARD_NAK = false;
    private int winSize = 10;
    private boolean useNAK = false;
    private SlidingWindow sendWindow = new SlidingWindow(this.winSize, this.timeout);
    private SlidingWindow receiveWindow = new SlidingWindow(this.winSize, this.timeout);

    public SelectiveRepeat(Scenario scenario) {
        super(scenario);
    }

    @Override
    public SelectiveRepeat clone() {
        SelectiveRepeat newProtocol = new SelectiveRepeat(this.scenario);
        newProtocol.setProtocolSettings(this.getProtocolSettings());
        return newProtocol;
    }

    @Override
    public void reset() {
        super.reset();
        this.sendWindow = new SlidingWindow(this.winSize, this.timeout);
        this.receiveWindow = new SlidingWindow(this.winSize, this.timeout);
    }

    @Override
    public SelectiveRepeatState getProtocolSettings() {
        return new SelectiveRepeatState(this.timeout, this.winSize, this.useNAK);
    }

    @Override
    public void setProtocolSettings(ProtocolState s) {
        super.setProtocolSettings(s);
        if (s instanceof SelectiveRepeatState) {
            SelectiveRepeatState state = (SelectiveRepeatState)s;
            if (state.getWinSize() >= 0) {
                this.winSize = state.getWinSize();
                this.useNAK = state.getNAK();
            }
            this.sendWindow = new SlidingWindow(this.winSize, this.timeout);
            this.receiveWindow = new SlidingWindow(this.winSize, this.timeout);
        }
    }

    @Override
    public void step(int stepCount) {
        if (--this.stepsUntilNextPacket >= 0) {
            return;
        }
        int sequenceNumber = this.nextSequenceNumber;
        int timeoutNumber = this.sendWindow.step(stepCount);
        if (timeoutNumber >= 0) {
            sequenceNumber = timeoutNumber;
            this.connection.deleteFromOutgoingBuffer(timeoutNumber);
        }
        if (this.sendWindow.isReady(sequenceNumber) && this.send(new SimpleDataPacket(sequenceNumber))) {
            this.sendWindow.send(sequenceNumber);
            if (timeoutNumber < 0) {
                ++this.nextSequenceNumber;
            }
            this.stepsUntilNextPacket = this.connection.getStepAmount();
        }
    }

    @Override
    protected void receiveResponse(ResponsePacket p) {
        int sequenceNumber = p.getSequenceNumber();
        if (p.isDamaged() || p instanceof NAK) {
            this.sendWindow.drop(sequenceNumber);
        } else if (p instanceof ACK) {
            this.sendWindow.receive(sequenceNumber);
            this.connection.deleteFromOutgoingBuffer(sequenceNumber);
        }
    }

    @Override
    protected void receive(DataPacket p) {
        int expectedNumber;
        int sequenceNumber = p.getSequenceNumber();
        if (sequenceNumber < (expectedNumber = this.receiveWindow.firstNumber())) {
            this.send(new ACK(sequenceNumber));
        } else if (p.isDamaged() && this.receiveWindow.isReady(sequenceNumber)) {
            if (this.useNAK) {
                this.send(new NAK(sequenceNumber));
            }
        } else {
            this.send(new ACK(sequenceNumber));
            if (!p.isDamaged()) {
                this.receiveWindow.receive(sequenceNumber);
            }
            if (sequenceNumber <= expectedNumber) {
                while (sequenceNumber < this.receiveWindow.firstNumber()) {
                    this.connection.deleteFromIncomingBuffer(sequenceNumber++);
                }
            }
            return;
        }
        this.connection.deleteFromIncomingBuffer(sequenceNumber);
    }
}

