/*
 * Decompiled with CFR 0.152.
 */
package model.components.devices.connections;

public class SlidingWindow {
    private int size;
    private int timeout;
    private int[] packet;
    private int head = 0;
    private int tail;
    private int lastStep = -1;

    SlidingWindow(int size, int timeout) {
        this.size = size;
        this.timeout = timeout;
        this.tail = size - 1;
        this.packet = new int[size];
        int i = 0;
        while (i < size) {
            this.packet[i] = 0;
            ++i;
        }
    }

    public boolean send(int sequenceNumber) {
        if (!this.isReady(sequenceNumber)) {
            return false;
        }
        this.packet[sequenceNumber % this.size] = this.timeout;
        return true;
    }

    public int step(int stepCount) {
        int delta = stepCount;
        if (this.lastStep >= 0) {
            delta -= this.lastStep;
        }
        this.lastStep = stepCount;
        delta = Math.min(delta, this.timeout);
        int i = this.head;
        while (i <= this.tail) {
            if (this.packet[i % this.size] > 0) {
                int n = i % this.size;
                this.packet[n] = this.packet[n] - delta;
                if (this.packet[i % this.size] == 0) {
                    return i;
                }
            }
            if (this.packet[i % this.size] < 0 && this.packet[i % this.size] != Integer.MIN_VALUE) {
                this.packet[i % this.size] = 0;
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean receive(int sequenceNumber) {
        if (!this.isValid(sequenceNumber)) {
            return false;
        }
        this.packet[sequenceNumber % this.size] = Integer.MIN_VALUE;
        if (sequenceNumber == this.head) {
            int i = this.head;
            while (i <= this.tail && this.isAccepted(i % this.size)) {
                this.packet[i % this.size] = 0;
                ++this.head;
                ++i;
            }
            this.tail = this.head + this.size - 1;
        }
        return true;
    }

    public boolean drop(int sequenceNumber) {
        if (!this.isValid(sequenceNumber)) {
            return false;
        }
        this.packet[sequenceNumber % this.size] = -this.timeout;
        return true;
    }

    public boolean isReady(int sequenceNumber) {
        return this.isValid(sequenceNumber) && (this.isFree(sequenceNumber) || this.isAccepted(sequenceNumber));
    }

    public int firstNumber() {
        return this.head;
    }

    private boolean isValid(int sequenceNumber) {
        return sequenceNumber >= this.head && sequenceNumber <= this.tail;
    }

    private boolean isFree(int sequenceNumber) {
        return this.packet[sequenceNumber % this.size] == 0;
    }

    private boolean isAccepted(int sequenceNumber) {
        return this.packet[sequenceNumber % this.size] == Integer.MIN_VALUE;
    }
}

