/*
 * Decompiled with CFR 0.152.
 */
package model.components.devices.connections;

import events.StopAndWaitState;
import model.Scenario;
import model.components.devices.connections.Protocol;
import model.components.packets.ACK;
import model.components.packets.DataPacket;
import model.components.packets.ResponsePacket;
import model.components.packets.SimpleDataPacket;

public class StopAndWait
extends Protocol {
    private boolean isReadyToSend = true;

    public StopAndWait(Scenario scenario) {
        super(scenario);
    }

    @Override
    public StopAndWait clone() {
        StopAndWait newProtocol = new StopAndWait(this.scenario);
        newProtocol.setProtocolHandler(this.protocolHandler, this.connection);
        newProtocol.timeout = this.timeout;
        return newProtocol;
    }

    @Override
    public StopAndWaitState getProtocolSettings() {
        return new StopAndWaitState(this.timeout);
    }

    @Override
    public void reset() {
        super.reset();
        this.isReadyToSend = true;
        this.nextSequenceNumber = 0;
        this.stepsUntilNextPacket = 0;
    }

    @Override
    public void step(int counter) {
        if (this.connection.getStepAmount() - this.stepsUntilNextPacket >= this.timeout) {
            this.connection.clearOutgoingBuffer();
            this.isReadyToSend = true;
        }
        if (this.isReadyToSend && this.stepsUntilNextPacket <= 0 && this.send(new SimpleDataPacket(this.nextSequenceNumber))) {
            this.stepsUntilNextPacket = this.connection.getStepAmount() - 1;
            this.isReadyToSend = false;
        } else {
            --this.stepsUntilNextPacket;
        }
    }

    @Override
    protected void receive(DataPacket p) {
        if (!p.isDamaged()) {
            this.send(new ACK(p.getSequenceNumber()));
        }
        this.connection.deleteFromIncomingBuffer(p.getSequenceNumber());
    }

    @Override
    protected void receiveResponse(ResponsePacket p) {
        if (!p.isDamaged() && p.getSequenceNumber() == this.nextSequenceNumber) {
            this.connection.deleteFromOutgoingBuffer(p.getSequenceNumber());
            this.isReadyToSend = true;
            this.nextSequenceNumber = 1 - this.nextSequenceNumber;
        }
    }
}

