/*
 * Decompiled with CFR 0.152.
 */
package model.components.devices.connections.tests;

import java.util.List;
import model.components.buffers.IncomingBuffer;
import model.components.buffers.OutgoingBuffer;
import model.components.devices.connections.Connection;
import model.components.devices.connections.Protocol;
import model.components.devices.connections.ProtocolHandler;
import model.components.packets.Packet;

public class TestConnection
extends Connection {
    private IncomingBuffer incomingBuffer;
    private OutgoingBuffer outgoingBuffer;
    private ProtocolHandler protocolHandler;

    public TestConnection(Protocol protocol) {
        super(null, null, null, protocol);
        this.protocolHandler = new ProtocolHandler(this, protocol);
        this.incomingBuffer = new IncomingBuffer();
        this.outgoingBuffer = new OutgoingBuffer();
    }

    @Override
    protected boolean send(Packet p) {
        return this.outgoingBuffer.pushBack(p);
    }

    @Override
    protected void sendResponse(Packet p) {
    }

    @Override
    public boolean receive(Packet p) {
        this.incomingBuffer.pushBack(p);
        return this.protocolHandler.receivePacket(p);
    }

    @Override
    public boolean receiveResponse(Packet p) {
        return this.protocolHandler.receiveResponsePacket(p);
    }

    @Override
    public void step(int counter) {
        this.protocolHandler.step(counter);
    }

    @Override
    public List<Integer> getSequenceNumbersFromIncomingBuffer() {
        return this.incomingBuffer.getPacketSequenceNumbers();
    }

    @Override
    public List<Integer> getSequenceNumbersFromOutgoingBuffer() {
        return this.outgoingBuffer.getPacketSequenceNumbers();
    }

    @Override
    public boolean deleteFromIncomingBuffer(int sequenceNumber) {
        return this.incomingBuffer.deleteFromBuffer(sequenceNumber);
    }

    @Override
    public boolean deleteFromOutgoingBuffer(int sequenceNumber) {
        return this.outgoingBuffer.deleteFromBuffer(sequenceNumber);
    }

    @Override
    public void clearIncomingBuffer() {
        this.incomingBuffer.clearBuffer();
    }

    @Override
    public void clearOutgoingBuffer() {
        this.outgoingBuffer.clearBuffer();
    }

    @Override
    public void reset() {
        this.protocolHandler.resetProtocol();
        this.incomingBuffer.reset();
        this.outgoingBuffer.reset();
    }

    @Override
    protected int getStepAmount() {
        return super.getStepAmount();
    }
}

