/*
 * Decompiled with CFR 0.152.
 */
package model.components.devices.connections.tests;

import events.AckPacketState;
import events.ConnectionData;
import events.DataPacketState;
import events.GoBackNState;
import java.util.Observable;
import java.util.Observer;
import model.Scenario;
import model.components.devices.connections.GoBackN;
import model.components.devices.connections.tests.TestConnection;
import model.components.packets.ACK;
import model.components.packets.SimpleDataPacket;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestGoBackN
implements Observer {
    private TestConnection connection;
    private Scenario scenario = new Scenario();
    private GoBackN protocol;
    private int packetCount = 0;
    private int timeout = 300;
    private int connectionBandwidth = 50;
    private int winSize = 10;
    private boolean useNAK = false;
    private boolean packetSent = false;
    private boolean responseSent = false;
    private DataPacketState packetState;
    private AckPacketState responseState;

    public TestGoBackN() {
        this.scenario.addObserver(this);
        this.protocol = new GoBackN(this.scenario);
        this.connection = new TestConnection(this.protocol);
        this.connection.changeState(new ConnectionData(this.connectionBandwidth, -1, null, null, null, null, new GoBackNState(this.timeout, this.winSize, this.useNAK)));
    }

    @Before
    public void setUp() throws Exception {
        this.connection.reset();
        this.packetCount = 0;
    }

    @Test
    public void testStep() {
        int seqno = 0;
        int step = 0;
        this.connection.step(step);
        ++step;
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().size() == this.packetCount);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(this.packetCount - 1) == seqno);
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
        this.connection.receive(new SimpleDataPacket(seqno));
        Assert.assertTrue(this.responseSent);
        Assert.assertTrue(this.responseState.getSequenceNumber() == seqno);
        Assert.assertTrue(this.connection.getSequenceNumbersFromIncomingBuffer().isEmpty());
        this.responseSent = false;
        ++seqno;
        while (step <= this.connection.getStepAmount()) {
            Assert.assertFalse(this.packetSent);
            this.connection.step(step);
            ++step;
        }
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().size() == this.packetCount);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(this.packetCount - 1) == seqno);
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
        this.connection.receive(new SimpleDataPacket(seqno));
        Assert.assertTrue(this.responseSent);
        Assert.assertTrue(this.responseState.getSequenceNumber() == seqno);
        Assert.assertTrue(this.connection.getSequenceNumbersFromIncomingBuffer().isEmpty());
        this.responseSent = false;
        this.connection.reset();
        Assert.assertTrue(this.connection.getSequenceNumbersFromIncomingBuffer().isEmpty());
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().isEmpty());
        seqno = 0;
        step = 0;
        this.packetCount = 0;
        this.connection.step(step);
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().size() == this.packetCount);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(this.packetCount - 1) == seqno);
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
        ++seqno;
        while (step <= this.connection.getStepAmount()) {
            this.connection.step(step);
            ++step;
        }
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().size() == this.packetCount);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(this.packetCount - 1) == seqno);
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
        this.connection.receive(new SimpleDataPacket(seqno - 1));
        Assert.assertTrue(this.responseSent);
        Assert.assertTrue(this.responseState.getSequenceNumber() == seqno - 1);
        Assert.assertTrue(this.connection.getSequenceNumbersFromIncomingBuffer().isEmpty());
        this.responseSent = false;
        this.connection.receiveResponse(new ACK(seqno - 1));
        --this.packetCount;
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().size() == this.packetCount);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(this.packetCount - 1) == seqno);
    }

    @Test
    public void testTimeout() {
        int seqno = 0;
        int step = 0;
        this.connection.step(step);
        int j = ++step;
        while (step < this.timeout) {
            Assert.assertTrue(this.packetSent);
            Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().size() == this.packetCount);
            Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(this.packetCount - 1) == seqno);
            Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
            this.packetSent = false;
            while (j <= this.connection.getStepAmount()) {
                this.connection.step(step);
                ++j;
                ++step;
            }
            this.connection.receive(new SimpleDataPacket(seqno));
            Assert.assertTrue(this.responseSent);
            Assert.assertTrue(this.responseState.getSequenceNumber() == seqno);
            Assert.assertTrue(this.connection.getSequenceNumbersFromIncomingBuffer().isEmpty());
            this.responseSent = false;
            ++seqno;
            j = 0;
        }
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().isEmpty());
        seqno -= this.packetCount - 1;
        this.packetCount = 0;
        while (j <= this.connection.getStepAmount()) {
            this.connection.step(step);
            ++j;
            ++step;
        }
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().size() == this.packetCount);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(this.packetCount - 1) == seqno);
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg1 instanceof DataPacketState && ((DataPacketState)arg1).isNew()) {
            this.packetSent = true;
            this.packetState = (DataPacketState)arg1;
            ++this.packetCount;
        } else if (arg1 instanceof AckPacketState && ((AckPacketState)arg1).isNew()) {
            this.responseSent = true;
            this.responseState = (AckPacketState)arg1;
        }
    }
}

