/*
 * Decompiled with CFR 0.152.
 */
package model.components.devices.connections.tests;

import events.GoBackNState;
import events.SelectiveRepeatState;
import events.StopAndWaitState;
import model.components.devices.connections.GoBackN;
import model.components.devices.connections.Protocol;
import model.components.devices.connections.SelectiveRepeat;
import model.components.devices.connections.StopAndWait;
import org.junit.Assert;
import org.junit.Test;

public class TestIllegalArguments {
    private Protocol protocol;
    private static final int[] ILLEGAL_INPUTS = new int[]{-200, -34, -20090, -1, -42};

    @Test
    public void testStopAndWait() {
        this.protocol = new StopAndWait(null);
        int i = 0;
        while (i < ILLEGAL_INPUTS.length) {
            this.protocol.setProtocolSettings(new GoBackNState(i, i, false));
            StopAndWaitState pState = (StopAndWaitState)this.protocol.getProtocolSettings();
            Assert.assertEquals(i, pState.getTimeout());
            this.protocol.setProtocolSettings(new GoBackNState(ILLEGAL_INPUTS[i], ILLEGAL_INPUTS[i], false));
            pState = (StopAndWaitState)this.protocol.getProtocolSettings();
            Assert.assertEquals(i, pState.getTimeout());
            ++i;
        }
    }

    @Test
    public void testGoBackN() {
        this.protocol = new GoBackN(null);
        int i = 0;
        while (i < ILLEGAL_INPUTS.length) {
            this.protocol.setProtocolSettings(new GoBackNState(i, i, false));
            GoBackNState pState = (GoBackNState)this.protocol.getProtocolSettings();
            Assert.assertEquals(i, pState.getTimeout());
            Assert.assertEquals(i, pState.getWinSize());
            this.protocol.setProtocolSettings(new GoBackNState(ILLEGAL_INPUTS[i], ILLEGAL_INPUTS[i], false));
            pState = (GoBackNState)this.protocol.getProtocolSettings();
            Assert.assertEquals(i, pState.getTimeout());
            Assert.assertEquals(i, pState.getWinSize());
            ++i;
        }
    }

    @Test
    public void testSelectiveRepeat() {
        this.protocol = new SelectiveRepeat(null);
        int i = 0;
        while (i < ILLEGAL_INPUTS.length) {
            this.protocol.setProtocolSettings(new GoBackNState(i, i, false));
            SelectiveRepeatState pState = (SelectiveRepeatState)this.protocol.getProtocolSettings();
            Assert.assertEquals(i, pState.getTimeout());
            this.protocol.setProtocolSettings(new GoBackNState(ILLEGAL_INPUTS[i], ILLEGAL_INPUTS[i], false));
            pState = (SelectiveRepeatState)this.protocol.getProtocolSettings();
            Assert.assertEquals(i, pState.getTimeout());
            ++i;
        }
    }
}

