/*
 * Decompiled with CFR 0.152.
 */
package model.components.devices.connections.tests;

import events.AckPacketState;
import events.ConnectionData;
import events.DataPacketState;
import events.NakPacketState;
import events.SelectiveRepeatState;
import java.util.Observable;
import java.util.Observer;
import model.Scenario;
import model.components.devices.connections.SelectiveRepeat;
import model.components.devices.connections.tests.TestConnection;
import model.components.packets.ACK;
import model.components.packets.NAK;
import model.components.packets.SimpleDataPacket;
import org.junit.Assert;
import org.junit.Test;

public class TestSelectiveRepeat
implements Observer {
    private TestConnection connection;
    private Scenario scenario = new Scenario();
    private SelectiveRepeat protocol;
    private int timeout = 300;
    private int winSize = 10;
    private int connectionBandwidth = 50;
    private boolean packetSent = false;
    private boolean responseSent = false;
    private DataPacketState packetState;
    private AckPacketState responseState;
    private NakPacketState responseNakState;
    private int packetCount = 0;

    public TestSelectiveRepeat() {
        this.scenario.addObserver(this);
        this.protocol = new SelectiveRepeat(this.scenario);
        this.connection = new TestConnection(this.protocol);
        this.connection.changeState(new ConnectionData(this.connectionBandwidth, -1, null, null, null, null, new SelectiveRepeatState(this.timeout, this.winSize, false)));
    }

    @Test
    public void testStep() {
        int seqno = 0;
        int step = 0;
        this.connection.step(step);
        ++step;
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(0) == seqno);
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
        this.connection.receive(new SimpleDataPacket(seqno));
        Assert.assertTrue(this.responseSent);
        Assert.assertTrue(this.responseState.getSequenceNumber() == seqno);
        Assert.assertTrue(this.connection.getSequenceNumbersFromIncomingBuffer().isEmpty());
        this.responseSent = false;
        this.connection.receiveResponse(new ACK(seqno));
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().isEmpty());
        ++seqno;
        while (step <= this.connection.getStepAmount()) {
            this.connection.step(step);
            ++step;
        }
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(0) == seqno);
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
        this.connection.receive(new SimpleDataPacket(seqno));
        Assert.assertTrue(this.responseSent);
        Assert.assertTrue(this.responseState.getSequenceNumber() == seqno);
        Assert.assertTrue(this.connection.getSequenceNumbersFromIncomingBuffer().isEmpty());
        this.responseSent = false;
        this.connection.receiveResponse(new ACK(seqno));
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().isEmpty());
    }

    @Test
    public void testNak() {
        int step = 0;
        int seqno = 0;
        this.connection.step(step);
        ++step;
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(0) == seqno);
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
        SimpleDataPacket packet = new SimpleDataPacket(seqno);
        packet.damage();
        this.connection.receive(packet);
        Assert.assertTrue(this.responseSent);
        Assert.assertTrue(this.responseNakState.getSequenceNumber() == seqno);
        Assert.assertTrue(this.connection.getSequenceNumbersFromIncomingBuffer().isEmpty());
        this.responseSent = false;
        this.connection.receiveResponse(new NAK(seqno));
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().isEmpty());
        while (step <= this.connection.getStepAmount()) {
            this.connection.step(step);
            ++step;
        }
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(0) == seqno);
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
    }

    @Test
    public void testIncBuffer() {
        int seqno = 0;
        int step = 0;
        this.connection.step(step);
        ++step;
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(0) == seqno);
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
        this.connection.receive(new SimpleDataPacket(seqno + 1));
        Assert.assertTrue(this.responseSent);
        Assert.assertTrue(this.responseNakState.getSequenceNumber() == seqno);
        Assert.assertFalse(this.connection.getSequenceNumbersFromIncomingBuffer().isEmpty());
        this.responseSent = false;
        this.connection.receiveResponse(new ACK(seqno + 1));
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().isEmpty());
        while (step <= this.connection.getStepAmount()) {
            this.connection.step(step);
            ++step;
        }
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(0) == (seqno += 2));
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
        this.connection.receive(new SimpleDataPacket(seqno - 2));
        Assert.assertTrue(this.responseSent);
        Assert.assertTrue(this.responseState.getSequenceNumber() == seqno - 1);
        Assert.assertTrue(this.connection.getSequenceNumbersFromIncomingBuffer().isEmpty());
        this.responseSent = false;
        this.connection.receiveResponse(new ACK(seqno));
        this.connection.receiveResponse(new ACK(seqno - 1));
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().isEmpty());
    }

    @Test
    public void testTimeout() {
        int seqno = 0;
        int step = 0;
        this.connection.step(step);
        ++step;
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().size() == this.packetCount);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(this.packetCount - 1) == seqno);
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
        while (step <= this.connection.getStepAmount()) {
            this.connection.step(step);
            ++step;
        }
        this.connection.receive(new SimpleDataPacket(seqno + 1));
        Assert.assertTrue(this.responseSent);
        Assert.assertTrue(this.responseNakState.getSequenceNumber() == seqno);
        Assert.assertFalse(this.connection.getSequenceNumbersFromIncomingBuffer().isEmpty());
        this.responseSent = false;
        ++seqno;
        int j = 0;
        while (step < this.timeout) {
            Assert.assertTrue(this.packetSent);
            Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().size() == this.packetCount);
            Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(this.packetCount - 1) == seqno);
            Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
            this.packetSent = false;
            while (j <= this.connection.getStepAmount()) {
                this.connection.step(step);
                ++j;
                ++step;
            }
            this.connection.receive(new SimpleDataPacket(seqno + 1));
            Assert.assertFalse(this.responseSent);
            Assert.assertFalse(this.connection.getSequenceNumbersFromIncomingBuffer().isEmpty());
            this.responseSent = false;
            ++seqno;
            j = 0;
        }
        --this.packetCount;
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().size() == this.packetCount);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(this.packetCount - 1) == (seqno -= this.packetCount));
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
        this.connection.receive(new SimpleDataPacket(seqno));
        Assert.assertTrue(this.connection.getSequenceNumbersFromIncomingBuffer().isEmpty());
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg1 instanceof DataPacketState && ((DataPacketState)arg1).isNew()) {
            this.packetSent = true;
            this.packetState = (DataPacketState)arg1;
            ++this.packetCount;
        } else if (arg1 instanceof AckPacketState && ((AckPacketState)arg1).isNew()) {
            this.responseSent = true;
            this.responseState = (AckPacketState)arg1;
        } else if (arg1 instanceof NakPacketState && ((NakPacketState)arg1).isNew()) {
            this.responseSent = true;
            this.responseNakState = (NakPacketState)arg1;
        }
    }
}

