/*
 * Decompiled with CFR 0.152.
 */
package model.components.devices.connections.tests;

import events.AckPacketState;
import events.ConnectionData;
import events.DataPacketState;
import events.StopAndWaitState;
import java.util.Observable;
import java.util.Observer;
import model.Scenario;
import model.components.devices.connections.StopAndWait;
import model.components.devices.connections.tests.TestConnection;
import model.components.packets.ACK;
import model.components.packets.SimpleDataPacket;
import org.junit.Assert;
import org.junit.Test;

public class TestStopAndWait
implements Observer {
    private TestConnection connection;
    private Scenario scenario = new Scenario();
    private StopAndWait protocol;
    private int timeout = 300;
    private int connectionBandwidth = 50;
    private boolean packetSent = false;
    private boolean responseSent = false;
    private DataPacketState packetState;
    private AckPacketState responseState;

    public TestStopAndWait() {
        this.scenario.addObserver(this);
        this.protocol = new StopAndWait(this.scenario);
        this.connection = new TestConnection(this.protocol);
        this.connection.changeState(new ConnectionData(this.connectionBandwidth, -1, null, null, null, null, new StopAndWaitState(this.timeout)));
    }

    @Test
    public void testStep() {
        int seqno = 0;
        int step = 0;
        this.connection.step(step);
        ++step;
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(0) == seqno);
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
        this.connection.receive(new SimpleDataPacket(seqno));
        Assert.assertTrue(this.responseSent);
        Assert.assertTrue(this.responseState.getSequenceNumber() == seqno);
        Assert.assertTrue(this.connection.getSequenceNumbersFromIncomingBuffer().isEmpty());
        this.responseSent = false;
        this.connection.receiveResponse(new ACK(seqno));
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().isEmpty());
        ++seqno;
        while (step <= this.connection.getStepAmount()) {
            Assert.assertFalse(this.packetSent);
            this.connection.step(step);
            ++step;
        }
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(0) == seqno);
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
        this.connection.receive(new SimpleDataPacket(seqno));
        Assert.assertTrue(this.responseSent);
        Assert.assertTrue(this.responseState.getSequenceNumber() == seqno);
        Assert.assertTrue(this.connection.getSequenceNumbersFromIncomingBuffer().isEmpty());
        this.responseSent = false;
        this.connection.receiveResponse(new ACK(seqno));
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().isEmpty());
    }

    @Test
    public void testTimeout() {
        int seqno = 0;
        int step = 0;
        this.connection.step(step);
        ++step;
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(0) == seqno);
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
        while (step <= this.timeout + 1) {
            this.connection.step(step);
            ++step;
        }
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().size() == 1);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(0) == seqno);
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
    }

    @Test
    public void testBadResponse() {
        int seqno = 0;
        int step = 0;
        this.connection.step(step);
        ++step;
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(0) == seqno);
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
        this.connection.receive(new SimpleDataPacket(seqno));
        Assert.assertTrue(this.responseSent);
        Assert.assertTrue(this.responseState.getSequenceNumber() == seqno);
        Assert.assertTrue(this.connection.getSequenceNumbersFromIncomingBuffer().isEmpty());
        this.responseSent = false;
        this.connection.receiveResponse(new ACK(seqno - 1));
        Assert.assertFalse(this.connection.getSequenceNumbersFromOutgoingBuffer().isEmpty());
        while (step <= this.timeout + 1) {
            this.connection.step(step);
            ++step;
        }
        Assert.assertTrue(this.packetSent);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().size() == 1);
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().get(0) == seqno);
        Assert.assertTrue(this.packetState.getSequenceNumber() == seqno);
        this.packetSent = false;
        this.connection.receive(new SimpleDataPacket(seqno));
        Assert.assertTrue(this.responseSent);
        Assert.assertTrue(this.responseState.getSequenceNumber() == seqno);
        Assert.assertTrue(this.connection.getSequenceNumbersFromIncomingBuffer().isEmpty());
        this.responseSent = false;
        this.connection.receiveResponse(new ACK(seqno));
        Assert.assertTrue(this.connection.getSequenceNumbersFromOutgoingBuffer().isEmpty());
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg1 instanceof DataPacketState && ((DataPacketState)arg1).isNew()) {
            this.packetSent = true;
            this.packetState = (DataPacketState)arg1;
        } else if (arg1 instanceof AckPacketState && ((AckPacketState)arg1).isNew()) {
            this.responseSent = true;
            this.responseState = (AckPacketState)arg1;
        }
    }
}

