/*
 * Decompiled with CFR 0.152.
 */
package model.components.devices.tests;

import events.BidirectionalLineState;
import events.RouterState;
import events.UnidirectionalLineState;
import java.util.LinkedList;
import model.Scenario;
import model.Trace;
import model.components.devices.Host;
import model.components.devices.Router;
import model.components.devices.connections.StopAndWait;
import model.components.lines.BidirectionalLine;
import model.components.packets.SimpleDataPacket;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DeviceTests {
    private static Host host1;
    private static Host host2;
    private static Host host3;
    private static Router router;
    private static int hostId1;
    private static int hostId2;
    private static int hostId3;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        host1 = new Host();
        hostId1 = host1.getId();
        host2 = new Host();
        hostId2 = host2.getId();
        host3 = new Host();
        hostId3 = host3.getId();
        router = new Router();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLineStep() {
        int seqno = 0;
        int step = 0;
        StopAndWait protocol = new StopAndWait(new Scenario());
        BidirectionalLine b = new BidirectionalLine(host1, host2);
        host1.addLine(b);
        host1.setProtocol(protocol);
        host2.addLine(b);
        host2.setProtocol(protocol);
        LinkedList<Integer> lines = new LinkedList<Integer>();
        lines.add(b.getId());
        Trace trace = new Trace(host1, lines, hostId2);
        SimpleDataPacket p = new SimpleDataPacket(seqno);
        p.addSource(host1);
        p.addTrace(trace);
        Assert.assertTrue(b.send(p, hostId1));
        b.step(step);
        ++step;
        BidirectionalLineState biLineState = (BidirectionalLineState)b.getComponentState();
        UnidirectionalLineState uniLineState = biLineState.getFromTargetToSourceLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().size() == 1);
        p = new SimpleDataPacket(++seqno);
        p.addSource(host1);
        p.addTrace(trace);
        Assert.assertFalse(b.send(p, hostId1));
        while (step < 100 - uniLineState.getBandwidth() - 1) {
            b.step(step);
            ++step;
            biLineState = (BidirectionalLineState)b.getComponentState();
            uniLineState = biLineState.getFromSourceToTargetLineState();
            Assert.assertTrue(uniLineState.getPackets().size() == 1);
            Assert.assertFalse(b.send(p, hostId1));
        }
        b.step(step);
        ++step;
        Assert.assertTrue(b.send(p, hostId1));
        biLineState = (BidirectionalLineState)b.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().size() == 2);
        p.lose();
        biLineState = (BidirectionalLineState)b.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().size() == 1);
        while (step < uniLineState.getLength() - 1) {
            b.step(step);
            ++step;
            biLineState = (BidirectionalLineState)b.getComponentState();
            uniLineState = biLineState.getFromSourceToTargetLineState();
            Assert.assertTrue(uniLineState.getPackets().size() == 1);
        }
        b.step(step);
        ++step;
        biLineState = (BidirectionalLineState)b.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        p = new SimpleDataPacket(++seqno);
        p.addSource(host1);
        p.addTrace(trace);
        Assert.assertTrue(b.send(p, hostId1));
        biLineState = (BidirectionalLineState)b.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().size() == 1);
        b.reset();
        biLineState = (BidirectionalLineState)b.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testRouterStep() {
        seqno = 0;
        step = 0;
        processingTime = 10;
        protocol = new StopAndWait(new Scenario());
        b1 = new BidirectionalLine(DeviceTests.host1, DeviceTests.router);
        DeviceTests.host1.addLine(b1);
        DeviceTests.host1.setProtocol(protocol);
        DeviceTests.router.addLine(b1);
        b2 = new BidirectionalLine(DeviceTests.host2, DeviceTests.router);
        DeviceTests.host2.addLine(b2);
        DeviceTests.host2.setProtocol(protocol);
        DeviceTests.router.addLine(b2);
        b3 = new BidirectionalLine(DeviceTests.host3, DeviceTests.router);
        DeviceTests.host3.addLine(b3);
        DeviceTests.host3.setProtocol(protocol);
        DeviceTests.router.addLine(b3);
        lines = new LinkedList<Integer>();
        lines.add(b1.getId());
        lines.add(b2.getId());
        t12 = new Trace(DeviceTests.host1, lines, DeviceTests.hostId2);
        lines.clear();
        lines.add(b1.getId());
        lines.add(b3.getId());
        t13 = new Trace(DeviceTests.host1, lines, DeviceTests.hostId3);
        lines.clear();
        lines.add(b3.getId());
        lines.add(b2.getId());
        t32 = new Trace(DeviceTests.host3, lines, DeviceTests.hostId2);
        DeviceTests.router.changeObjectState(new RouterState(-1, false, false, null, null, -1, -1, processingTime, null, null));
        p = new SimpleDataPacket(seqno);
        p.addSource(DeviceTests.host1);
        p.addTrace(t12);
        p.increaseTraceCount();
        DeviceTests.router.receive(p, b1);
        p = new SimpleDataPacket(++seqno);
        p.addSource(DeviceTests.host1);
        p.addTrace(t12);
        p.increaseTraceCount();
        DeviceTests.router.receive(p, b1);
        while (step < processingTime) {
            DeviceTests.router.step(step);
            biLineState = (BidirectionalLineState)b1.getComponentState();
            uniLineState = biLineState.getFromSourceToTargetLineState();
            Assert.assertTrue(uniLineState.getPackets().isEmpty());
            uniLineState = biLineState.getFromTargetToSourceLineState();
            Assert.assertTrue(uniLineState.getPackets().isEmpty());
            biLineState = (BidirectionalLineState)b2.getComponentState();
            uniLineState = biLineState.getFromSourceToTargetLineState();
            Assert.assertTrue(uniLineState.getPackets().isEmpty());
            uniLineState = biLineState.getFromTargetToSourceLineState();
            Assert.assertTrue(uniLineState.getPackets().isEmpty());
            biLineState = (BidirectionalLineState)b3.getComponentState();
            uniLineState = biLineState.getFromSourceToTargetLineState();
            Assert.assertTrue(uniLineState.getPackets().isEmpty());
            uniLineState = biLineState.getFromTargetToSourceLineState();
            Assert.assertTrue(uniLineState.getPackets().isEmpty());
            ++step;
        }
        biLineState = (BidirectionalLineState)b2.getComponentState();
        uniLineState = biLineState.getFromTargetToSourceLineState();
        bandwidth = uniLineState.getBandwidth();
        while (step < processingTime + 100 - bandwidth) {
            DeviceTests.router.step(step);
            b2.step(step);
            biLineState = (BidirectionalLineState)b1.getComponentState();
            uniLineState = biLineState.getFromSourceToTargetLineState();
            Assert.assertTrue(uniLineState.getPackets().isEmpty());
            uniLineState = biLineState.getFromTargetToSourceLineState();
            Assert.assertTrue(uniLineState.getPackets().isEmpty());
            biLineState = (BidirectionalLineState)b2.getComponentState();
            uniLineState = biLineState.getFromSourceToTargetLineState();
            Assert.assertTrue(uniLineState.getPackets().isEmpty());
            uniLineState = biLineState.getFromTargetToSourceLineState();
            Assert.assertFalse(uniLineState.getPackets().isEmpty());
            Assert.assertTrue(uniLineState.getPackets().size() == 1);
            biLineState = (BidirectionalLineState)b3.getComponentState();
            uniLineState = biLineState.getFromSourceToTargetLineState();
            Assert.assertTrue(uniLineState.getPackets().isEmpty());
            uniLineState = biLineState.getFromTargetToSourceLineState();
            Assert.assertTrue(uniLineState.getPackets().isEmpty());
            ++step;
        }
        DeviceTests.router.step(step);
        b2.step(step);
        ++step;
        biLineState = (BidirectionalLineState)b1.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        uniLineState = biLineState.getFromTargetToSourceLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        biLineState = (BidirectionalLineState)b2.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        uniLineState = biLineState.getFromTargetToSourceLineState();
        Assert.assertFalse(uniLineState.getPackets().isEmpty());
        Assert.assertTrue(uniLineState.getPackets().size() == 2);
        biLineState = (BidirectionalLineState)b3.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        uniLineState = biLineState.getFromTargetToSourceLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        step = 0;
        seqno = 0;
        DeviceTests.router.reset();
        b2.reset();
        DeviceTests.router.changeObjectState(new RouterState(-1, false, false, null, null, -1, -1, 0, null, null));
        p = new SimpleDataPacket(seqno);
        p.addTrace(t12);
        p.increaseTraceCount();
        DeviceTests.router.receive(p, b1);
        p = new SimpleDataPacket(++seqno);
        p.addTrace(t13);
        p.increaseTraceCount();
        DeviceTests.router.receive(p, b1);
        biLineState = (BidirectionalLineState)b1.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        uniLineState = biLineState.getFromTargetToSourceLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        biLineState = (BidirectionalLineState)b2.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        uniLineState = biLineState.getFromTargetToSourceLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        biLineState = (BidirectionalLineState)b3.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        uniLineState = biLineState.getFromTargetToSourceLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        DeviceTests.router.step(step);
        ++step;
        biLineState = (BidirectionalLineState)b1.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        uniLineState = biLineState.getFromTargetToSourceLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        biLineState = (BidirectionalLineState)b2.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        uniLineState = biLineState.getFromTargetToSourceLineState();
        Assert.assertFalse(uniLineState.getPackets().isEmpty());
        Assert.assertTrue(uniLineState.getPackets().size() == 1);
        biLineState = (BidirectionalLineState)b3.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        uniLineState = biLineState.getFromTargetToSourceLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        DeviceTests.router.step(step);
        ++step;
        biLineState = (BidirectionalLineState)b1.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        uniLineState = biLineState.getFromTargetToSourceLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        biLineState = (BidirectionalLineState)b2.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        uniLineState = biLineState.getFromTargetToSourceLineState();
        Assert.assertFalse(uniLineState.getPackets().isEmpty());
        Assert.assertTrue(uniLineState.getPackets().size() == 1);
        biLineState = (BidirectionalLineState)b3.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        uniLineState = biLineState.getFromTargetToSourceLineState();
        Assert.assertFalse(uniLineState.getPackets().isEmpty());
        Assert.assertTrue(uniLineState.getPackets().size() == 1);
        step = 0;
        seqno = 0;
        DeviceTests.router.reset();
        b2.reset();
        b3.reset();
        b2.changeObjectState(new BidirectionalLineState(-1, false, false, -1, -1, null, new UnidirectionalLineState(-1, false, false, -1, -1, 80, -1, -1, -1, null, null)));
        biLineState = (BidirectionalLineState)b2.getComponentState();
        uniLineState = biLineState.getFromTargetToSourceLineState();
        bandwidth = uniLineState.getBandwidth();
        packetIds = new int[3];
        p = new SimpleDataPacket(seqno);
        p.addTrace(t12);
        p.increaseTraceCount();
        packetIds[0] = p.getId();
        DeviceTests.router.receive(p, b1);
        p = new SimpleDataPacket(++seqno);
        p.addTrace(t32);
        p.increaseTraceCount();
        packetIds[1] = p.getId();
        DeviceTests.router.receive(p, b3);
        p = new SimpleDataPacket(++seqno);
        p.addTrace(t12);
        p.increaseTraceCount();
        packetIds[2] = p.getId();
        DeviceTests.router.receive(p, b1);
        i = 1;
        ** GOTO lbl228
        {
            DeviceTests.router.step(step);
            b2.step(step);
            biLineState = (BidirectionalLineState)b1.getComponentState();
            uniLineState = biLineState.getFromSourceToTargetLineState();
            Assert.assertTrue(uniLineState.getPackets().isEmpty());
            uniLineState = biLineState.getFromTargetToSourceLineState();
            Assert.assertTrue(uniLineState.getPackets().isEmpty());
            biLineState = (BidirectionalLineState)b2.getComponentState();
            uniLineState = biLineState.getFromSourceToTargetLineState();
            Assert.assertTrue(uniLineState.getPackets().isEmpty());
            uniLineState = biLineState.getFromTargetToSourceLineState();
            packets = uniLineState.getPackets();
            Assert.assertFalse(packets.isEmpty());
            Assert.assertTrue(packets.size() == i);
            j = 0;
            while (j < i) {
                Assert.assertTrue(packets.get(j) == packetIds[j]);
                ++j;
            }
            biLineState = (BidirectionalLineState)b3.getComponentState();
            uniLineState = biLineState.getFromSourceToTargetLineState();
            Assert.assertTrue(uniLineState.getPackets().isEmpty());
            uniLineState = biLineState.getFromTargetToSourceLineState();
            Assert.assertTrue(uniLineState.getPackets().isEmpty());
            ++step;
            do {
                if (step < i * (100 - bandwidth)) continue block2;
                ++i;
lbl228:
                // 2 sources

            } while (i <= 3);
        }
    }

    @Test
    public void testHostBuffer() {
        SimpleDataPacket p;
        int step = 1;
        int[] packetIds = new int[10];
        BidirectionalLine b = new BidirectionalLine(host1, host2);
        b.changeObjectState(new BidirectionalLineState(-1, false, false, -1, -1, new UnidirectionalLineState(-1, false, false, -1, -1, 100, -1, -1, -1, null, null), null));
        host1.addLine(b);
        host2.addLine(b);
        LinkedList<Integer> lines = new LinkedList<Integer>();
        lines.add(b.getId());
        Trace trace = new Trace(host1, lines, hostId2);
        int i = 0;
        while (i < 10) {
            p = new SimpleDataPacket(i);
            p.addSource(host1);
            p.addTrace(trace);
            host1.send(p);
            packetIds[i] = p.getId();
            ++i;
        }
        i = 0;
        while (i < 5) {
            p = new SimpleDataPacket(i);
            p.addSource(host1);
            p.addTrace(trace);
            host1.deleteFromSendBuffer(p);
            ++i;
        }
        host1.step(step);
        b.step(step);
        ++step;
        BidirectionalLineState biLineState = (BidirectionalLineState)b.getComponentState();
        UnidirectionalLineState uniLineState = biLineState.getFromTargetToSourceLineState();
        Assert.assertTrue(uniLineState.getPackets().isEmpty());
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertFalse(uniLineState.getPackets().isEmpty());
        Assert.assertTrue(uniLineState.getPackets().size() == 1);
        Assert.assertTrue(uniLineState.getPackets().get(0) == packetIds[5]);
        host1.step(step);
        b.step(step);
        ++step;
        biLineState = (BidirectionalLineState)b.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().size() == 2);
        Assert.assertTrue(uniLineState.getPackets().get(0) == packetIds[5]);
        Assert.assertTrue(uniLineState.getPackets().get(1) == packetIds[6]);
        host1.step(step);
        b.step(step);
        ++step;
        biLineState = (BidirectionalLineState)b.getComponentState();
        uniLineState = biLineState.getFromSourceToTargetLineState();
        Assert.assertTrue(uniLineState.getPackets().size() == 3);
        Assert.assertTrue(uniLineState.getPackets().get(0) == packetIds[5]);
        Assert.assertTrue(uniLineState.getPackets().get(1) == packetIds[6]);
        Assert.assertTrue(uniLineState.getPackets().get(2) == packetIds[7]);
    }
}

