/*
 * Decompiled with CFR 0.152.
 */
package model.components.lines;

import events.BidirectionalLineState;
import events.ComponentState;
import events.SignificantChangeEvent;
import events.UnidirectionalLineState;
import java.util.Observable;
import model.components.devices.Device;
import model.components.lines.AbstractLine;
import model.components.lines.UnidirectionalLine;
import model.components.packets.Packet;

public class BidirectionalLine
extends AbstractLine {
    private Device source;
    private Device target;
    private UnidirectionalLine sourceToTarget;
    private UnidirectionalLine targetToSource;

    public BidirectionalLine(Device source, Device target) {
        this.source = source;
        this.target = target;
        this.sourceToTarget = new UnidirectionalLine(this, this);
        this.targetToSource = new UnidirectionalLine(this, this);
        this.sourceToTarget.addObserver(this);
        this.targetToSource.addObserver(this);
    }

    @Override
    public void receive(Packet p, AbstractLine line) {
        if (line == this.sourceToTarget) {
            this.target.receive(p, this);
        } else if (line == this.targetToSource) {
            this.source.receive(p, this);
        }
    }

    @Override
    public void changeObjectState(ComponentState s) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        if (s instanceof BidirectionalLineState) {
            BidirectionalLineState state = (BidirectionalLineState)s;
            if (state.getFromSourceToTargetLineState() != null) {
                try {
                    this.sourceToTarget.changeObjectState(state.getFromSourceToTargetLineState());
                }
                catch (IllegalArgumentException e) {
                    error = true;
                    errorMessage = String.valueOf(errorMessage) + e.getMessage();
                }
            }
            if (state.getFromTargetToSourceLineState() != null) {
                try {
                    this.targetToSource.changeObjectState(state.getFromTargetToSourceLineState());
                }
                catch (IllegalArgumentException e) {
                    error = true;
                    errorMessage = String.valueOf(errorMessage) + e.getMessage();
                }
            }
        } else {
            error = true;
            errorMessage = String.valueOf(errorMessage) + "Wrong state-type for BidirectionalLineState;";
        }
        this.sendNotify(this.getComponentState());
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public ComponentState getComponentState() {
        UnidirectionalLineState sTt = this.sourceToTarget.getComponentState();
        UnidirectionalLineState tTs = this.targetToSource.getComponentState();
        BidirectionalLineState s = new BidirectionalLineState(this.getId(), this.isNew(), false, this.source.getId(), this.target.getId(), sTt, tTs);
        return s;
    }

    @Override
    public void step(int counter) {
        this.sourceToTarget.step(counter);
        this.targetToSource.step(counter);
    }

    @Override
    public void reset() {
        this.sourceToTarget.reset();
        this.targetToSource.reset();
        this.sendNotify(this.getComponentState());
    }

    @Override
    public boolean send(Packet p, int senderId) {
        if (senderId == this.source.getId()) {
            return this.sourceToTarget.send(p, this.getId());
        }
        return this.targetToSource.send(p, this.getId());
    }

    @Override
    public int getTargetDeviceId(int sourceDeviceId) {
        if (this.source != null && this.source.getId() == sourceDeviceId && this.sourceToTarget != null) {
            return this.target.getId();
        }
        if (this.target != null && this.target.getId() == sourceDeviceId && this.targetToSource != null) {
            return this.source.getId();
        }
        return -1;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof UnidirectionalLineState && o instanceof UnidirectionalLine) {
            this.sendNotify(this.getComponentState((UnidirectionalLine)o, (UnidirectionalLineState)arg));
        }
        if (arg instanceof SignificantChangeEvent) {
            this.sendNotify((SignificantChangeEvent)arg);
        }
    }

    private ComponentState getComponentState(UnidirectionalLine line, UnidirectionalLineState state) {
        UnidirectionalLineState tTs;
        UnidirectionalLineState sTt;
        if (line == this.sourceToTarget) {
            sTt = state;
            tTs = null;
        } else {
            sTt = null;
            tTs = state;
        }
        BidirectionalLineState s = new BidirectionalLineState(this.getId(), false, false, this.source.getId(), this.target.getId(), sTt, tTs);
        return s;
    }
}

