/*
 * Decompiled with CFR 0.152.
 */
package model.components.lines;

import events.ComponentState;
import events.PacketState;
import events.SignificantChangeEvent;
import events.UnidirectionalLineState;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Random;
import model.components.Component;
import model.components.lines.AbstractLine;
import model.components.packets.Packet;

public class UnidirectionalLine
extends AbstractLine {
    private final int MAX_BANDWIDTH = 100;
    private final int DEFAULT_BANDWIDTH = 50;
    private int bandwidth = 50;
    private final int DEFAULT_LENGTH = 50;
    private int length = 50;
    private final int DEFAULT_DAMAGE_PERCENTAGE = 0;
    private int damagePercentage = 0;
    private final int DEFAULT_LOSE_PERCENTAGE = 0;
    private int losePercentage = 0;
    private Component target;
    private Component source;
    private int stepsUntilNextPackage = 0;
    private Random randomizer = new Random();
    private List<Packet> packets;
    private List<Integer> packetProgress;
    private List<Integer> absolutePacketProgress;

    public UnidirectionalLine(Component source, Component target) {
        this.source = source;
        this.target = target;
        this.packets = new ArrayList<Packet>();
        this.packetProgress = new ArrayList<Integer>();
        this.absolutePacketProgress = new ArrayList<Integer>();
    }

    @Override
    public boolean send(Packet p, int senderId) {
        boolean sent = false;
        if (this.bandwidth > 0 && senderId == this.source.getId() && this.stepsUntilNextPackage <= 0) {
            if (!this.losePacket(p)) {
                this.damagePacket(p);
                this.packets.add(p);
                this.packetProgress.add(0);
                this.absolutePacketProgress.add(0);
                p.addObserver(this);
            }
            this.stepsUntilNextPackage = 100 - this.bandwidth;
            sent = true;
            this.sendNotify(this.getComponentState());
        }
        return sent;
    }

    @Override
    public void changeObjectState(ComponentState s) {
        boolean error = false;
        String errorMessage = "";
        if (s instanceof UnidirectionalLineState) {
            UnidirectionalLineState state = (UnidirectionalLineState)s;
            int tmp = state.getBandwidth();
            if (tmp > -1 && tmp <= 100) {
                this.bandwidth = tmp;
            } else if (tmp < -1 || tmp > 100) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + "Illegal value for bandwidth in UnidrectionalLine: " + tmp + ";";
                this.bandwidth = 50;
            }
            tmp = state.getDamagePercentage();
            if (tmp > -1) {
                this.damagePercentage = tmp;
            } else if (tmp < -1) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + "Illegal value for damagePercentage in UnidirectionalLine: " + tmp + ";";
                this.damagePercentage = 0;
            }
            tmp = state.getLength();
            if (tmp > -1) {
                this.length = tmp;
            } else if (tmp < -1) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + "Illegal value for length in UnidirectionalLine: " + tmp + ";";
                this.length = 50;
            }
            tmp = state.getLosePercentage();
            if (tmp > -1) {
                this.losePercentage = tmp;
            } else if (tmp < -1) {
                error = true;
                errorMessage = String.valueOf(errorMessage) + "Illegal value for losePercentage in UnidirectionalLine: " + tmp + ";";
                this.losePercentage = 0;
            }
        } else {
            error = true;
            errorMessage = String.valueOf(errorMessage) + "Wrong state-type in UnidirectionalState;";
        }
        this.sendNotify(this.getComponentState());
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public UnidirectionalLineState getComponentState() {
        List<Integer> packetIDs = this.getPacketList();
        List<Integer> packetProgress = this.getPacketProgressList();
        UnidirectionalLineState s = new UnidirectionalLineState(this.getId(), this.isNew(), false, this.source.getId(), this.target.getId(), this.bandwidth, this.damagePercentage, this.losePercentage, this.length, packetIDs, packetProgress);
        return s;
    }

    @Override
    public void step(int counter) {
        LinkedList<Integer> packetProgress = new LinkedList<Integer>();
        LinkedList<Integer> absolutePacketProgress = new LinkedList<Integer>();
        LinkedList<Packet> packets = new LinkedList<Packet>();
        LinkedList<Packet> finishedPackets = new LinkedList<Packet>();
        int i = 0;
        while (i < this.packetProgress.size()) {
            int absoluteProg = this.absolutePacketProgress.get(i) + 1;
            int prog = absoluteProg * 100 / this.length;
            Packet p = this.packets.get(i);
            if (absoluteProg >= this.length) {
                p.increaseTraceCount();
                p.deleteObserver(this);
                this.absolutePacketProgress.set(i, this.length);
                this.packetProgress.set(i, 100);
                finishedPackets.add(p);
            } else {
                if (absoluteProg >= this.length - 1) {
                    this.sendNotify(new SignificantChangeEvent());
                }
                this.absolutePacketProgress.set(i, absoluteProg);
                absolutePacketProgress.add(absoluteProg);
                this.packetProgress.set(i, prog);
                packetProgress.add(prog);
                packets.add(p);
            }
            ++i;
        }
        if (this.packetProgress.size() > 0) {
            this.sendNotify(this.getComponentState());
        }
        for (Packet p : finishedPackets) {
            this.target.receive(p, this);
        }
        this.packets = packets;
        this.packetProgress = packetProgress;
        this.absolutePacketProgress = absolutePacketProgress;
        --this.stepsUntilNextPackage;
    }

    @Override
    public void reset() {
        this.stepsUntilNextPackage = 0;
        this.packets.clear();
        this.packetProgress.clear();
        this.absolutePacketProgress.clear();
        this.sendNotify(this.getComponentState());
    }

    @Override
    public int getTargetDeviceId(int sourceDeviceId) {
        if (this.target != null) {
            return this.target.getId();
        }
        return -1;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Packet && arg instanceof PacketState && ((PacketState)arg).isDeleted()) {
            this.absolutePacketProgress.remove(this.packets.indexOf(o));
            this.packetProgress.remove(this.packets.indexOf(o));
            this.packets.remove((Packet)o);
            this.sendNotify(this.getComponentState());
        }
    }

    private List<Integer> getPacketList() {
        LinkedList<Integer> packetList = new LinkedList<Integer>();
        for (Packet p : this.packets) {
            packetList.add(p.getId());
        }
        return packetList;
    }

    private List<Integer> getPacketProgressList() {
        LinkedList<Integer> packetProgressList = new LinkedList<Integer>();
        for (Integer i : this.packetProgress) {
            packetProgressList.add(i);
        }
        return packetProgressList;
    }

    private boolean losePacket(Packet p) {
        boolean lost;
        boolean bl = lost = this.randomizer.nextInt(99) + 1 <= this.losePercentage;
        if (lost) {
            p.lose();
        }
        return lost;
    }

    private void damagePacket(Packet p) {
        if (this.randomizer.nextInt(99) + 1 <= this.damagePercentage) {
            p.damage();
        }
    }
}

