/*
 * Decompiled with CFR 0.152.
 */
package model.components.packets;

import events.ComponentState;
import events.PacketState;
import events.TraceData;
import model.Trace;
import model.components.Component;
import model.components.devices.Host;

public abstract class Packet
extends Component {
    protected Host source;
    protected Trace trace;
    protected int sequenceNumber;
    protected boolean damaged = false;
    protected boolean lost = false;
    private int traceCount = 0;
    private int currentStep;

    public Packet(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void addSource(Host source) {
        if (this.source == null) {
            this.source = source;
        }
    }

    public void addTrace(Trace trace) {
        if (this.trace == null && trace != null) {
            TraceData data = trace.getData();
            Host targetHost = trace.getTargetHost();
            this.trace = new Trace(targetHost, data.getLines(), trace.getSourceHostId());
        }
    }

    @Override
    public abstract ComponentState getComponentState();

    @Override
    public void changeObjectState(ComponentState s) throws IllegalArgumentException {
        boolean error = false;
        String errorMessage = "";
        if (s instanceof PacketState) {
            PacketState p = (PacketState)s;
            if (!p.isDeleted()) {
                this.damaged = p.isDamaged();
                this.lost = p.isLost();
            } else {
                this.lose();
            }
        } else {
            errorMessage = String.valueOf(errorMessage) + "Wrong state-type for Packet;";
            error = true;
        }
        this.sendNotify(this.getComponentState());
        if (error) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public Host getSource() {
        return this.source;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public boolean isDamaged() {
        return this.damaged;
    }

    public void damage() {
        this.damaged = true;
        this.sendNotify(this.getComponentState());
    }

    public void repair() {
        this.damaged = false;
    }

    public void lose() {
        this.lost = true;
        this.sendNotify(this.getComponentState());
    }

    public void increaseTraceCount() {
        ++this.traceCount;
    }

    public int getNextLineId() {
        return this.trace.getLine(this.traceCount);
    }

    public int getTraceCount() {
        return this.traceCount;
    }

    @Override
    public void step(int counter) {
        this.currentStep = counter;
    }

    public boolean equalsPacket(Packet p) {
        return p.sequenceNumber == this.sequenceNumber && p.source == this.source && (p.trace == null && this.trace == null || p.trace.getTargetHost() == this.trace.getTargetHost());
    }
}

