/*
 * Decompiled with CFR 0.152.
 */
package model.components.packets.tests;

import events.DataPacketState;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import model.Trace;
import model.components.devices.Host;
import model.components.devices.Router;
import model.components.lines.BidirectionalLine;
import model.components.packets.SimpleDataPacket;
import org.junit.Assert;
import org.junit.Test;

public class TestPacket
implements Observer {
    private DataPacketState state;

    @Test
    public void testPacket() {
        Host host1 = new Host();
        Host host2 = new Host();
        int hostId2 = host2.getId();
        Router router = new Router();
        BidirectionalLine b1 = new BidirectionalLine(host1, router);
        BidirectionalLine b2 = new BidirectionalLine(router, host2);
        LinkedList<Integer> lines = new LinkedList<Integer>();
        lines.add(b1.getId());
        lines.add(b2.getId());
        Trace t = new Trace(host1, lines, hostId2);
        SimpleDataPacket p = new SimpleDataPacket(0);
        p.addSource(host1);
        p.addTrace(t);
        Assert.assertTrue(p.getSource() == host1);
        Assert.assertTrue(p.getCurrentStep() == 0);
        Assert.assertTrue(p.getSequenceNumber() == 0);
        Assert.assertTrue(p.getNextLineId() == b1.getId());
        p.step(5);
        p.increaseTraceCount();
        Assert.assertTrue(p.getCurrentStep() == 5);
        Assert.assertTrue(p.getNextLineId() == b2.getId());
        p.addObserver(this);
        p.lose();
        Assert.assertTrue(this.state.isLost());
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg1 instanceof DataPacketState) {
            this.state = (DataPacketState)arg1;
        }
    }
}

