/*
 * Decompiled with CFR 0.152.
 */
package model.parsing.xml;

import events.BidirectionalLineState;
import events.BufferState;
import events.ComponentState;
import events.ConnectionData;
import events.GoBackNState;
import events.HostState;
import events.ProtocolState;
import events.RouterState;
import events.SelectiveRepeatState;
import events.StopAndWaitState;
import events.UnidirectionalLineState;
import java.awt.Color;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import model.Model;
import model.Scenario;
import model.parsing.xml.XmlUtil;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

public class ScenarioBuilder
implements Observer {
    private Model observer;
    private Element rootNode;
    private Scenario newScenario;
    private int outdatedId;

    public ScenarioBuilder(Element rootNode, Model observer) {
        this.rootNode = rootNode;
        this.observer = observer;
    }

    public Scenario buildScenario() throws IOException {
        this.newScenario = new Scenario();
        this.newScenario.addObserver(this);
        if (this.observer != null) {
            this.observer.setActiveScenario(this.newScenario);
        }
        try {
            Element protocolNode = (Element)XPath.selectSingleNode(this.rootNode, "Protocol");
            this.newScenario.setScenarioName(this.rootNode.getAttributeValue("Name"));
            this.newScenario.setProtocol(Integer.parseInt(protocolNode.getAttributeValue("pID")));
            this.newScenario.setProtocolSettings(this.getProtocolSettings(protocolNode));
            this.createHosts();
            this.createRouters();
            this.createBidirectionalLines();
            this.createUnidirectionalLines();
            this.configureRouters();
            this.configureConnections();
        }
        catch (JDOMException e) {
            throw new IOException("File corrupted; Stopped building scenario;");
        }
        catch (NullPointerException e) {
            throw new IOException("File corrupted; Stopped building scenario;");
        }
        this.newScenario.deleteObserver(this);
        return this.newScenario;
    }

    private UnidirectionalLineState getUnidirectionalLineState(Element uniLineNode, int sourceId, int targetId) {
        int bandwidth = Integer.parseInt(uniLineNode.getAttributeValue("Bandwidth"));
        int damagePercentage = Integer.parseInt(uniLineNode.getAttributeValue("DamageChance"));
        int losePercentage = Integer.parseInt(uniLineNode.getAttributeValue("LoseChance"));
        int length = Integer.parseInt(uniLineNode.getAttributeValue("Length"));
        return new UnidirectionalLineState(-1, true, false, sourceId, targetId, bandwidth, damagePercentage, losePercentage, length, null, null);
    }

    private UnidirectionalLineState getUnidirectionalLineState(Element uniLineNode) throws JDOMException {
        int sourceId = Integer.parseInt(uniLineNode.getAttributeValue("SourceID"));
        sourceId = this.getNewId(sourceId);
        int targetId = Integer.parseInt(uniLineNode.getAttributeValue("TargetID"));
        targetId = this.getNewId(targetId);
        return this.getUnidirectionalLineState(uniLineNode, sourceId, targetId);
    }

    private int getNewId(int oldId) throws JDOMException {
        Element tmpNode = XmlUtil.getElementByAttribute(this.rootNode, "ID", "" + oldId);
        String result = tmpNode.getAttributeValue("newID");
        if (result == null) {
            return -1;
        }
        return Integer.parseInt(result);
    }

    private int getOldId(int newId) throws JDOMException {
        Element tmpNode = XmlUtil.getElementByAttribute(this.rootNode, "newID", "" + newId);
        String result = tmpNode.getAttributeValue("ID");
        if (result == null) {
            return -1;
        }
        return Integer.parseInt(result);
    }

    private ProtocolState getProtocolSettings(Element protocolNode) {
        String type = protocolNode.getAttributeValue("Type");
        int timeout = Integer.parseInt(protocolNode.getAttributeValue("Timeout"));
        ProtocolState result = null;
        if (type.equals("StopAndWait")) {
            result = new StopAndWaitState(timeout);
        } else if (type.equals("GoBackN")) {
            int winSize = Integer.parseInt(protocolNode.getAttributeValue("WindowSize"));
            boolean useNAK = Boolean.parseBoolean(protocolNode.getAttributeValue("UseNAK"));
            result = new GoBackNState(timeout, winSize, useNAK);
        } else if (type.equals("SelectiveRepeat") || type.equals("SelectiveReject")) {
            int winSize = Integer.parseInt(protocolNode.getAttributeValue("WindowSize"));
            boolean useNAK = Boolean.parseBoolean(protocolNode.getAttributeValue("UseNAK"));
            result = new SelectiveRepeatState(timeout, winSize, useNAK);
        }
        return result;
    }

    private void createHosts() throws JDOMException {
        List hostList = XPath.selectNodes(this.rootNode, "Host");
        for (Element h : hostList) {
            String name = h.getAttributeValue("Name");
            Color color = new Color(Integer.parseInt(h.getAttributeValue("Color")));
            int posX = Integer.parseInt(h.getAttributeValue("posX"));
            int posY = Integer.parseInt(h.getAttributeValue("posY"));
            HostState hostState = new HostState(-1, true, false, name, color, posX, posY, null, -1, null);
            this.outdatedId = Integer.parseInt(h.getAttributeValue("ID"));
            this.newScenario.changeObjectState(hostState);
        }
    }

    private void createRouters() throws JDOMException {
        List routerList = XPath.selectNodes(this.rootNode, "Router");
        for (Element r : routerList) {
            String name = r.getAttributeValue("Name");
            Color color = new Color(Integer.parseInt(r.getAttributeValue("Color")));
            int posX = Integer.parseInt(r.getAttributeValue("posX"));
            int posY = Integer.parseInt(r.getAttributeValue("posY"));
            int processingTime = Integer.parseInt(r.getAttributeValue("ProcessingTime"));
            RouterState routerState = new RouterState(-1, true, false, name, color, posX, posY, processingTime, null, null);
            this.outdatedId = Integer.parseInt(r.getAttributeValue("ID"));
            this.newScenario.changeObjectState(routerState);
        }
    }

    private void createBidirectionalLines() throws JDOMException {
        List biLineList = XPath.selectNodes(this.rootNode, "BidirectionalLine");
        for (Element b : biLineList) {
            int sourceId = Integer.parseInt(b.getAttributeValue("SourceID"));
            sourceId = this.getNewId(sourceId);
            int targetId = Integer.parseInt(b.getAttributeValue("TargetID"));
            targetId = this.getNewId(targetId);
            UnidirectionalLineState forw = this.getUnidirectionalLineState((Element)XPath.selectSingleNode(b, "ForwardLine"), -1, -1);
            UnidirectionalLineState backw = this.getUnidirectionalLineState((Element)XPath.selectSingleNode(b, "BackwardLine"), -1, -1);
            BidirectionalLineState biLineState = new BidirectionalLineState(-1, true, false, sourceId, targetId, forw, backw);
            this.outdatedId = Integer.parseInt(b.getAttributeValue("ID"));
            this.newScenario.changeObjectState(biLineState);
        }
    }

    private void createUnidirectionalLines() throws JDOMException {
        List uniLineList = XPath.selectNodes(this.rootNode, "UnidirectionalLine");
        for (Element u : uniLineList) {
            this.outdatedId = Integer.parseInt(u.getAttributeValue("ID"));
            this.newScenario.changeObjectState(this.getUnidirectionalLineState(u));
        }
    }

    private void configureRouters() throws JDOMException {
        List routerList = XPath.selectNodes(this.rootNode, "Router");
        for (Element r : routerList) {
            List lineList = XPath.selectNodes(r, ".//Line");
            int routerId = Integer.parseInt(r.getAttributeValue("newID"));
            LinkedList<Integer> lineIds = new LinkedList<Integer>();
            LinkedList<BufferState> bufList = new LinkedList<BufferState>();
            for (Element l : lineList) {
                lineIds.add(Integer.parseInt(l.getAttributeValue("newID")));
                int bufferId = Integer.parseInt(l.getAttributeValue("newBufferID"));
                int capacity = Integer.parseInt(l.getAttributeValue("Buffersize"));
                bufList.add(new BufferState(bufferId, false, false, capacity, null));
            }
            this.newScenario.changeObjectState(new RouterState(routerId, false, false, null, null, -1, -1, -1, lineIds, bufList));
        }
    }

    private void configureConnections() throws JDOMException {
        List hostList = XPath.selectNodes(this.rootNode, "Host");
        for (Element h : hostList) {
            int sourceHostId = Integer.parseInt(h.getAttributeValue("newID"));
            List conList = XPath.selectNodes(h, "Connection");
            LinkedList<ConnectionData> conDataList = new LinkedList<ConnectionData>();
            if (conList != null) {
                for (Element c : conList) {
                    int targetHostId = Integer.parseInt(c.getAttributeValue("TargetID"));
                    targetHostId = this.getNewId(targetHostId);
                    int bandwidth = Integer.parseInt(c.getAttributeValue("Bandwidth"));
                    int inBufferCap = -1;
                    String sBufferCap = c.getAttributeValue("IncomingBufferCapacity");
                    if (sBufferCap != null) {
                        inBufferCap = Integer.parseInt(sBufferCap);
                    }
                    int outBufferCap = -1;
                    sBufferCap = c.getAttributeValue("OutgoingBufferCapacity");
                    if (sBufferCap != null) {
                        outBufferCap = Integer.parseInt(sBufferCap);
                    }
                    BufferState inBufferState = new BufferState(-1, false, false, inBufferCap, null);
                    BufferState outBufferState = new BufferState(-1, false, false, outBufferCap, null);
                    ProtocolState pState = null;
                    if (c.getChild("Protocol") != null) {
                        String protocol;
                        String sTimeout = c.getChild("Protocol").getAttributeValue("Timeout");
                        int timeout = -1;
                        if (sTimeout != null) {
                            timeout = Integer.parseInt(sTimeout);
                        }
                        if ((protocol = c.getChild("Protocol").getAttributeValue("Name")).equals("StopAndWait")) {
                            pState = new StopAndWaitState(timeout);
                        } else if (protocol.equals("GoBackN")) {
                            pState = new GoBackNState(timeout, -1, false);
                        } else if (protocol.equals("SelectiveRepeat")) {
                            pState = new SelectiveRepeatState(timeout, -1, false);
                        }
                    }
                    conDataList.add(new ConnectionData(bandwidth, targetHostId, inBufferState, outBufferState, null, null, pState));
                }
            }
            this.newScenario.changeObjectState(new HostState(sourceHostId, false, false, null, null, -1, -1, null, -1, conDataList));
        }
    }

    @Override
    public void update(Observable observable, Object eventArgs) {
        if (eventArgs instanceof ComponentState) {
            RouterState r;
            ComponentState c = (ComponentState)eventArgs;
            if (c.isNew()) {
                Element tmpNode = XmlUtil.getElementByAttribute(this.rootNode, "ID", "" + this.outdatedId);
                tmpNode.setAttribute("newID", "" + c.getComponentId());
            } else if (c instanceof RouterState && (r = (RouterState)c).getBuffers() != null) {
                Iterator<BufferState> bufIterator = r.getBuffers().iterator();
                int i = 0;
                int routerId = r.getComponentId();
                int oldId = -1;
                while (bufIterator.hasNext()) {
                    BufferState b = bufIterator.next();
                    if (b.isNew()) {
                        int newId = r.getLines().get(i);
                        try {
                            oldId = this.getOldId(newId);
                        }
                        catch (JDOMException e) {
                            e.printStackTrace();
                        }
                        Element tmpNode = null;
                        try {
                            tmpNode = (Element)XPath.selectSingleNode(this.rootNode, "//Router[@newID='" + routerId + "']" + "//Line[@ID='" + oldId + "']");
                        }
                        catch (JDOMException e) {
                            e.printStackTrace();
                        }
                        tmpNode.setAttribute("newID", "" + newId);
                        tmpNode.setAttribute("newBufferID", "" + b.getComponentId());
                    }
                    ++i;
                }
            }
        }
    }
}

