/*
 * Decompiled with CFR 0.152.
 */
package model.parsing.xml;

import events.BidirectionalLineState;
import events.BufferState;
import events.ComponentState;
import events.ConnectionData;
import events.DeviceState;
import events.EventArgs;
import events.GoBackNState;
import events.HostState;
import events.PacketState;
import events.ProtocolState;
import events.RouterState;
import events.ScenarioState;
import events.SelectiveRepeatState;
import events.StopAndWaitState;
import events.UnidirectionalLineState;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import model.Scenario;
import org.jdom.Element;

public class XmlBuilder {
    private final Scenario scenario;

    public XmlBuilder(Scenario s) {
        this.scenario = s;
    }

    public Element buildXml() {
        Element rootNode = new Element("Scenario");
        LinkedList<HostState> hostList = new LinkedList<HostState>();
        LinkedList<RouterState> routerList = new LinkedList<RouterState>();
        LinkedList<UnidirectionalLineState> uniLineList = new LinkedList<UnidirectionalLineState>();
        LinkedList<BidirectionalLineState> biLineList = new LinkedList<BidirectionalLineState>();
        ScenarioState scenarioState = null;
        ProtocolState protocolState = null;
        List<EventArgs> eventList = this.scenario.getWrapInformation();
        for (EventArgs eventArgs : eventList) {
            if (eventArgs instanceof PacketState) continue;
            if (eventArgs instanceof HostState) {
                hostList.add((HostState)eventArgs);
                continue;
            }
            if (eventArgs instanceof RouterState) {
                routerList.add((RouterState)eventArgs);
                continue;
            }
            if (eventArgs instanceof BidirectionalLineState) {
                biLineList.add((BidirectionalLineState)eventArgs);
                continue;
            }
            if (eventArgs instanceof UnidirectionalLineState) {
                uniLineList.add((UnidirectionalLineState)eventArgs);
                continue;
            }
            if (eventArgs instanceof ScenarioState) {
                scenarioState = (ScenarioState)eventArgs;
                continue;
            }
            if (!(eventArgs instanceof ProtocolState)) continue;
            protocolState = (ProtocolState)eventArgs;
        }
        rootNode.setAttribute("Name", scenarioState.getName());
        this.saveProtocol(rootNode, scenarioState, protocolState);
        for (HostState hostState : hostList) {
            this.saveHost(rootNode, hostState);
        }
        for (RouterState routerState : routerList) {
            this.saveRouter(rootNode, routerState);
        }
        for (BidirectionalLineState bidirectionalLineState : biLineList) {
            this.saveBidirectionalLine(rootNode, bidirectionalLineState);
        }
        for (UnidirectionalLineState unidirectionalLineState : uniLineList) {
            this.saveUnidirectionalLine(rootNode, unidirectionalLineState);
        }
        return rootNode;
    }

    private void saveProtocol(Element rootNode, ScenarioState s, ProtocolState p) {
        Element inputNode = new Element("Protocol");
        inputNode.setAttribute("pID", "" + s.getProtocolId());
        inputNode.setAttribute("Timeout", "" + p.getTimeout());
        if (p instanceof StopAndWaitState) {
            inputNode.setAttribute("Type", "StopAndWait");
        } else if (p instanceof GoBackNState) {
            inputNode.setAttribute("Type", "GoBackN");
            inputNode.setAttribute("WindowSize", "" + ((GoBackNState)p).getWinSize());
            inputNode.setAttribute("UseNAK", "" + ((GoBackNState)p).getNAK());
        } else if (p instanceof SelectiveRepeatState) {
            inputNode.setAttribute("Type", "SelectiveRepeat");
            inputNode.setAttribute("WindowSize", "" + ((SelectiveRepeatState)p).getWinSize());
            inputNode.setAttribute("UseNAK", "" + ((SelectiveRepeatState)p).getNAK());
        } else {
            inputNode.setAttribute("Type", "unkown");
        }
        rootNode.addContent(inputNode);
    }

    private void saveHost(Element rootNode, HostState h) {
        Element inputNode = new Element("Host");
        this.configureDeviceNode(inputNode, h);
        List<ConnectionData> conList = h.getConnections();
        for (ConnectionData c : conList) {
            Element conNode = new Element("Connection");
            conNode.setAttribute("TargetID", "" + c.getTargetHostId());
            conNode.setAttribute("Bandwidth", "" + c.getBandwidth());
            conNode.setAttribute("IncomingBufferCapacity", "" + c.getIncomingBufferState().getCapacity());
            conNode.setAttribute("OutgoingBufferCapacity", "" + c.getOutgoingBufferState().getCapacity());
            Element protNode = new Element("Protocol");
            protNode.setAttribute("Timeout", "" + c.getProtocolState().getTimeout());
            String protocol = "";
            if (c.getProtocolState() instanceof StopAndWaitState) {
                protocol = "StopAndWait";
            } else if (c.getProtocolState() instanceof GoBackNState) {
                protocol = "GoBackN";
            } else if (c.getProtocolState() instanceof SelectiveRepeatState) {
                protocol = "SelectiveRepeat";
            }
            protNode.setAttribute("Name", protocol);
            conNode.addContent(protNode);
            inputNode.addContent(conNode);
        }
        rootNode.addContent(inputNode);
    }

    private void saveRouter(Element rootNode, RouterState r) {
        Element inputNode = new Element("Router");
        this.configureDeviceNode(inputNode, r);
        inputNode.setAttribute("ProcessingTime", "" + r.getProcessingTime());
        if (r.getBuffers() != null && r.getLines() != null) {
            Iterator<BufferState> bufIterator = r.getBuffers().iterator();
            Iterator<Integer> lineIterator = r.getLines().iterator();
            while (lineIterator.hasNext()) {
                Element lineNode = new Element("Line");
                lineNode.setAttribute("ID", "" + lineIterator.next());
                BufferState buf = bufIterator.next();
                lineNode.setAttribute("BufferID", "" + buf.getComponentId());
                lineNode.setAttribute("Buffersize", "" + buf.getCapacity());
                inputNode.addContent(lineNode);
            }
        }
        rootNode.addContent(inputNode);
    }

    private void saveBidirectionalLine(Element rootNode, BidirectionalLineState b) {
        Element inputNode = new Element("BidirectionalLine");
        this.configureComponentNode(inputNode, b);
        inputNode.setAttribute("SourceID", "" + b.getSourceDeviceId());
        inputNode.setAttribute("TargetID", "" + b.getTargetDeviceId());
        Element lineNode = new Element("ForwardLine");
        this.configureUniLineNode(lineNode, b.getFromSourceToTargetLineState());
        inputNode.addContent(lineNode);
        lineNode = new Element("BackwardLine");
        this.configureUniLineNode(lineNode, b.getFromTargetToSourceLineState());
        inputNode.addContent(lineNode);
        rootNode.addContent(inputNode);
    }

    private void saveUnidirectionalLine(Element rootNode, UnidirectionalLineState u) {
        Element inputNode = new Element("UnidirectionalLine");
        this.configureUniLineNode(inputNode, u);
        rootNode.addContent(inputNode);
    }

    private void configureDeviceNode(Element node, DeviceState d) {
        this.configureComponentNode(node, d);
        node.setAttribute("Name", d.getName());
        node.setAttribute("Color", "" + d.getColor().getRGB());
        node.setAttribute("posX", "" + d.getX());
        node.setAttribute("posY", "" + d.getY());
    }

    private void configureComponentNode(Element node, ComponentState c) {
        node.setAttribute("ID", "" + c.getComponentId());
    }

    private void configureUniLineNode(Element node, UnidirectionalLineState l) {
        this.configureComponentNode(node, l);
        node.setAttribute("SourceID", "" + l.getSourceComponentId());
        node.setAttribute("TargetID", "" + l.getTargetComponentId());
        node.setAttribute("Bandwidth", "" + l.getBandwidth());
        node.setAttribute("Length", "" + l.getLength());
        node.setAttribute("DamageChance", "" + l.getDamagePercentage());
        node.setAttribute("LoseChance", "" + l.getLosePercentage());
    }
}

