/*
 * Decompiled with CFR 0.152.
 */
package model.parsing.xml;

import events.Settings;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import model.Model;
import model.Scenario;
import model.parsing.ScenarioParser;
import model.parsing.xml.ScenarioBuilder;
import model.parsing.xml.XmlBuilder;
import model.parsing.xml.XmlUtil;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

public class XmlParser
extends ScenarioParser {
    private final String PATH_SETTINGS = "Settings.xml";
    private final String PATH_SCENARIOS = "Scenarios.xml";

    public XmlParser(Model m) {
        super(m);
    }

    @Override
    public void saveSettings(Settings s) throws IOException {
        Element rootElement = new Element("Settings");
        Element languageElement = new Element("Language");
        Element bgColorElement = new Element("bgColor");
        languageElement.addContent(s.getLanguage().getLanguage());
        bgColorElement.addContent("" + s.getBgColor().getRGB());
        rootElement.addContent(languageElement);
        rootElement.addContent(bgColorElement);
        Document doc = new Document(rootElement);
        XmlUtil.output(doc, "Settings.xml");
    }

    @Override
    public Settings loadSettings() throws IOException {
        Settings result = new Settings();
        try {
            Document settingsDoc;
            try {
                settingsDoc = XmlUtil.input("Settings.xml");
            }
            catch (IOException e) {
                this.saveSettings(result);
                return result;
            }
            Element rootNode = settingsDoc.getRootElement();
            result.setLanguage(new Locale(rootNode.getChild("Language").getText()));
            result.setBgColor(new Color(Integer.parseInt(rootNode.getChild("bgColor").getText())));
            return result;
        }
        catch (JDOMException e) {
            this.saveSettings(result);
            return result;
        }
    }

    @Override
    public Scenario loadScenario(int scenarioId) throws IOException {
        try {
            Document scenarios = XmlUtil.input("Scenarios.xml");
            Element scenRoot = scenarios.getRootElement();
            List scenList = XPath.selectNodes(scenRoot, "Scenario");
            ScenarioBuilder scenBuilder = new ScenarioBuilder((Element)scenList.get(scenarioId), this.observer);
            return scenBuilder.buildScenario();
        }
        catch (JDOMException e) {
            this.createScenarioFile();
            throw new IOException("Error reading Scenarios.xml; Tried to create adefault file;");
        }
        catch (FileNotFoundException e) {
            this.createScenarioFile();
            throw new IOException("Error reading Scenarios.xml; Tried to create adefault file;");
        }
    }

    @Override
    public Scenario loadScenario(String path) throws IOException {
        try {
            Document doc = XmlUtil.input(path);
            ScenarioBuilder scenBuilder = new ScenarioBuilder(doc.getRootElement(), this.observer);
            return scenBuilder.buildScenario();
        }
        catch (JDOMException e) {
            throw new IOException("Error reading " + path);
        }
        catch (FileNotFoundException e) {
            this.createScenarioFile();
            throw new IOException("Error reading Scenarios.xml; Tried to create adefault file;");
        }
    }

    @Override
    public void removeScenario(int scenarioId) throws IOException {
        try {
            Document scenarios = XmlUtil.input("Scenarios.xml");
            Element scenRoot = scenarios.getRootElement();
            List scenList = XPath.selectNodes(scenRoot, "Scenario");
            scenRoot.removeContent((Content)scenList.get(scenarioId));
            XmlUtil.output(scenarios, "Scenarios.xml");
        }
        catch (JDOMException e) {
            throw new IOException("An error occurred. Scenario " + scenarioId + " could not be deleted");
        }
    }

    @Override
    public void renameScenario(String newName, int scenarioId) throws IOException {
        Scenario s = this.loadScenario(scenarioId);
        s.setScenarioName(newName);
        this.saveScenario(scenarioId, s);
    }

    @Override
    public void saveScenario(String path, Scenario s) throws IOException {
        XmlBuilder xmlBuilder = new XmlBuilder(s);
        Element scenNode = xmlBuilder.buildXml();
        XmlUtil.output(new Document(scenNode), path);
    }

    @Override
    public void saveScenario(int scenarioId, Scenario s) throws IOException {
        try {
            Document scenarios = XmlUtil.input("Scenarios.xml");
            Element scenRoot = scenarios.getRootElement();
            List scenList = XPath.selectNodes(scenRoot, "Scenario");
            XmlBuilder xmlBuilder = new XmlBuilder(s);
            if (scenarioId > -1 && scenarioId < scenList.size()) {
                scenList.set(scenarioId, xmlBuilder.buildXml());
                Element newRoot = new Element("Scenarios");
                for (Element e : scenList) {
                    newRoot.addContent(e);
                }
                XmlUtil.output(scenarios, "Scenarios.xml");
            } else {
                scenRoot.addContent(xmlBuilder.buildXml());
                XmlUtil.output(scenarios, "Scenarios.xml");
            }
        }
        catch (JDOMException e) {
            this.createScenarioFile();
            throw new IOException("Error while saving Scenario; Tried to createa default file.");
        }
        catch (FileNotFoundException e) {
            this.createScenarioFile();
            throw new IOException("Error reading Scenarios.xml; Tried to create adefault file;");
        }
    }

    @Override
    public List<String> getScenarioList() throws IOException {
        try {
            Document scenarios = XmlUtil.input("Scenarios.xml");
            Element scenRoot = scenarios.getRootElement();
            LinkedList<String> scenNames = new LinkedList<String>();
            List scenList = XPath.selectNodes(scenRoot, "Scenario");
            for (Element e : scenList) {
                scenNames.add(e.getAttributeValue("Name"));
            }
            return scenNames;
        }
        catch (JDOMException e) {
            this.createScenarioFile();
            throw new IOException("Couldn't get list of Scenarios; Tried to createa default file");
        }
        catch (FileNotFoundException e) {
            this.createScenarioFile();
            throw new IOException("Error reading Scenarios.xml; Tried to create adefault file;");
        }
    }

    private void createScenarioFile() {
        Element rootNode = new Element("Scenarios");
        Document doc = new Document(rootNode);
        try {
            XmlUtil.output(doc, "Scenarios.xml");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void shiftScenario(int oldId, int newId) throws IOException {
        try {
            Document scenarios = XmlUtil.input("Scenarios.xml");
            Element scenRoot = scenarios.getRootElement();
            Element shift = (Element)scenRoot.getContent(oldId);
            scenRoot.removeContent(oldId);
            scenRoot.addContent(newId, shift);
            XmlUtil.output(scenarios, "Scenarios.xml");
        }
        catch (JDOMException e) {
            String string = "Error while shifting Scenarios";
        }
    }
}

