/*
 * Decompiled with CFR 0.152.
 */
package model.parsing.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class XmlUtil {
    private XmlUtil() {
    }

    public static void output(Document doc, String path) throws FileNotFoundException, IOException {
        XMLOutputter fmt = new XMLOutputter();
        fmt.output(doc, (OutputStream)new FileOutputStream(path));
    }

    public static Document input(String path) throws JDOMException, IOException {
        SAXBuilder saxBuilder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
        InputStream file = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (file != null) {
            return saxBuilder.build(file);
        }
        return saxBuilder.build(new File(path));
    }

    public static Element getElementByAttribute(Element rootNode, String attr, String value) {
        List elementList = rootNode.getChildren();
        for (Element e : elementList) {
            if (!value.equals(e.getAttributeValue(attr))) continue;
            return e;
        }
        return null;
    }
}

