/*
 * Decompiled with CFR 0.152.
 */
package model.tests;

import controller.tests.Event;
import events.BidirectionalLineState;
import events.BufferState;
import events.ConnectionData;
import events.DeviceState;
import events.EventArgs;
import events.GoBackNState;
import events.HostState;
import events.ProtocolState;
import events.RouterState;
import events.ScenarioState;
import events.StopAndWaitState;
import events.UnidirectionalLineState;
import java.awt.Color;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import model.Scenario;
import model.parsing.ScenarioParser;
import model.parsing.xml.XmlParser;
import org.junit.Assert;
import org.junit.Test;

public class TestValidOutput {
    protected static final String SCENARIO_PATH = "Scenariotests/Complex-full-traffic.xml";
    protected static final String TEMP_PATH = "Scenariotests/Temp.xml";
    protected List<EventArgs> events = new LinkedList<EventArgs>();
    protected List<EventArgs> newEvents = new LinkedList<EventArgs>();
    protected Scenario scenario;
    protected Random rand = new Random();

    public TestValidOutput() throws IOException {
        XmlParser parser = new XmlParser(null);
        this.scenario = ((ScenarioParser)parser).loadScenario(SCENARIO_PATH);
        this.events = this.scenario.getWrapInformation();
        for (EventArgs e : this.events) {
            Event event = Event.getEvent(e);
            switch (event) {
                case HOSTSTATE: {
                    this.scenario.changeObjectState(this.getRandomHostState((HostState)e));
                    break;
                }
                case ROUTERSTATE: {
                    this.scenario.changeObjectState(this.getRandomRouterState((RouterState)e));
                    break;
                }
                case BIDIRECTIONALLINESTATE: {
                    this.scenario.changeObjectState(this.getRandomBidirectionalLineState((BidirectionalLineState)e));
                    break;
                }
                case SCENARIOSTATE: {
                    this.scenario.setScenarioName(this.getRandomString());
                    break;
                }
                case GOBACKNSTATE: 
                case SELECTIVEREPEATSTATE: 
                case STOPANDWAITSTATE: {
                    this.scenario.setProtocolSettings(this.getRandomProtocolState((ProtocolState)e));
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        this.events = this.scenario.getWrapInformation();
        ((ScenarioParser)parser).saveScenario(TEMP_PATH, this.scenario);
        this.scenario = ((ScenarioParser)parser).loadScenario(TEMP_PATH);
        this.newEvents = this.scenario.getWrapInformation();
    }

    @Test
    public void testHostStates() {
        int i = 0;
        while (i < this.events.size()) {
            if (this.events.get(i) instanceof HostState) {
                this.proveEquals((HostState)this.events.get(i), (HostState)this.newEvents.get(i));
            }
            ++i;
        }
    }

    @Test
    public void testRouterStates() {
        int i = 0;
        while (i < this.events.size()) {
            if (this.events.get(i) instanceof RouterState) {
                this.proveEquals((RouterState)this.events.get(i), (RouterState)this.newEvents.get(i));
            }
            ++i;
        }
    }

    @Test
    public void testScenarioStates() {
        for (EventArgs sState : this.events) {
            if (!(sState instanceof ScenarioState)) continue;
            Assert.assertTrue(this.newEvents.contains(sState));
        }
    }

    @Test
    public void testProtocolStates() {
        for (EventArgs pState : this.events) {
            if (!(pState instanceof ProtocolState)) continue;
            Assert.assertTrue(this.newEvents.contains(pState));
        }
    }

    @Test
    public void testBidirectionalLineStates() {
        int i = 0;
        while (i < this.events.size()) {
            if (this.events.get(i) instanceof BidirectionalLineState) {
                this.proveEquals((BidirectionalLineState)this.events.get(i), (BidirectionalLineState)this.newEvents.get(i));
            }
            ++i;
        }
    }

    private BidirectionalLineState getRandomBidirectionalLineState(BidirectionalLineState bState) {
        int cId = bState.getComponentId();
        int source = bState.getSourceDeviceId();
        int target = bState.getTargetDeviceId();
        UnidirectionalLineState ranForthUniLineState = this.getRandomUnidirectionalLineState(bState.getFromSourceToTargetLineState());
        UnidirectionalLineState ranBackUniLineState = this.getRandomUnidirectionalLineState(bState.getFromTargetToSourceLineState());
        return new BidirectionalLineState(cId, false, false, source, target, ranForthUniLineState, ranBackUniLineState);
    }

    private UnidirectionalLineState getRandomUnidirectionalLineState(UnidirectionalLineState uState) {
        int cId = uState.getComponentId();
        int source = uState.getSourceComponentId();
        int target = uState.getTargetComponentId();
        int ranBWith = this.rand.nextInt(100);
        int ranDamage = this.rand.nextInt(100);
        int ranLose = this.rand.nextInt(100);
        int ranLength = this.rand.nextInt(100);
        return new UnidirectionalLineState(cId, false, false, source, target, ranBWith, ranDamage, ranLose, ranLength, null, null);
    }

    private RouterState getRandomRouterState(RouterState rState) {
        int cId = rState.getComponentId();
        String ranName = this.getRandomString();
        Color ranColor = this.getRandomColor();
        int ranX = this.rand.nextInt(1000);
        int ranY = this.rand.nextInt(1000);
        int ranPTime = this.rand.nextInt(1000);
        LinkedList<BufferState> ranBuffers = null;
        if (rState.getBuffers() != null) {
            ranBuffers = new LinkedList<BufferState>();
            for (BufferState bState : rState.getBuffers()) {
                ranBuffers.add(this.getRandomBufferState(bState));
            }
        }
        return new RouterState(cId, false, false, ranName, ranColor, ranX, ranY, ranPTime, null, ranBuffers);
    }

    private HostState getRandomHostState(HostState hState) {
        int cId = hState.getComponentId();
        int lineId = hState.getLineId();
        String ranName = this.getRandomString();
        Color ranColor = this.getRandomColor();
        int ranX = this.rand.nextInt(1000);
        int ranY = this.rand.nextInt(1000);
        LinkedList<ConnectionData> ranCons = new LinkedList<ConnectionData>();
        for (ConnectionData cData : hState.getConnections()) {
            ranCons.add(this.getRandomConnectionData(cData));
        }
        return new HostState(cId, false, false, ranName, ranColor, ranX, ranY, null, lineId, ranCons);
    }

    private ConnectionData getRandomConnectionData(ConnectionData cData) {
        int ranBWidth = this.rand.nextInt(100);
        int targetHost = cData.getTargetHostId();
        BufferState ranInBufState = this.getRandomBufferState(cData.getIncomingBufferState());
        BufferState ranOutBufState = this.getRandomBufferState(cData.getOutgoingBufferState());
        ProtocolState ranProtState = this.getRandomProtocolState(cData.getProtocolState());
        return new ConnectionData(ranBWidth, targetHost, ranInBufState, ranOutBufState, null, null, ranProtState);
    }

    private ProtocolState getRandomProtocolState(ProtocolState pState) {
        ProtocolState ret;
        Event e = Event.getEvent(pState);
        int ranTimeout = this.rand.nextInt();
        int ranWinSize = this.rand.nextInt();
        switch (e) {
            case STOPANDWAITSTATE: {
                ret = new StopAndWaitState(ranTimeout);
                break;
            }
            case GOBACKNSTATE: {
                ret = new GoBackNState(ranTimeout, ranWinSize, false);
                break;
            }
            case SELECTIVEREPEATSTATE: {
                ret = new StopAndWaitState(ranTimeout);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return ret;
    }

    private BufferState getRandomBufferState(BufferState bState) {
        int cId = bState.getComponentId();
        int ranCap = this.rand.nextInt(1000);
        return new BufferState(cId, false, false, ranCap, null);
    }

    private Color getRandomColor() {
        return new Color(this.rand.nextInt(16581375));
    }

    private String getRandomString() {
        int numOfChars = this.rand.nextInt(256);
        String ret = "";
        int i = 0;
        while (i < numOfChars) {
            ret = String.valueOf(ret) + (97 + this.rand.nextInt(26));
            ++i;
        }
        return ret;
    }

    private void proveEquals(DeviceState oState, DeviceState nState) {
        Assert.assertEquals(oState.getColor(), nState.getColor());
        Assert.assertEquals(oState.getName(), nState.getName());
        Assert.assertEquals(oState.getX(), nState.getX());
        Assert.assertEquals(oState.getY(), nState.getY());
    }

    private void proveEquals(RouterState oState, RouterState nState) {
        this.proveEquals((DeviceState)oState, (DeviceState)nState);
        Assert.assertEquals(oState.getProcessingTime(), nState.getProcessingTime());
        int i = 0;
        while (i < oState.getBuffers().size()) {
            this.proveEquals(oState.getBuffers().get(i), nState.getBuffers().get(i));
            ++i;
        }
    }

    private void proveEquals(BufferState oState, BufferState nState) {
        Assert.assertEquals(oState.getCapacity(), nState.getCapacity());
    }

    private void proveEquals(HostState oState, HostState nState) {
        this.proveEquals((DeviceState)oState, (DeviceState)nState);
        this.proveEquals(oState.getBufferState(), nState.getBufferState());
        int i = 0;
        while (i < oState.getConnections().size()) {
            this.proveEquals(oState.getConnections().get(i), nState.getConnections().get(i));
            ++i;
        }
    }

    private void proveEquals(ConnectionData oState, ConnectionData nState) {
        Assert.assertEquals(oState.getBandwidth(), nState.getBandwidth());
        this.proveEquals(oState.getIncomingBufferState(), nState.getIncomingBufferState());
        this.proveEquals(oState.getOutgoingBufferState(), nState.getOutgoingBufferState());
        if (oState.getProtocolState() instanceof GoBackNState) {
            this.proveEquals((GoBackNState)oState.getProtocolState(), (GoBackNState)nState.getProtocolState());
        } else {
            this.proveEquals(oState.getProtocolState(), nState.getProtocolState());
        }
    }

    private void proveEquals(ProtocolState oState, ProtocolState nState) {
        Assert.assertEquals(oState.getTimeout(), nState.getTimeout());
    }

    private void proveEquals(GoBackNState oState, GoBackNState nState) {
        this.proveEquals((ProtocolState)oState, (ProtocolState)nState);
        Assert.assertEquals(oState.getWinSize(), nState.getWinSize());
    }

    private void proveEquals(BidirectionalLineState oState, BidirectionalLineState nState) {
        this.proveEquals(oState.getFromSourceToTargetLineState(), nState.getFromSourceToTargetLineState());
        this.proveEquals(oState.getFromTargetToSourceLineState(), nState.getFromTargetToSourceLineState());
    }

    private void proveEquals(UnidirectionalLineState oState, UnidirectionalLineState nState) {
        Assert.assertEquals(oState.getBandwidth(), nState.getBandwidth());
        Assert.assertEquals(oState.getDamagePercentage(), nState.getDamagePercentage());
        Assert.assertEquals(oState.getLosePercentage(), nState.getLosePercentage());
        Assert.assertEquals(oState.getLength(), nState.getLength());
    }
}

