/*
 * Decompiled with CFR 0.152.
 */
package view;

import events.BufferState;
import java.util.Iterator;
import java.util.List;
import view.Buffer;
import view.Device;
import view.Edge;
import view.Graph;

public abstract class AbstractBufferHandler {
    protected Device device;
    protected Graph graph;

    public AbstractBufferHandler(Device device, Graph graph) {
        this.device = device;
        this.graph = graph;
    }

    public abstract void repaintBuffers();

    public abstract boolean changeBuffer(BufferState var1);

    public abstract void removeAllBuffers();

    protected Buffer createBuffer(BufferState s, Device oppositeDevice, Edge referedEdge) {
        Buffer buffer = new Buffer(s.getComponentId(), this.graph, oppositeDevice, referedEdge);
        this.graph.add(buffer);
        return buffer;
    }

    protected boolean removeBuffer(List<Buffer> bufferList, BufferState s) {
        boolean removed = false;
        Iterator<Buffer> bufferIt = bufferList.iterator();
        while (!removed && bufferIt.hasNext()) {
            Buffer currentBuffer = bufferIt.next();
            if (currentBuffer.getId() != s.getComponentId()) continue;
            this.graph.remove(currentBuffer);
            bufferList.remove(currentBuffer);
            removed = true;
        }
        return removed;
    }

    protected boolean updateBuffer(List<Buffer> bufferList, BufferState s) {
        boolean updated = false;
        Iterator<Buffer> bufferIt = bufferList.iterator();
        while (!updated && bufferIt.hasNext()) {
            Buffer currentBuffer = bufferIt.next();
            if (currentBuffer.getId() != s.getComponentId()) continue;
            double filled = 0.0;
            if (s.getPackets() != null && s.getCapacity() > 0) {
                filled = (double)s.getPackets().size() / (double)s.getCapacity();
            }
            currentBuffer.setFilled(filled);
            updated = true;
        }
        return updated;
    }
}

