/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import view.Cell;
import view.Graph;

public abstract class AbstractEdge
extends Cell {
    public static final int EDGE_RADIUS = 70;
    public static final double ARROW_LENGTH = 10.0;
    public static final double ARROW_ANGLE = 0.5235987755982988;
    public static final Color LINE_COLOR = Color.BLACK;
    public static final Color LINE_COLOR_SELECTED = Color.RED;
    public static final float STROKE_WIDTH = 2.0f;
    protected Color currentColor = LINE_COLOR;
    protected Line2D line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);

    public AbstractEdge(int id, Graph g) {
        super(id, g);
        this.setLayout(null);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        BufferedImage dbImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D dbg = (Graphics2D)dbImage.getGraphics();
        dbg.setStroke(new BasicStroke(2.0f));
        if (this.line != null) {
            double x1 = this.line.getX1();
            double x2 = this.line.getX2();
            double y1 = this.line.getY1();
            double y2 = this.line.getY2();
            if (x1 != x2 || y1 != y2) {
                double x3 = 0.0;
                double x4 = 0.0;
                double y3 = 0.0;
                double y4 = 0.0;
                double elevation = Math.PI + Math.atan(Math.abs((y2 - y1) / (x2 - x1)));
                if (x2 <= x1 && y2 > y1) {
                    elevation = Math.PI - elevation;
                } else if (x2 < x1 && y2 <= y1) {
                    elevation += Math.PI;
                } else if (x2 >= x1 && y2 < y1) {
                    elevation = Math.PI * 2 - elevation;
                }
                x3 = x2 + Math.cos(elevation - 0.5235987755982988) * 10.0;
                x4 = x2 + Math.cos(elevation + 0.5235987755982988) * 10.0;
                y3 = y2 + Math.sin(elevation - 0.5235987755982988) * 10.0;
                y4 = y2 + Math.sin(elevation + 0.5235987755982988) * 10.0;
                Polygon arrow = new Polygon();
                arrow.addPoint((int)x2, (int)y2);
                arrow.addPoint((int)x3, (int)y3);
                arrow.addPoint((int)x4, (int)y4);
                dbg.setColor(this.currentColor);
                dbg.draw(this.line);
                dbg.setColor(Color.WHITE);
                dbg.fillPolygon(arrow);
                dbg.setColor(this.currentColor);
                dbg.draw(arrow);
            }
        }
        ((Graphics2D)g).drawImage((Image)dbImage, 0, 0, this);
    }

    public Point getStartPoint() {
        return new Point((int)this.line.getX1(), (int)this.line.getY1());
    }

    public Point getEndPoint() {
        return new Point((int)this.line.getX2(), (int)this.line.getY2());
    }
}

