/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import view.Device;
import view.Edge;
import view.Graph;
import view.Vertex;

public class Buffer
extends Vertex {
    public static final float STROKE_WIDTH = 2.0f;
    public static final int BUFFER_RADIUS = 14;
    private double filled = 0.0;
    private Device oppositeDevice;
    private Edge referredEdge;

    public Buffer(int id, Graph g, Device oppositeDevice, Edge referredEdge) {
        super(id, g);
        this.referredEdge = referredEdge;
        this.oppositeDevice = oppositeDevice;
        this.setBounds(0, 0, 28, 28);
    }

    public int getSide() {
        return this.referredEdge.getTargetSide();
    }

    public void setFilled(double filled) {
        this.filled = filled;
        this.repaint();
    }

    public Edge getReferredEdge() {
        return this.referredEdge;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int radius = Math.min(this.getWidth(), this.getHeight());
        BufferedImage dbImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Color deviceColor = this.getOppositeDeviceColor();
        Graphics2D dbg = (Graphics2D)dbImage.getGraphics();
        dbg.setStroke(new BasicStroke(2.0f));
        dbg.setColor(deviceColor);
        dbg.fillArc(1, 1, radius - 2, radius - 2, 0, 360);
        dbg.setColor(new Color(240, 240, 240));
        dbg.fillArc(3, 3, radius - 6, radius - 6, 0, 360);
        dbg.setColor(Color.black);
        dbg.fillArc(4, 4, radius - 8, radius - 8, 90, -this.getCirclePiece());
        ((Graphics2D)g).drawImage((Image)dbImage, 0, 0, this);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        super.mouseClicked(arg0);
    }

    private Color getOppositeDeviceColor() {
        Color c = this.oppositeDevice.getColor();
        if (c != null) {
            return c;
        }
        return Color.black;
    }

    private int getCirclePiece() {
        return (int)(360.0 * this.filled);
    }
}

