/*
 * Decompiled with CFR 0.152.
 */
package view;

import events.BidirectionalLineState;
import events.BufferState;
import events.DeviceState;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import view.AbstractBufferHandler;
import view.Edge;
import view.Graph;
import view.Vertex;
import view.VertexIcon;

public abstract class Device
extends Vertex {
    public static final Color BACKGROUND_COLOR = Color.WHITE;
    public static final Color BACKGROUND_COLOR_SELECTED = new Color(220, 220, 220);
    public static final int MIN_WIDTH = 46;
    public static final int MIN_HEIGHT = 61;
    public static final int MAX_WIDTH = 150;
    public static final int MAX_HEIGHT = 100;
    protected AbstractBufferHandler bufferHandler;
    protected int pressedMousePositionX = 0;
    protected int pressedMousePositionY = 0;
    protected int maxLines = -1;
    private boolean drag = false;
    private boolean dragged = true;
    private boolean dragField = true;
    private VertexIcon icon;
    private Color color = Color.BLACK;
    private JLabel caption = new JLabel();
    private List<Edge> edges = new LinkedList<Edge>();
    static Vertex newEdgeSource = null;
    static Vertex newEdgeTarget = null;

    public Device(int id, Graph g) {
        super(id, g);
        this.graph.add(this);
        this.icon = new VertexIcon();
        this.caption.setHorizontalAlignment(0);
        this.setOpaque(true);
        this.setBackground(BACKGROUND_COLOR);
        this.setLayout(new BorderLayout());
        this.add((Component)this.icon, "Center");
        this.add((Component)this.caption, "Last");
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
    }

    public Color getColor() {
        return this.color;
    }

    public void addEdge(Edge e) {
        this.edges.add(e);
        this.graph.updateEdges();
    }

    public boolean removeEdge(Edge e) {
        return this.edges.remove(e);
    }

    public void changeDeviceState(DeviceState s) {
        if (s.isDeleted()) {
            this.bufferHandler.removeAllBuffers();
            this.graph.removeDevice(this);
            this.graph.remove(this);
        } else {
            String name;
            Point2D pos = this.graph.getAbsolutePosition(new Point2D.Double(s.getX(), s.getY()));
            if ((int)Math.round(pos.getX()) != (int)Math.round(this.position.getX()) && Math.round(this.getX()) != (int)Math.round(pos.getX())) {
                this.position = pos;
                this.setLocation((int)Math.round(pos.getX()), (int)Math.round(pos.getY()));
            }
            if ((name = s.getName()) != null && !name.equals(this.caption.getText())) {
                this.setName(name);
            }
            if (s.getColor() != null && !s.getColor().equals(this.color)) {
                this.changeColor(s.getColor());
            }
            this.graph.updateEdges();
        }
    }

    public boolean changeBuffer(BufferState s) {
        return this.bufferHandler.changeBuffer(s);
    }

    public double getElevation(Device target) {
        double elevation = 0.0;
        if (target != null) {
            Rectangle targetRect = target.getBounds();
            Rectangle sourceRect = this.getBounds();
            elevation = -(targetRect.getCenterY() - sourceRect.getCenterY()) / (sourceRect.getCenterX() - targetRect.getCenterX());
        }
        return elevation;
    }

    public int isOnSideTo(Device target) {
        double elevation = this.getElevation(target);
        int side = 0;
        if (target != null) {
            if (this.getY() < target.getY() && (elevation > 1.0 || Double.isInfinite(elevation) || elevation <= -1.0)) {
                side = 0;
            } else if (this.getY() >= target.getY() && (elevation > 1.0 || Double.isInfinite(elevation) || elevation <= -1.0)) {
                side = 1;
            } else if (this.getX() < target.getX() && elevation <= 1.0 & elevation > -1.0) {
                side = 2;
            } else if (this.getX() >= target.getX() && elevation <= 1.0 & elevation > -1.0) {
                side = 3;
            }
        }
        return side;
    }

    public int[] getLinePosition(Edge e) {
        int[] linePosition = new int[2];
        List<Edge> foundEdges = this.findEdges(e.getOppositeSide(this));
        linePosition[0] = foundEdges.size();
        linePosition[1] = this.findPosition(foundEdges, e);
        if (e.getOppositeSide(this) == 3 || e.getOppositeSide(this) == 1) {
            linePosition[1] = linePosition[0] - linePosition[1] - 1;
        }
        return linePosition;
    }

    public double getSideElevation(Device target) {
        double elevation = this.getElevation(target);
        double sideElevation = 0.0;
        if (target != null) {
            Rectangle targetRect = target.getBounds();
            Rectangle sourceRect = this.getBounds();
            if (this.getY() < target.getY() && (elevation > 1.0 || Double.isInfinite(elevation) || elevation <= -1.0)) {
                sideElevation = -(sourceRect.getCenterX() - targetRect.getCenterX()) / (targetRect.getMinY() - sourceRect.getMaxY());
            } else if (this.getY() >= target.getY() && (elevation > 1.0 || Double.isInfinite(elevation) || elevation <= -1.0)) {
                sideElevation = -(sourceRect.getCenterX() - targetRect.getCenterX()) / (targetRect.getMaxY() - sourceRect.getMinY());
            } else if (this.getX() < target.getX() && elevation <= 1.0 & elevation > -1.0) {
                sideElevation = -(targetRect.getCenterY() - sourceRect.getCenterY()) / (sourceRect.getMaxX() - targetRect.getMinX());
            } else if (this.getX() >= target.getX() && elevation <= 1.0 & elevation > -1.0) {
                sideElevation = -(targetRect.getCenterY() - sourceRect.getCenterY()) / (sourceRect.getMinX() - targetRect.getMaxX());
            }
        }
        return sideElevation;
    }

    public void resize() {
        if (Math.max(Math.max(this.icon.getWidth(), this.caption.getWidth()), 46) <= 150 && Math.max(this.icon.getPanelHeight() + this.caption.getHeight(), 61) <= 100) {
            this.setBounds((int)Math.round(this.position.getX()), (int)Math.round(this.position.getY()), Math.max(Math.max(this.icon.getWidth(), this.caption.getWidth()), 46), Math.max(this.icon.getPanelHeight() + this.caption.getHeight(), 61));
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.bufferHandler != null) {
            this.bufferHandler.repaintBuffers();
        }
    }

    @Override
    public void setName(String name) {
        this.caption.setText(name);
        this.caption.setBounds(0, 0, (int)this.caption.getPreferredSize().getWidth() + 7, (int)this.caption.getPreferredSize().getHeight() + 3);
        this.resize();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.graph.isInSimulation()) {
            if (this.drag) {
                this.dragged = true;
                this.drag(e);
            } else {
                this.graph.repaintDraggableLine(new Point2D.Double(e.getX() + this.getX(), e.getY() + this.getY()));
            }
        }
    }

    @Override
    public void deselect() {
        this.setBackground(BACKGROUND_COLOR);
    }

    @Override
    public void select() {
        this.setBackground(BACKGROUND_COLOR_SELECTED);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.graph.isInSimulation()) {
            int borderWidth;
            int x = e.getX();
            int y = e.getY();
            int width = this.getWidth();
            int height = this.getHeight();
            if (!(y <= height - (borderWidth = 10) && y >= borderWidth && x >= borderWidth && x <= width - borderWidth || this.maxLines != -1 && this.edges.size() >= this.maxLines * 2)) {
                this.dragField = false;
                this.setCursor(new Cursor(12));
                this.graph.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
                this.graph.setCursor(new Cursor(0));
                this.dragField = true;
            }
        } else {
            this.graph.setCursor(new Cursor(0));
            this.setCursor(new Cursor(0));
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        super.mouseClicked(arg0);
        this.graph.singleSelectCell(this);
        this.select();
        arg0.getClickCount();
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        if (newEdgeSource != null) {
            boolean lineExists = false;
            for (Edge e : this.edges) {
                if (e.getSourceId() != newEdgeSource.getId() && e.getTargetId() != newEdgeSource.getId()) continue;
                lineExists = true;
            }
            if (!(this.maxLines != -1 && this.edges.size() >= this.maxLines * 2 || lineExists || newEdgeSource == this)) {
                newEdgeTarget = this;
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        newEdgeTarget = null;
        this.graph.setCursor(new Cursor(0));
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        if (!this.graph.isInSimulation()) {
            newEdgeTarget = null;
            if (!this.dragField) {
                newEdgeSource = this;
                this.graph.showDraggableLine(new Point2D.Double(arg0.getX() + this.getX(), arg0.getY() + this.getY()));
                this.graph.repaintDraggableLine(new Point2D.Double(arg0.getX() + this.getX(), arg0.getY() + this.getY()));
            } else {
                this.drag = true;
                this.pressedMousePositionX = arg0.getX();
                this.pressedMousePositionY = arg0.getY();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (!this.graph.isInSimulation()) {
            this.graph.hideDraggableLine();
            this.drag = false;
            if (newEdgeTarget != null && newEdgeTarget.getId() != this.getId()) {
                this.graph.sendState(new BidirectionalLineState(-1, true, false, this.getId(), newEdgeTarget.getId(), null, null));
            }
            if (this.dragged) {
                int x = Math.max(0, Math.min(this.getX(), this.graph.getWidth() - this.getWidth()));
                int y = Math.max(0, Math.min(this.getY(), this.graph.getHeight() - this.getHeight()));
                this.position = new Point2D.Double(x, y);
                this.graph.sendState(this.getMovedState(this.graph.getRelativePosition(this.position)));
                this.setLocation((int)Math.round(this.position.getX()), (int)Math.round(this.position.getY()));
            }
        }
        this.dragged = false;
        newEdgeSource = null;
        this.graph.updateEdges();
    }

    protected abstract DeviceState getMovedState(Point2D var1);

    protected void setIcon(String file) {
        this.icon.setIcon(file);
        this.resize();
    }

    protected void drag(MouseEvent e) {
        Point currentPos = new Point((int)this.getBounds().getX(), (int)this.getBounds().getY());
        Point newPos = new Point((int)((double)e.getX() + currentPos.getX() - (double)this.pressedMousePositionX), (int)((double)e.getY() + currentPos.getY() - (double)this.pressedMousePositionY));
        this.setBounds(new Rectangle(newPos, new Dimension((int)this.getBounds().getWidth(), (int)this.getBounds().getHeight())));
        this.graph.updateEdges();
    }

    private void changeColor(Color c) {
        this.color = new Color(c.getRGB());
        this.setBorder(BorderFactory.createLineBorder(c, 2));
        this.graph.repaintDevices();
    }

    private int findPosition(List<Edge> foundEdges, Edge e) {
        int linePosition = 0;
        double eSideElevation = e.getSideElevation(this);
        for (Edge foundEdge : foundEdges) {
            if (foundEdge == e || !(foundEdge.getSideElevation(this) < eSideElevation)) continue;
            ++linePosition;
        }
        return linePosition;
    }

    private List<Edge> findEdges(int side) {
        LinkedList<Edge> foundEdges = new LinkedList<Edge>();
        for (Edge e : this.edges) {
            if (e.getOppositeSide(this) != side || e.getTargetId() != this.getId()) continue;
            foundEdges.add(e);
        }
        return foundEdges;
    }
}

