/*
 * Decompiled with CFR 0.152.
 */
package view.Dialogs;

import events.BufferState;
import events.ConnectionData;
import events.HostState;
import events.ProtocolState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import view.Dialogs.Dialog;
import view.Graph;

public class EditHostDialog
extends Dialog
implements ItemListener,
ActionListener,
ChangeListener {
    private static final int DEFAULT_COMPONENT_WIDTH = 100;
    private HostState state;
    private Graph graph;
    private int[] connectionTraffic;
    private int[] connectionTimeout;
    private int[] incomingBuffer;
    private int[] outgoingBuffer;
    private boolean hasConnections;
    private JButton colorButton;
    private Color cellColor = Color.black;
    private JSlider bufferSlider;
    private JSlider timeoutSlider;
    private ResourceBundle language;
    private JPanel connectionSettings = new JPanel();
    private JComboBox trafficTarget;
    private JComboBox bufferDropHost;
    private JTextField name;
    private JLabel bufferCapacityLabel;
    private JLabel timeoutLabel;
    private JLabel nameLabel;
    private JLabel bufferLabel;
    private JLabel trafficValueLabel;
    private JCheckBox trafficOn;

    public EditHostDialog(Component parent, String title, HostState state, Graph graph) {
        super(parent, title);
        this.state = state;
        this.graph = graph;
        this.language = this.graph.getLanguage();
        List<ConnectionData> connections = state.getConnections();
        boolean bl = this.hasConnections = connections != null && connections.size() > 0;
        if (this.hasConnections) {
            this.connectionTraffic = new int[connections.size()];
            this.connectionTimeout = new int[connections.size()];
            this.incomingBuffer = new int[connections.size()];
            this.outgoingBuffer = new int[connections.size()];
            int i = 0;
            for (ConnectionData currentConnection : connections) {
                this.connectionTraffic[i] = currentConnection.getBandwidth();
                this.connectionTimeout[i] = currentConnection.getProtocolState().getTimeout();
                this.incomingBuffer[i] = currentConnection.getIncomingBufferState().getCapacity();
                this.outgoingBuffer[i] = currentConnection.getOutgoingBufferState().getCapacity();
                ++i;
            }
        }
        this.nameLabel = new JLabel(this.language.getString("name"));
        this.name = new JTextField();
        this.name.setText(state.getName());
        this.colorButton = new JButton(this.language.getString("color"));
        this.colorButton.addActionListener(this);
        this.cellColor = state.getColor();
        this.trafficTarget = new JComboBox();
        this.bufferLabel = new JLabel(this.language.getString("buffer"));
        this.trafficTarget.addItemListener(this);
        this.trafficValueLabel = new JLabel();
        this.bufferCapacityLabel = new JLabel();
        this.timeoutLabel = new JLabel();
        this.trafficOn = new JCheckBox("On");
        this.trafficOn.addChangeListener(this);
        this.bufferSlider = new JSlider();
        this.bufferSlider.addChangeListener(this);
        this.timeoutSlider = new JSlider();
        this.timeoutSlider.setMaximum(2000);
        this.timeoutSlider.addChangeListener(this);
        this.bufferDropHost = new JComboBox();
        this.bufferDropHost.addItem(this.language.getString("incommingBuffer"));
        this.bufferDropHost.addItem(this.language.getString("outgoingBuffer"));
        this.bufferDropHost.addItemListener(this);
        this.setupConnectionInfo();
    }

    @Override
    public HostState showDialog() {
        HostState newState = null;
        this.buildDialog();
        JDialog dialog = this.pane.createDialog(this.title);
        dialog.setVisible(true);
        Object ret = this.pane.getValue();
        if (ret instanceof Integer && (Integer)ret == 0) {
            newState = this.generateHostState();
        }
        return newState;
    }

    private HostState generateHostState() {
        LinkedList<ConnectionData> connections = null;
        if (this.hasConnections) {
            connections = new LinkedList<ConnectionData>();
            int i = 0;
            while (i < this.state.getConnections().size()) {
                int traffic = this.connectionTraffic[i];
                int timeout = this.connectionTimeout[i];
                int incCapacity = this.incomingBuffer[i];
                int outCapacity = this.outgoingBuffer[i];
                ConnectionData oldConnection = this.state.getConnections().get(i);
                BufferState oldIncoming = oldConnection.getIncomingBufferState();
                BufferState oldOutgoing = oldConnection.getOutgoingBufferState();
                BufferState incomingBuffer = new BufferState(oldIncoming.getComponentId(), oldIncoming.isNew(), oldIncoming.isDeleted(), incCapacity, oldIncoming.getPackets());
                BufferState outgoingBuffer = new BufferState(oldOutgoing.getComponentId(), oldOutgoing.isNew(), oldOutgoing.isDeleted(), outCapacity, oldOutgoing.getPackets());
                ProtocolState newProtocol = oldConnection.getProtocolState().clone();
                newProtocol.setTimeout(timeout);
                ConnectionData current = new ConnectionData(traffic, oldConnection.getTargetHostId(), incomingBuffer, outgoingBuffer, oldConnection.getTraceData(), oldConnection.getBackTraceData(), newProtocol);
                connections.add(current);
                ++i;
            }
        }
        HostState ret = new HostState(this.state.getComponentId(), this.state.isNew(), this.state.isDeleted(), this.name.getText(), this.cellColor, this.state.getX(), this.state.getY(), this.state.getBufferState(), this.state.getLineId(), connections);
        return ret;
    }

    private void buildDialog() {
        this.nameLabel.setPreferredSize(new Dimension(100, (int)this.nameLabel.getPreferredSize().getHeight()));
        this.trafficTarget.setAlignmentX(0.0f);
        this.trafficOn.setAlignmentX(0.0f);
        this.timeoutSlider.setAlignmentX(0.0f);
        this.bufferDropHost.setAlignmentX(0.0f);
        this.bufferSlider.setAlignmentX(0.0f);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        JPanel name = new JPanel();
        name.setLayout(new BoxLayout(name, 2));
        name.add(this.nameLabel);
        name.add(this.name);
        JPanel color = new JPanel();
        color.setLayout(new GridLayout(1, 0));
        color.add(this.colorButton);
        this.connectionSettings.setBorder(BorderFactory.createTitledBorder(this.language.getString("connections")));
        this.connectionSettings.setAlignmentX(0.5f);
        this.connectionSettings.setAlignmentY(0.0f);
        this.connectionSettings.setLayout(new BoxLayout(this.connectionSettings, 3));
        this.connectionSettings.add(this.trafficTarget);
        this.connectionSettings.add(Box.createRigidArea(new Dimension(0, 5)));
        this.connectionSettings.add(this.trafficValueLabel);
        this.connectionSettings.add(Box.createRigidArea(new Dimension(0, 5)));
        this.connectionSettings.add(this.trafficOn);
        this.connectionSettings.add(Box.createRigidArea(new Dimension(0, 5)));
        this.connectionSettings.add(this.timeoutLabel);
        this.connectionSettings.add(Box.createRigidArea(new Dimension(0, 5)));
        this.connectionSettings.add(this.timeoutSlider);
        this.connectionSettings.add(Box.createRigidArea(new Dimension(0, 5)));
        this.connectionSettings.add(this.bufferLabel);
        this.connectionSettings.add(Box.createRigidArea(new Dimension(0, 5)));
        this.connectionSettings.add(this.bufferDropHost);
        this.connectionSettings.add(Box.createRigidArea(new Dimension(0, 5)));
        this.connectionSettings.add(this.bufferCapacityLabel);
        this.connectionSettings.add(Box.createRigidArea(new Dimension(0, 5)));
        this.connectionSettings.add(this.bufferSlider);
        panel.add(name);
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        panel.add(color);
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        if (this.hasConnections) {
            panel.add(this.connectionSettings);
        }
        this.pane.setMessage(panel);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.hasConnections) {
            if (e.getSource() == this.trafficTarget) {
                this.updateConnectionComponents();
            } else if (e.getSource() == this.bufferDropHost) {
                this.updateBufferComponents();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.colorButton) {
            this.cellColor = JColorChooser.showDialog(this.pane, "Color", this.cellColor);
        }
    }

    private void setupConnectionInfo() {
        if (this.state.getConnections() != null && this.state.getConnections().size() > 0) {
            List<ConnectionData> connections = this.state.getConnections();
            for (ConnectionData connectionToHost : connections) {
                this.trafficTarget.addItem(String.valueOf(((HostState)this.graph.getState(connectionToHost.getTargetHostId())).getName()) + " - " + connectionToHost.getTargetHostId());
            }
            this.updateConnectionComponents();
        }
    }

    private void updateConnectionComponents() {
        int index = this.currentConnectionIndex();
        int t = this.connectionTraffic[index];
        this.trafficValueLabel.setText(String.valueOf(this.language.getString("traffic")) + ": " + t);
        this.trafficOn.setSelected(t > 0);
        this.timeoutLabel.setText(String.valueOf(this.language.getString("timeout")) + ": " + this.connectionTimeout[index]);
        this.timeoutSlider.setValue(this.connectionTimeout[index]);
        this.bufferDropHost.setSelectedIndex(0);
        this.updateBufferComponents();
    }

    private void updateBufferComponents() {
        int index = this.currentConnectionIndex();
        int bufferIndex = this.currentBufferIndex();
        if (bufferIndex == 0) {
            this.bufferCapacityLabel.setText(String.valueOf(this.language.getString("capacity")) + ": " + this.incomingBuffer[index]);
            this.bufferSlider.setValue(this.incomingBuffer[index]);
        } else {
            this.bufferCapacityLabel.setText(String.valueOf(this.language.getString("capacity")) + ": " + this.outgoingBuffer[index]);
            this.bufferSlider.setValue(this.outgoingBuffer[index]);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.bufferSlider) {
            this.bufferCapacityLabel.setText(String.valueOf(this.language.getString("capacity")) + ": " + this.bufferSlider.getValue());
            if (this.currentBufferIndex() == 0) {
                this.incomingBuffer[this.currentConnectionIndex()] = this.bufferSlider.getValue();
            } else {
                this.outgoingBuffer[this.currentConnectionIndex()] = this.bufferSlider.getValue();
            }
        } else if (e.getSource() == this.timeoutSlider) {
            this.timeoutLabel.setText(String.valueOf(this.language.getString("timeout")) + ": " + this.timeoutSlider.getValue());
            this.connectionTimeout[this.currentConnectionIndex()] = this.timeoutSlider.getValue();
        } else if (e.getSource() == this.trafficOn) {
            int t = this.trafficOn.isSelected() ? 100 : 0;
            this.trafficValueLabel.setText(String.valueOf(this.language.getString("traffic")) + ": " + t);
            this.connectionTraffic[this.currentConnectionIndex()] = t;
        }
    }

    private int currentConnectionIndex() {
        return this.trafficTarget.getSelectedIndex();
    }

    private int currentBufferIndex() {
        return this.bufferDropHost.getSelectedIndex();
    }
}

