/*
 * Decompiled with CFR 0.152.
 */
package view.Dialogs;

import events.BidirectionalLineState;
import events.UnidirectionalLineState;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import view.Dialogs.Dialog;
import view.Graph;

public class EditLineDialog
extends Dialog
implements ChangeListener {
    private UnidirectionalLineState state;
    private BidirectionalLineState associatedBDLState;
    private Graph graph;
    private ResourceBundle language;
    private JCheckBox bothLines;
    private JSlider transferRateSlider;
    private JSlider loseRateSlider;
    private JSlider damageRateSlider;
    private JSlider lengthSlider;
    private JLabel transferRateValueLabel;
    private JLabel loseRateValueLabel;
    private JLabel damageRateValueLabel;
    private JLabel lengthValueLabel;

    public EditLineDialog(Component parent, UnidirectionalLineState state, BidirectionalLineState associatedBDLState, Graph graph) {
        super(parent, graph.getLanguage().getString("line"));
        this.state = state;
        this.associatedBDLState = associatedBDLState;
        this.graph = graph;
        this.language = this.graph.getLanguage();
    }

    @Override
    public BidirectionalLineState showDialog() {
        BidirectionalLineState newState = null;
        this.buildDialog();
        JDialog dialog = this.pane.createDialog(this.title);
        dialog.setVisible(true);
        Object ret = this.pane.getValue();
        if (ret instanceof Integer && (Integer)ret == 0) {
            newState = this.generateLineState();
        }
        return newState;
    }

    private BidirectionalLineState generateLineState() {
        UnidirectionalLineState sourceToTarget = null;
        UnidirectionalLineState targetToSource = null;
        UnidirectionalLineState newULState = new UnidirectionalLineState(-1, false, false, -1, -1, this.transferRateSlider.getValue(), this.damageRateSlider.getValue(), this.loseRateSlider.getValue(), this.lengthSlider.getValue(), null, null);
        if (this.bothLines.isSelected() || this.associatedBDLState.getFromSourceToTargetLineState().getComponentId() == this.state.getComponentId()) {
            sourceToTarget = newULState;
        }
        if (this.bothLines.isSelected() || this.associatedBDLState.getFromTargetToSourceLineState().getComponentId() == this.state.getComponentId()) {
            targetToSource = newULState;
        }
        BidirectionalLineState newState = new BidirectionalLineState(this.associatedBDLState.getComponentId(), false, false, -1, -1, sourceToTarget, targetToSource);
        return newState;
    }

    private void buildDialog() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(5, 2));
        this.transferRateValueLabel = new JLabel(String.valueOf(this.language.getString("dataRate")) + ": " + String.valueOf(this.state.getBandwidth()));
        this.transferRateValueLabel.setHorizontalAlignment(0);
        panel.add(this.transferRateValueLabel);
        this.transferRateSlider = new JSlider();
        this.transferRateSlider.addChangeListener(this);
        this.transferRateSlider.setValue(this.state.getBandwidth());
        panel.add(this.transferRateSlider);
        this.loseRateValueLabel = new JLabel();
        this.loseRateValueLabel.setHorizontalAlignment(0);
        panel.add(this.loseRateValueLabel);
        this.loseRateSlider = new JSlider();
        this.loseRateSlider.addChangeListener(this);
        this.loseRateSlider.setValue(this.state.getLosePercentage());
        panel.add(this.loseRateSlider);
        this.damageRateValueLabel = new JLabel();
        this.damageRateValueLabel.setHorizontalAlignment(0);
        panel.add(this.damageRateValueLabel);
        this.damageRateSlider = new JSlider();
        this.damageRateSlider.addChangeListener(this);
        this.damageRateSlider.setValue(this.state.getDamagePercentage());
        panel.add(this.damageRateSlider);
        this.lengthValueLabel = new JLabel();
        this.lengthValueLabel.setHorizontalAlignment(0);
        panel.add(this.lengthValueLabel);
        this.lengthSlider = new JSlider();
        this.lengthSlider.addChangeListener(this);
        this.lengthSlider.setMinimum(1);
        this.lengthSlider.setValue(this.state.getLength());
        panel.add(this.lengthSlider);
        JLabel bothLinesLabe = new JLabel(this.language.getString("bothLines"));
        bothLinesLabe.setHorizontalAlignment(0);
        panel.add(bothLinesLabe);
        this.bothLines = new JCheckBox();
        this.bothLines.setSelected(true);
        this.bothLines.setHorizontalAlignment(0);
        panel.add(this.bothLines);
        this.pane.setMessage(panel);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.transferRateSlider) {
            this.transferRateValueLabel.setText(String.valueOf(this.language.getString("dataRate")) + ":   " + String.valueOf(this.transferRateSlider.getValue()));
        }
        if (e.getSource() == this.loseRateSlider) {
            this.loseRateValueLabel.setText(String.valueOf(this.language.getString("loseRate")) + ":   " + String.valueOf(this.loseRateSlider.getValue()));
        }
        if (e.getSource() == this.damageRateSlider) {
            this.damageRateValueLabel.setText(String.valueOf(this.language.getString("damageRate")) + ":   " + String.valueOf(this.damageRateSlider.getValue()));
        }
        if (e.getSource() == this.lengthSlider) {
            this.lengthValueLabel.setText(String.valueOf(this.language.getString("length")) + ":   " + String.valueOf(this.lengthSlider.getValue()));
        }
    }
}

