/*
 * Decompiled with CFR 0.152.
 */
package view.Dialogs;

import events.AckPacketState;
import events.DataPacketState;
import events.HostState;
import events.NakPacketState;
import events.PacketState;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import view.Dialogs.Dialog;
import view.Graph;

public class EditPacketDialog
extends Dialog {
    private PacketState state;
    private Graph graph;
    private ResourceBundle language;
    private JCheckBox damaged;
    private JCheckBox lost;

    public EditPacketDialog(Component parent, PacketState state, Graph graph) {
        super(parent, graph.getLanguage().getString("packet"));
        this.state = state;
        this.graph = graph;
        this.language = this.graph.getLanguage();
    }

    @Override
    public PacketState showDialog() {
        PacketState newState = null;
        this.buildDialog();
        JDialog dialog = this.pane.createDialog(this.title);
        dialog.setVisible(true);
        Object ret = this.pane.getValue();
        if (ret instanceof Integer && (Integer)ret == 0) {
            newState = this.generatePacketState();
        }
        return newState;
    }

    private PacketState generatePacketState() {
        PacketState newState = new PacketState(this.state.getComponentId(), false, false, this.lost.isSelected(), this.damaged.isSelected(), this.state.getSourceHostId(), this.state.getTargetHostId(), this.state.getSequenceNumber());
        return newState;
    }

    private void buildDialog() {
        HostState source = (HostState)this.graph.getState(this.state.getSourceHostId());
        HostState target = (HostState)this.graph.getState(this.state.getTargetHostId());
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(6, 2));
        JLabel sequenceNrLabel = new JLabel(this.language.getString("sequenceNr"));
        sequenceNrLabel.setHorizontalAlignment(0);
        panel.add(sequenceNrLabel);
        JLabel sequenceNr = new JLabel(String.valueOf(this.state.getSequenceNumber()));
        sequenceNr.setHorizontalAlignment(0);
        panel.add(sequenceNr);
        JLabel sourceLabel = new JLabel(this.language.getString("source"));
        sourceLabel.setHorizontalAlignment(0);
        panel.add(sourceLabel);
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(1, 2));
        JPanel sourceColor = new JPanel();
        sourceColor.setBackground(source.getColor());
        p1.add(sourceColor);
        JLabel sourceName = new JLabel(source.getName());
        sourceName.setHorizontalAlignment(0);
        p1.add(sourceName);
        panel.add(p1);
        JLabel targetLabel = new JLabel(this.language.getString("target"));
        targetLabel.setHorizontalAlignment(0);
        panel.add(targetLabel);
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(1, 2));
        JPanel targetColor = new JPanel();
        targetColor.setBackground(target.getColor());
        p2.add(targetColor);
        JLabel targetName = new JLabel(target.getName());
        targetName.setHorizontalAlignment(0);
        p2.add(targetName);
        panel.add(p2);
        JLabel typeLabel = new JLabel(this.language.getString("type"));
        typeLabel.setHorizontalAlignment(0);
        panel.add(typeLabel);
        String packetTypeString = "";
        if (this.state instanceof AckPacketState) {
            packetTypeString = this.language.getString("ack");
        } else if (this.state instanceof DataPacketState) {
            packetTypeString = this.language.getString("dataPacket");
        } else if (this.state instanceof NakPacketState) {
            packetTypeString = this.language.getString("nak");
        }
        JLabel packetType = new JLabel(packetTypeString);
        packetType.setHorizontalAlignment(0);
        panel.add(packetType);
        JLabel damageLabel = new JLabel(this.language.getString("damaged"));
        damageLabel.setHorizontalAlignment(0);
        panel.add(damageLabel);
        this.damaged = new JCheckBox();
        this.damaged.setSelected(this.state.isDamaged());
        panel.add(this.damaged);
        JLabel lostLabel = new JLabel(this.language.getString("lost"));
        lostLabel.setHorizontalAlignment(0);
        panel.add(lostLabel);
        this.lost = new JCheckBox();
        this.lost.setSelected(this.state.isLost());
        panel.add(this.lost);
        this.pane.setMessage(panel);
    }
}

