/*
 * Decompiled with CFR 0.152.
 */
package view.Dialogs;

import events.BidirectionalLineState;
import events.BufferState;
import events.ComponentState;
import events.DeviceState;
import events.EventArgs;
import events.RouterState;
import events.UnidirectionalLineState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import view.Dialogs.Dialog;
import view.Graph;

public class EditRouterDialog
extends Dialog
implements ActionListener,
ItemListener,
ChangeListener {
    private static final int MAX_PROCESSING_TIME = 100;
    private static final int MAX_BUFFER_CAPACITY = 100;
    private static final int DEFAULT_COMPONENT_WIDTH = 130;
    private RouterState state;
    private Graph graph;
    private ResourceBundle language;
    private boolean hasBuffers = false;
    private List<BufferState> buffers;
    private int[] bufferCapacities;
    private Color routerColor;
    private JTextField routerName;
    private JLabel routerNameLabel;
    private JLabel processingTimeLabel;
    private JLabel bufferCapacityLabel;
    private JButton colorButton;
    private JSlider processingTime;
    private JSlider bufferCapacity;
    private JComboBox bufferComboBox;

    public EditRouterDialog(Component parent, String title, RouterState state, Graph graph) {
        super(parent, title);
        this.state = state;
        this.graph = graph;
        this.language = this.graph.getLanguage();
        if (state.getBuffers() != null && state.getBuffers().size() > 0) {
            this.hasBuffers = true;
            this.buffers = state.getBuffers();
        }
        this.routerName = new JTextField(state.getName());
        this.routerNameLabel = new JLabel(this.language.getString("name"));
        this.processingTimeLabel = new JLabel(String.valueOf(this.language.getString("processingTime")) + ": " + state.getProcessingTime());
        this.colorButton = new JButton(this.language.getString("color"));
        this.colorButton.addActionListener(this);
        this.routerColor = state.getColor();
        this.processingTime = new JSlider();
        this.processingTime.setMaximum(100);
        this.processingTime.setValue(state.getProcessingTime());
        this.processingTime.addChangeListener(this);
        if (this.hasBuffers) {
            this.bufferCapacityLabel = new JLabel(String.valueOf(this.language.getString("capacity")) + ": " + state.getBuffers().get(0).getCapacity());
            this.bufferComboBox = new JComboBox();
            this.bufferComboBox.addItemListener(this);
            this.bufferCapacity = new JSlider();
            this.bufferCapacity.setMaximum(100);
            this.bufferCapacity.addChangeListener(this);
            this.bufferCapacities = new int[this.buffers.size()];
            int i = 0;
            for (BufferState currentBuffer : this.buffers) {
                EventArgs targetState;
                ComponentState currentState;
                List<Integer> lines = state.getLines();
                EventArgs lineState = graph.getState(lines.get(i));
                String targetDeviceName = "";
                DeviceState targetDeviceState = null;
                if (lineState instanceof UnidirectionalLineState) {
                    currentState = (UnidirectionalLineState)lineState;
                    if (((UnidirectionalLineState)currentState).getSourceComponentId() != state.getComponentId()) {
                        targetState = graph.getState(((UnidirectionalLineState)currentState).getSourceComponentId());
                        if (targetState instanceof DeviceState) {
                            targetDeviceState = (DeviceState)targetState;
                        }
                    } else {
                        targetState = graph.getState(((UnidirectionalLineState)currentState).getTargetComponentId());
                        if (targetState instanceof DeviceState) {
                            targetDeviceState = (DeviceState)targetState;
                        }
                    }
                } else if (lineState instanceof BidirectionalLineState) {
                    currentState = (BidirectionalLineState)lineState;
                    if (((BidirectionalLineState)currentState).getSourceDeviceId() != state.getComponentId()) {
                        targetState = graph.getState(((BidirectionalLineState)currentState).getSourceDeviceId());
                        if (targetState instanceof DeviceState) {
                            targetDeviceState = (DeviceState)targetState;
                        }
                    } else {
                        targetState = graph.getState(((BidirectionalLineState)currentState).getTargetDeviceId());
                        if (targetState instanceof DeviceState) {
                            targetDeviceState = (DeviceState)targetState;
                        }
                    }
                }
                if (targetDeviceState != null) {
                    targetDeviceName = targetDeviceState.getName();
                }
                this.bufferComboBox.addItem(String.valueOf(this.language.getString("buffer")) + " - " + targetDeviceName + " [" + targetDeviceState.getComponentId() + "]");
                this.bufferCapacities[i] = currentBuffer.getCapacity();
                ++i;
            }
            this.bufferCapacity.setValue(this.buffers.get(0).getCapacity());
        }
    }

    private void buildDialog() {
        this.routerNameLabel.setPreferredSize(new Dimension(130, (int)this.routerNameLabel.getPreferredSize().getHeight()));
        this.processingTimeLabel.setPreferredSize(new Dimension(130, (int)this.processingTimeLabel.getPreferredSize().getHeight()));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        JPanel name = new JPanel();
        name.setLayout(new BoxLayout(name, 2));
        name.add(this.routerNameLabel);
        name.add(this.routerName);
        JPanel color = new JPanel();
        color.setLayout(new GridLayout(1, 0));
        color.add(this.colorButton);
        JPanel processingTime = new JPanel();
        processingTime.setLayout(new BoxLayout(processingTime, 2));
        processingTime.add(this.processingTimeLabel);
        processingTime.add(this.processingTime);
        panel.add(name);
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        panel.add(color);
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        panel.add(processingTime);
        if (this.hasBuffers) {
            this.bufferCapacityLabel.setPreferredSize(new Dimension(130, (int)this.bufferCapacityLabel.getPreferredSize().getHeight()));
            JPanel buffers = new JPanel();
            buffers.setBorder(BorderFactory.createTitledBorder(this.language.getString("buffer")));
            buffers.setLayout(new BoxLayout(buffers, 3));
            JPanel bufferCapacity = new JPanel();
            bufferCapacity.setLayout(new BoxLayout(bufferCapacity, 2));
            bufferCapacity.add(this.bufferCapacityLabel);
            bufferCapacity.add(this.bufferCapacity);
            buffers.add(this.bufferComboBox);
            buffers.add(Box.createRigidArea(new Dimension(0, 5)));
            buffers.add(bufferCapacity);
            panel.add(Box.createRigidArea(new Dimension(0, 5)));
            panel.add(buffers);
        }
        this.pane.setMessage(panel);
    }

    @Override
    public RouterState showDialog() {
        RouterState newState = null;
        this.buildDialog();
        JDialog dialog = this.pane.createDialog(this.title);
        dialog.setVisible(true);
        Object ret = this.pane.getValue();
        if (ret instanceof Integer && (Integer)ret == 0) {
            newState = this.generateRouterState();
        }
        return newState;
    }

    private RouterState generateRouterState() {
        LinkedList<BufferState> newBufferStates = null;
        if (this.hasBuffers) {
            newBufferStates = new LinkedList<BufferState>();
            int i = 0;
            for (BufferState state : this.buffers) {
                int newCapacity = this.bufferCapacities[i];
                BufferState currentState = new BufferState(state.getComponentId(), state.isNew(), state.isDeleted(), newCapacity, state.getPackets());
                newBufferStates.add(currentState);
                ++i;
            }
        }
        RouterState newState = new RouterState(this.state.getComponentId(), this.state.isNew(), this.state.isDeleted(), this.routerName.getText(), this.routerColor, this.state.getX(), this.state.getY(), this.processingTime.getValue(), this.state.getLines(), newBufferStates);
        return newState;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.colorButton) {
            this.routerColor = JColorChooser.showDialog(this.pane, "Color", this.routerColor);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
        if (arg0.getSource() == this.bufferComboBox) {
            int newBufferIndex = this.bufferComboBox.getSelectedIndex();
            this.bufferCapacity.setValue(this.bufferCapacities[newBufferIndex]);
            this.bufferCapacityLabel.setText(String.valueOf(this.language.getString("capacity")) + ": " + this.bufferCapacities[newBufferIndex]);
        }
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        if (arg0.getSource() == this.bufferCapacity) {
            int newBufferIndex = this.bufferComboBox.getSelectedIndex();
            this.bufferCapacityLabel.setText(String.valueOf(this.language.getString("capacity")) + ": " + this.bufferCapacity.getValue());
            this.bufferCapacities[newBufferIndex] = this.bufferCapacity.getValue();
        } else if (arg0.getSource() == this.processingTime) {
            this.processingTimeLabel.setText(String.valueOf(this.language.getString("processingTime")) + ": " + this.processingTime.getValue());
        }
    }
}

