/*
 * Decompiled with CFR 0.152.
 */
package view;

import events.BidirectionalLineState;
import events.EventArgs;
import events.UnidirectionalLineState;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import view.AbstractEdge;
import view.Device;
import view.Dialogs.EditLineDialog;
import view.Graph;
import view.Packet;
import view.Router;

public class Edge
extends AbstractEdge {
    public static final int CLICK_RADIUS = 5;
    public static final int DISTANCE_TO_MID = 10;
    private List<Packet> packets;
    private Device source;
    private Device target;
    private int biId;
    private int targetSide;

    public Edge(int id, int biId, Device source, Device target, Graph graph) {
        super(id, graph);
        this.source = source;
        this.target = target;
        this.biId = biId;
        source.addEdge(this);
        target.addEdge(this);
        this.packets = new LinkedList<Packet>();
    }

    public boolean receiveMouseEvent(MouseEvent e) {
        Point2D.Double point = new Point2D.Double(e.getX() - this.getX(), e.getY() - this.getY());
        if (this.getX() <= e.getX() && this.getX() + this.getWidth() >= e.getX() && this.getY() <= e.getY() && this.getY() + this.getHeight() >= e.getY() && this.line != null && this.line.ptLineDist(point) < 5.0) {
            this.currentColor = LINE_COLOR_SELECTED;
            this.repaint();
            if (!this.graph.isInSimulation() && e.getClickCount() == 2) {
                UnidirectionalLineState lineState = this.getState();
                EditLineDialog d = new EditLineDialog(this.graph, lineState, (BidirectionalLineState)this.graph.getState(this.biId), this.graph);
                BidirectionalLineState alteredState = d.showDialog();
                this.graph.sendState(alteredState);
            }
            return true;
        }
        return false;
    }

    public int getSourceId() {
        return this.source.getId();
    }

    public int getTargetId() {
        return this.target.getId();
    }

    public int getTargetSide() {
        return this.targetSide;
    }

    public int getOppositeSide(Device d) {
        if (d == this.source) {
            return this.target.isOnSideTo(d);
        }
        return this.source.isOnSideTo(d);
    }

    public double getSideElevation(Device d) {
        if (d == this.source) {
            return this.target.getSideElevation(d);
        }
        return this.source.getSideElevation(d);
    }

    public Packet findPacket(int id) {
        for (Packet p : this.packets) {
            if (p.getId() != id) continue;
            return p;
        }
        return null;
    }

    public void changeEdgeState(UnidirectionalLineState s) {
        if (s.isDeleted()) {
            this.source.removeEdge(this);
            this.target.removeEdge(this);
            this.graph.removeEdge(this);
            this.graph.remove(this);
        } else {
            LinkedList<Packet> newPackets = new LinkedList<Packet>();
            Iterator<Integer> packetIds = s.getPackets().iterator();
            Iterator<Integer> packetProgresses = s.getPacketProgress().iterator();
            while (packetIds.hasNext() && packetProgresses.hasNext()) {
                int packetId = packetIds.next();
                int packetProgress = packetProgresses.next();
                if (packetProgress >= 100) continue;
                Packet p = this.getPacket(packetId);
                if (p != null) {
                    newPackets.add(p);
                } else {
                    p = this.graph.getPacket(packetId);
                    if (p != null) {
                        p.setProgress(this, packetProgress);
                        p.setVisible(true);
                        newPackets.add(p);
                    }
                }
                if (p == null) continue;
                p.setProgress(this, packetProgress);
            }
            for (Packet p : this.packets) {
                p.setVisible(false);
                this.graph.addPacket(p);
            }
            this.packets = newPackets;
        }
    }

    public int getBiId() {
        return this.biId;
    }

    public void updateLine() {
        int width;
        int height;
        int x;
        int y;
        boolean arrowStartIsLeft;
        boolean arrowStartIsTop;
        boolean arrowAlignsToTop;
        Rectangle sourceRect = this.source.getBounds();
        Rectangle targetRect = this.target.getBounds();
        Rectangle newRect = null;
        double elevation = this.source.getElevation(this.target);
        int startOffset = 0;
        int endOffset = 0;
        int sourceSideOffset = 0;
        int targetSideOffset = 0;
        int[] sourcePosition = this.source.getLinePosition(this);
        int[] targetPosition = this.target.getLinePosition(this);
        sourceSideOffset = -(sourcePosition[0] - 1) * 14 + sourcePosition[1] * 2 * 14;
        targetSideOffset = -(targetPosition[0] - 1) * 14 + targetPosition[1] * 2 * 14;
        if (elevation > 1.0 || Double.isInfinite(elevation) || elevation <= -1.0) {
            Rectangle lowerRect;
            Rectangle upperRect;
            int offset;
            Rectangle endRect;
            Rectangle startRect;
            arrowAlignsToTop = true;
            sourceRect = new Rectangle((int)sourceRect.getX() - sourceSideOffset, (int)sourceRect.getY(), (int)sourceRect.getWidth(), (int)sourceRect.getHeight());
            targetRect = new Rectangle((int)targetRect.getX() - targetSideOffset, (int)targetRect.getY(), (int)targetRect.getWidth(), (int)targetRect.getHeight());
            if (sourceRect.getCenterY() <= targetRect.getCenterY()) {
                if (this.source instanceof Router) {
                    startOffset = 24;
                }
                if (this.target instanceof Router) {
                    endOffset = 24;
                }
                startRect = sourceRect;
                endRect = targetRect;
                offset = 1;
                arrowStartIsTop = true;
            } else {
                startRect = targetRect;
                endRect = sourceRect;
                offset = -1;
                arrowStartIsTop = false;
                if (this.target instanceof Router) {
                    startOffset = 24;
                }
                if (this.source instanceof Router) {
                    endOffset = 24;
                }
            }
            if (sourceRect.getCenterX() <= targetRect.getCenterX()) {
                upperRect = sourceRect;
                lowerRect = targetRect;
                arrowStartIsLeft = true;
            } else {
                upperRect = targetRect;
                lowerRect = sourceRect;
                arrowStartIsLeft = false;
            }
            y = (int)startRect.getMaxY() + startOffset - 70;
            x = (int)upperRect.getCenterX() + offset * 10 - 70;
            height = (int)(endRect.getMinY() - startRect.getMaxY()) - startOffset - endOffset + 140;
            width = (int)(lowerRect.getCenterX() - upperRect.getCenterX() + 140.0);
        } else {
            Rectangle lowerRect;
            Rectangle upperRect;
            int offset;
            Rectangle endRect;
            Rectangle startRect;
            sourceRect = new Rectangle((int)sourceRect.getX(), (int)sourceRect.getY() - sourceSideOffset, (int)sourceRect.getWidth(), (int)sourceRect.getHeight());
            targetRect = new Rectangle((int)targetRect.getX(), (int)targetRect.getY() - targetSideOffset, (int)targetRect.getWidth(), (int)targetRect.getHeight());
            arrowAlignsToTop = false;
            if (sourceRect.getCenterX() <= targetRect.getCenterX()) {
                startRect = sourceRect;
                endRect = targetRect;
                offset = -1;
                arrowStartIsLeft = true;
                if (this.source instanceof Router) {
                    startOffset = 24;
                }
                if (this.target instanceof Router) {
                    endOffset = 24;
                }
            } else {
                startRect = targetRect;
                endRect = sourceRect;
                offset = 1;
                arrowStartIsLeft = false;
                if (this.target instanceof Router) {
                    startOffset = 24;
                }
                if (this.source instanceof Router) {
                    endOffset = 24;
                }
            }
            if (sourceRect.getCenterY() <= targetRect.getCenterY() - (double)targetSideOffset) {
                upperRect = sourceRect;
                lowerRect = targetRect;
                arrowStartIsTop = true;
            } else {
                upperRect = targetRect;
                lowerRect = sourceRect;
                arrowStartIsTop = false;
            }
            x = (int)startRect.getMaxX() + startOffset - 70;
            y = (int)upperRect.getCenterY() + offset * 10 - 70;
            width = (int)(endRect.getMinX() - startRect.getMaxX() - (double)startOffset - (double)endOffset + 140.0);
            height = (int)(lowerRect.getCenterY() - upperRect.getCenterY() + 140.0);
        }
        newRect = new Rectangle(x, y, width, height);
        if (newRect != null) {
            this.setBounds(newRect);
            this.paintLine(arrowStartIsLeft, arrowStartIsTop, arrowAlignsToTop);
        }
    }

    @Override
    public BidirectionalLineState getDeleteState() {
        return new BidirectionalLineState(this.biId, false, true, -1, -1, null, null);
    }

    @Override
    public UnidirectionalLineState getState() {
        EventArgs b = this.graph.getState(this.biId);
        if (b != null && b instanceof BidirectionalLineState) {
            UnidirectionalLineState sTt = ((BidirectionalLineState)b).getFromSourceToTargetLineState();
            UnidirectionalLineState tTs = ((BidirectionalLineState)b).getFromTargetToSourceLineState();
            if (sTt != null && sTt.getComponentId() == this.getId()) {
                return sTt;
            }
            if (tTs != null && tTs.getComponentId() == this.getId()) {
                return tTs;
            }
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        for (Packet p : this.packets) {
            p.repaint();
        }
    }

    @Override
    public void deselect() {
        this.currentColor = LINE_COLOR;
        this.repaint();
    }

    private Packet getPacket(int packetId) {
        Packet packet = null;
        for (Packet cur : this.packets) {
            if (cur.getId() != packetId) continue;
            packet = cur;
        }
        if (packet != null) {
            this.packets.remove(packet);
        }
        return packet;
    }

    private void paintLine(boolean arrowStartIsLeft, boolean arrowStartIsTop, boolean arrowAlignsToTop) {
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        if (arrowAlignsToTop && !arrowStartIsLeft && !arrowStartIsTop) {
            this.targetSide = 0;
            x1 = this.getWidth() - 70;
            y1 = this.getHeight() - 70;
            x2 = 70;
            y2 = 70;
        } else if (arrowAlignsToTop && !arrowStartIsLeft && arrowStartIsTop) {
            this.targetSide = 1;
            x1 = this.getWidth() - 70;
            y2 = this.getHeight() - 70;
            x2 = 70;
            y1 = 70;
        } else if (arrowAlignsToTop && arrowStartIsLeft && !arrowStartIsTop) {
            this.targetSide = 0;
            x2 = this.getWidth() - 70;
            y1 = this.getHeight() - 70;
            x1 = 70;
            y2 = 70;
        } else if (arrowAlignsToTop && arrowStartIsLeft && arrowStartIsTop) {
            this.targetSide = 1;
            x2 = this.getWidth() - 70;
            y2 = this.getHeight() - 70;
            x1 = 70;
            y1 = 70;
        } else if (!(arrowAlignsToTop || arrowStartIsLeft || arrowStartIsTop)) {
            this.targetSide = 2;
            x1 = this.getWidth() - 70;
            y1 = this.getHeight() - 70;
            x2 = 70;
            y2 = 70;
        } else if (!arrowAlignsToTop && !arrowStartIsLeft && arrowStartIsTop) {
            this.targetSide = 2;
            x1 = this.getWidth() - 70;
            y2 = this.getHeight() - 70;
            x2 = 70;
            y1 = 70;
        } else if (!arrowAlignsToTop && arrowStartIsLeft && !arrowStartIsTop) {
            this.targetSide = 3;
            x2 = this.getWidth() - 70;
            y1 = this.getHeight() - 70;
            x1 = 70;
            y2 = 70;
        } else if (!arrowAlignsToTop && arrowStartIsLeft && arrowStartIsTop) {
            this.targetSide = 3;
            x2 = this.getWidth() - 70;
            y2 = this.getHeight() - 70;
            x1 = 70;
            y1 = 70;
        }
        this.line = new Line2D.Float(x1, y1, x2, y2);
        this.repaint();
    }
}

