/*
 * Decompiled with CFR 0.152.
 */
package view;

import controller.Controller;
import events.ComponentState;
import events.EventArgs;
import events.GoBackNState;
import events.ProtocolState;
import events.SelectiveRepeatState;
import events.Settings;
import events.StopAndWaitState;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import view.DraggableHost;
import view.DraggableRouter;
import view.ExtendedItem;
import view.Graph;
import view.StaticHost;
import view.StaticRouter;

public class GUI
extends JFrame
implements KeyListener,
Observer,
ChangeListener,
ItemListener,
ActionListener {
    private List<String> scenarioList;
    private List<JMenuItem> items;
    private JTable listOfScenarios;
    private String[] Collumnames = new String[1];
    private JSlider timeoutSlide = null;
    private JSlider windowSlide = null;
    private JLabel timeoutLabel;
    private JLabel windowLabel;
    private DefaultTableModel tableModel;
    private JButton add;
    private JButton export;
    private JButton remove;
    private JButton up;
    private JButton down;
    private JSlider speed_Slide;
    private JToolBar toolBar;
    private JPanel p1;
    private JPanel p2;
    private JLabel scenarioLabelToolbar;
    private JLabel protocolLabelToolbar;
    private JLabel speedLabelToolbar;
    private JComboBox szenarienDrop;
    private JComboBox protocolDrop;
    private JMenuBar menu;
    private JMenu file;
    private JMenu scenarien;
    private JMenu control;
    private JMenu extras;
    private JMenu help;
    private JMenuItem d_open;
    private JMenuItem d_export;
    private JMenuItem d_add;
    private JMenuItem d_exit;
    private JMenuItem s_manage;
    private JMenuItem st_start;
    private JMenuItem st_stop;
    private JMenuItem st_step;
    private JMenuItem ex_settings;
    private JMenuItem ex_prSettings;
    private JMenuItem hlp_about;
    private Action openA;
    private Action exportA;
    private Action exitA;
    private Action playA;
    private Action stopA;
    private Action stepA;
    private Action settingsA;
    private Action addA;
    private Action prSettingsA;
    private Action aboutA;
    private ResourceBundle language = ResourceBundle.getBundle("view.Languages", Locale.US);
    private int currentScenarioID = 0;
    private Controller controller;
    private Graph graph;
    boolean isNewScenario = true;
    boolean addNewItem = false;
    final Icon upIcon = new ImageIcon(this.getClass().getResource("/view/up.gif"));
    final Icon downIcon = new ImageIcon(this.getClass().getResource("/view/down.png"));

    public GUI(Settings s, Controller c) {
        this.controller = c;
        if (s != null && s.getLanguage() != null) {
            this.language = ResourceBundle.getBundle("view.Languages", s.getLanguage());
        }
        this.Collumnames[0] = this.language.getString("scenarios");
        this.controller.setScenarioName(this.language.getString("newScenario"));
        this.p1 = new JPanel();
        this.p1.setLayout(new GridLayout(2, 1));
        this.add((Component)this.p1, "North");
        this.scenarioList = this.controller.getScenarioList().getScenarios();
        this.tableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.graph = new Graph(this);
        Box bv = Box.createVerticalBox();
        Graph dragGraph = new Graph(this);
        dragGraph.setLayout(new BorderLayout());
        DraggableHost dHost = new DraggableHost(this.graph);
        dHost.setVisible(false);
        this.add(dHost);
        StaticHost sHost = new StaticHost(this.graph, dragGraph, dHost);
        bv.add(sHost);
        DraggableRouter dRouter = new DraggableRouter(this.graph);
        dRouter.setVisible(false);
        this.add(dRouter);
        StaticRouter sRouter = new StaticRouter(this.graph, dragGraph, dRouter);
        bv.add(sRouter);
        dragGraph.add((Component)bv, "North");
        dragGraph.setBackground(new Color(240, 240, 240));
        this.setLayout(new BorderLayout());
        Container cp = this.getContentPane();
        cp.add((Component)this.p1, "North");
        cp.add(this.graph);
        cp.add((Component)dragGraph, "East");
        this.repaint();
        this.action();
        this.addmenu();
        this.addtoolbar();
        this.setFrame();
        this.graph.setLayout(null);
        this.graph.setPreferredSize(this.graph.getSize());
    }

    private void setFrame() {
        this.pack();
        this.setTitle("VisCaS");
        this.setSize(800, 600);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setVisible(true);
    }

    public boolean isInSimulation() {
        return this.controller.isInSimulationMode();
    }

    public boolean isPaused() {
        return this.controller.isPaused();
    }

    public ResourceBundle getLanguage() {
        return this.language;
    }

    void sendState(EventArgs e) {
        this.editEmptyScenario();
        try {
            this.controller.changeObjectState(e);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        this.add(this.graph);
    }

    public EventArgs getState(int id) {
        return this.controller.getComponentState(id);
    }

    void setState(EventArgs e) {
        try {
            this.controller.changeObjectState(e);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        this.add(this.graph);
    }

    private void action() {
        final GUI localGUI = this;
        ImageIcon open = new ImageIcon(this.getClass().getResource("/view/open.gif"));
        this.openA = new AbstractAction(open){
            {
                this.putValue("Name", GUI.this.language.getString("open"));
                this.putValue("SmallIcon", icon);
                this.putValue("ShortDescription", GUI.this.language.getString("openToolTip"));
                this.putValue("MnemonicKey", 79);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String open;
                if (!GUI.this.controller.isInSimulationMode() && !GUI.this.controller.isPaused() && (open = GUI.this.showOpen()) != null) {
                    try {
                        GUI.this.graph.reset();
                        GUI.this.currentScenarioID = 0;
                        GUI.this.updateScenarioDrop();
                        GUI.this.editEmptyScenario();
                        GUI.this.controller.openScenario(open);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(localGUI, GUI.this.language.getString("openError"), GUI.this.language.getString("error"), 0);
                    }
                }
            }
        };
        ImageIcon add = new ImageIcon(this.getClass().getResource("/view/hinzu.gif"));
        this.addA = new AbstractAction(add){
            {
                this.putValue("Name", GUI.this.language.getString("add"));
                this.putValue("SmallIcon", icon);
                this.putValue("ShortDescription", GUI.this.language.getString("addToolTip"));
                this.putValue("MnemonicKey", 72);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(521, 2));
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!GUI.this.controller.isInSimulationMode() && !GUI.this.controller.isPaused()) {
                    try {
                        String name = JOptionPane.showInputDialog(GUI.this.language.getString("scenarioName"));
                        if (name != null) {
                            GUI.this.controller.setScenarioName(name);
                            GUI.this.controller.saveScenario(-1);
                            GUI.this.currentScenarioID = GUI.this.szenarienDrop.getItemCount();
                            if (((ExtendedItem)GUI.this.szenarienDrop.getSelectedItem()).getId() == -3) {
                                GUI gUI = GUI.this;
                                gUI.currentScenarioID = gUI.currentScenarioID - 1;
                            }
                            GUI.this.updateScenarioList();
                            GUI.this.setScenario(name);
                        }
                    }
                    catch (FileNotFoundException e) {
                        JOptionPane.showMessageDialog(localGUI, GUI.this.language.getString("importError"), GUI.this.language.getString("error"), 0);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(localGUI, GUI.this.language.getString("importError"), GUI.this.language.getString("error"), 0);
                    }
                }
            }
        };
        ImageIcon settings = new ImageIcon(this.getClass().getResource("/view/einstellungen.gif"));
        this.settingsA = new AbstractAction((Icon)settings){
            {
                this.putValue("Name", GUI.this.language.getString("settings"));
                this.putValue("SmallIcon", icon);
                this.putValue("ShortDescription", GUI.this.language.getString("settingsToolTip"));
                this.putValue("MnemonicKey", 69);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 2));
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!GUI.this.controller.isInSimulationMode() && !GUI.this.controller.isPaused()) {
                    GUI.this.globalSettings();
                }
            }
        };
        ImageIcon export = new ImageIcon(this.getClass().getResource("/view/export.gif"));
        this.exportA = new AbstractAction(export){
            {
                this.putValue("Name", GUI.this.language.getString("export"));
                this.putValue("SmallIcon", icon);
                this.putValue("ShortDescription", GUI.this.language.getString("exportToolTip"));
                this.putValue("MnemonicKey", 88);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!GUI.this.controller.isInSimulationMode() && !GUI.this.controller.isPaused()) {
                    String export;
                    String name;
                    if (GUI.this.szenarienDrop.getSelectedItem() == GUI.this.language.getString("newScenario") && (name = JOptionPane.showInputDialog(GUI.this.language.getString("scenarioName"))) != null) {
                        GUI.this.controller.setScenarioName(name);
                    }
                    if ((export = GUI.this.showExport()) != null) {
                        try {
                            GUI.this.controller.saveScenario(export);
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(localGUI, GUI.this.language.getString("exportError"), GUI.this.language.getString("error"), 0);
                        }
                    }
                }
            }
        };
        this.exitA = new AbstractAction(){
            {
                this.putValue("Name", GUI.this.language.getString("close"));
                this.putValue("ShortDescription", GUI.this.language.getString("closeToolTip"));
                this.putValue("MnemonicKey", 66);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, 2));
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUI.this.dispose();
            }
        };
        ImageIcon start = new ImageIcon(this.getClass().getResource("/view/play.gif"));
        this.playA = new AbstractAction((Icon)start){
            {
                this.putValue("Name", GUI.this.language.getString("play/pause"));
                this.putValue("SmallIcon", icon);
                this.putValue("ShortDescription", GUI.this.language.getString("play/pauseToolTip"));
                this.putValue("MnemonicKey", 83);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(32, 0));
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUI.this.controller.startOrPauseSimulation();
                if (GUI.this.controller.isInSimulationMode()) {
                    GUI.this.updateSimulationGroup(false);
                }
            }
        };
        ImageIcon stop = new ImageIcon(this.getClass().getResource("/view/stop.gif"));
        this.stopA = new AbstractAction((Icon)stop){
            {
                this.putValue("Name", GUI.this.language.getString("stop"));
                this.putValue("SmallIcon", icon);
                this.putValue("ShortDescription", GUI.this.language.getString("stopToolTip"));
                this.putValue("MnemonicKey", 84);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUI.this.controller.stopSimulation();
                GUI.this.updateSimulationGroup(true);
            }
        };
        ImageIcon step = new ImageIcon(this.getClass().getResource("/view/step.gif"));
        this.stepA = new AbstractAction((Icon)step){
            {
                this.putValue("Name", GUI.this.language.getString("step"));
                this.putValue("SmallIcon", icon);
                this.putValue("ShortDescription", GUI.this.language.getString("stepToolTip"));
                this.putValue("MnemonicKey", 69);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, 2));
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUI.this.controller.stepForward();
                if (GUI.this.controller.isInSimulationMode()) {
                    GUI.this.updateSimulationGroup(false);
                }
            }
        };
        ImageIcon prSettings = new ImageIcon(this.getClass().getResource("/view/protokoll-einstellungen.gif"));
        this.prSettingsA = new AbstractAction((Icon)prSettings){
            {
                this.putValue("Name", GUI.this.language.getString("protocolSettings"));
                this.putValue("SmallIcon", icon);
                this.putValue("ShortDescription", GUI.this.language.getString("protocolToolTip"));
                this.putValue("MnemonicKey", 69);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 2));
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!GUI.this.controller.isInSimulationMode() && !GUI.this.controller.isPaused()) {
                    GUI.this.protocolSettings();
                }
            }
        };
        this.aboutA = new AbstractAction(){
            {
                this.putValue("Name", GUI.this.language.getString("about"));
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!GUI.this.controller.isInSimulationMode() && !GUI.this.controller.isPaused()) {
                    JOptionPane.showMessageDialog(localGUI, "VisCaS 1.0\nInstitut f\u221a\u00bar Telematik\nwww.kit.edu\n\nAutoren:\nDenise Dudek, Jochen Furthm\u221a\u00baller, Christian Haas,\nFabian Hartmann, Moritz Thomas, Moritz Bohnenberger,\nAndr\u221a\u00a9 Becker, Markus Niedermann, Thomas Hauck\n\n", GUI.this.language.getString("about"), 1);
                }
            }
        };
    }

    private void addmenu() {
        this.menu = new JMenuBar();
        this.p1.add(this.menu);
        this.file = new JMenu(this.language.getString("file"));
        this.file.setMnemonic('D');
        this.menu.add(this.file);
        this.d_open = new JMenuItem(this.openA);
        this.file.add(this.d_open);
        this.d_export = new JMenuItem(this.exportA);
        this.file.add(this.d_export);
        this.d_add = new JMenuItem(this.addA);
        this.file.add(this.d_add);
        this.d_exit = new JMenuItem(this.exitA);
        this.file.add(this.d_exit);
        this.updateScenarioMenu();
        this.control = new JMenu(this.language.getString("control"));
        this.control.setMnemonic('t');
        this.menu.add(this.control);
        this.st_start = new JMenuItem(this.playA);
        this.control.add(this.st_start);
        this.st_stop = new JMenuItem(this.stopA);
        this.control.add(this.st_stop);
        this.st_step = new JMenuItem(this.stepA);
        this.control.add(this.st_step);
        this.extras = new JMenu(this.language.getString("tools"));
        this.extras.setMnemonic('E');
        this.menu.add(this.extras);
        this.ex_settings = new JMenuItem(this.settingsA);
        this.extras.add(this.ex_settings);
        this.ex_prSettings = new JMenuItem(this.prSettingsA);
        this.extras.add(this.ex_prSettings);
        this.help = new JMenu("Hilfe");
        this.help.setMnemonic('H');
        this.menu.add(this.help);
        this.hlp_about = new JMenuItem(this.aboutA);
        this.help.add(this.hlp_about);
    }

    private void addtoolbar() {
        this.toolBar = new JToolBar();
        this.toolBar.setSize(200, 15);
        this.p1.add(this.toolBar);
        this.toolBar.add(this.playA);
        this.toolBar.add(this.stopA);
        this.toolBar.add(this.stepA);
        this.speedLabelToolbar = new JLabel(" " + this.language.getString("speed"));
        this.speedLabelToolbar.setHorizontalAlignment(0);
        this.toolBar.add(this.speedLabelToolbar);
        this.speed_Slide = new JSlider();
        this.speed_Slide.setValue(this.controller.DEFAULT_SPEED);
        this.speed_Slide.addChangeListener(this);
        this.toolBar.add(this.speed_Slide);
        this.p2 = new JPanel();
        this.p2.setLayout(new GridLayout(2, 1));
        this.toolBar.add(this.p2);
        this.protocolLabelToolbar = new JLabel(" " + this.language.getString("protocol"));
        this.protocolLabelToolbar.setHorizontalAlignment(0);
        this.toolBar.add(this.protocolLabelToolbar);
        this.protocolDrop = new JComboBox();
        this.protocolDrop.addItem(new ExtendedItem("Stop-And-Wait", 0));
        this.protocolDrop.addItem(new ExtendedItem("Go-Back-N", 1));
        this.protocolDrop.addItem(new ExtendedItem("Go-Back-N " + this.language.getString("with") + " NACK", 2));
        this.protocolDrop.addItem(new ExtendedItem("Selective-Repeat", 3));
        this.protocolDrop.addItem(new ExtendedItem("Selective-Reject", 4));
        this.protocolDrop.setSelectedIndex(this.controller.getProtocolState().getProtocolId());
        this.protocolDrop.addItemListener(this);
        this.toolBar.add(this.protocolDrop);
        this.toolBar.add(this.prSettingsA);
        this.scenarioLabelToolbar = new JLabel(" " + this.language.getString("scenarios"));
        this.scenarioLabelToolbar.setHorizontalAlignment(0);
        this.toolBar.add(this.scenarioLabelToolbar);
        this.updateScenarioDrop();
        this.toolBar.add(this.szenarienDrop);
        this.toolBar.add(this.openA);
        this.toolBar.add(this.addA);
        this.toolBar.add(this.exportA);
        this.toolBar.add(this.settingsA);
    }

    private String showOpen() {
        return this.showOpen(this);
    }

    private String showOpen(Component parent) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "XML";
            }
        });
        int state = fc.showOpenDialog(parent);
        if (state == 0) {
            return fc.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    private String showExport() {
        return this.showExport(this);
    }

    private String showExport(Component parent) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "XML";
            }
        });
        int state = fc.showSaveDialog(parent);
        if (state == 0) {
            File file = fc.getSelectedFile();
            if (!file.getName().endsWith(".xml")) {
                return String.valueOf(file.getAbsolutePath()) + ".xml";
            }
            return file.getAbsolutePath();
        }
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.controller.endProgram();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg1 instanceof ComponentState) {
            this.graph.changeComponentState((ComponentState)arg1);
        } else if (arg1 instanceof ProtocolState) {
            this.protocolDrop.removeActionListener(this);
            this.protocolDrop.setSelectedIndex(((ProtocolState)arg1).getProtocolId());
            this.protocolDrop.addActionListener(this);
        }
    }

    private void setScenario(String name) {
        this.szenarienDrop.removeItemListener(this);
        this.szenarienDrop.setSelectedItem(name);
        this.szenarienDrop.addItemListener(this);
    }

    private void updateSimulationGroup(boolean b) {
        this.protocolDrop.setEnabled(b);
        this.szenarienDrop.setEnabled(b);
        this.openA.setEnabled(b);
        this.addA.setEnabled(b);
        this.exportA.setEnabled(b);
        this.settingsA.setEnabled(b);
        this.prSettingsA.setEnabled(b);
        this.aboutA.setEnabled(b);
        Component[] componentArray = this.scenarien.getMenuComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component item = componentArray[n2];
            ((JMenuItem)item).setEnabled(b);
            ++n2;
        }
    }

    private void updateScenarioList() {
        this.scenarioList = this.controller.getScenarioList().getScenarios();
        this.updateTable();
        this.updateScenarioDrop();
        this.updateScenarioMenu();
    }

    private void updateTable() {
        Object[][] scenarioListAsArray = new String[this.scenarioList.size()][1];
        int index = 0;
        for (String scenario : this.scenarioList) {
            scenarioListAsArray[index][0] = scenario;
            ++index;
        }
        this.tableModel.setDataVector(scenarioListAsArray, this.Collumnames);
    }

    private void updateScenarioDrop() {
        if (this.szenarienDrop == null) {
            this.szenarienDrop = new JComboBox();
        } else {
            this.szenarienDrop.removeItemListener(this);
            this.szenarienDrop.removeAllItems();
        }
        this.szenarienDrop.addItem(new ExtendedItem(this.language.getString("empty"), -1));
        this.szenarienDrop.addItem(new ExtendedItem(this.language.getString("manageScenarios"), -2));
        int i = 0;
        for (String name : this.scenarioList) {
            this.szenarienDrop.addItem(new ExtendedItem(name, i));
            ++i;
        }
        if (this.addNewItem) {
            this.editEmptyScenario();
            this.szenarienDrop.removeItemListener(this);
            this.addNewItem = false;
        }
        this.szenarienDrop.setSelectedIndex(this.currentScenarioID);
        this.szenarienDrop.addItemListener(this);
    }

    private void updateScenarioMenu() {
        if (this.szenarienDrop == null) {
            this.scenarien = new JMenu(this.language.getString("scenarios"));
            this.scenarien.setMnemonic('S');
            this.menu.add(this.scenarien);
        } else {
            this.scenarien.removeAll();
        }
        this.s_manage = new JMenuItem(this.language.getString("manageScenarios"));
        this.s_manage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GUI.this.controller.isInSimulationMode() && !GUI.this.controller.isPaused()) {
                    GUI.this.manageScenarios();
                }
            }
        });
        this.scenarien.add(this.s_manage);
        this.items = new LinkedList<JMenuItem>();
        this.items.add(new ExtendedItem(this.language.getString("empty"), -1));
        int i = 0;
        for (String name : this.scenarioList) {
            this.items.add(new ExtendedItem(name, i));
            ++i;
        }
        for (JMenuItem item : this.items) {
            this.scenarien.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!GUI.this.controller.isInSimulationMode() && !GUI.this.controller.isPaused()) {
                        int scenario = ((ExtendedItem)e.getSource()).getId();
                        GUI.this.openScenario(scenario);
                        GUI.this.szenarienDrop.setSelectedItem(e.getSource());
                    }
                }
            });
        }
    }

    private void globalSettings() {
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new GridLayout(1, 2));
        JLabel languageLabel = new JLabel(this.language.getString("language"));
        languageLabel.setHorizontalAlignment(0);
        settingsPanel.add(languageLabel);
        JComboBox<String> languageSelect = new JComboBox<String>();
        languageSelect.addItem("Deutsch");
        languageSelect.addItem("English");
        settingsPanel.add(languageSelect);
        if (this.language.getLocale().equals(Locale.GERMAN)) {
            languageSelect.setSelectedIndex(0);
        } else {
            languageSelect.setSelectedIndex(1);
        }
        int result = JOptionPane.showConfirmDialog(settingsPanel, settingsPanel, this.language.getString("globalsettings"), 2);
        if (result == 0) {
            String selectedLanguage = String.valueOf(languageSelect.getSelectedItem());
            if (selectedLanguage.equals("Deutsch")) {
                this.setLanguage(Locale.GERMAN);
            } else if (selectedLanguage.equals("English")) {
                this.setLanguage(Locale.US);
            }
        }
    }

    private void protocolSettings() {
        ProtocolState state = this.controller.getProtocolState();
        int protocolId = state.getProtocolId();
        JPanel dialogPanel = new JPanel();
        JPanel textPanel = new JPanel();
        dialogPanel.setLayout(new BorderLayout());
        JLabel warningLabel = new JLabel(this.language.getString("warning"));
        warningLabel.setPreferredSize(new Dimension((int)warningLabel.getPreferredSize().getWidth(), 50));
        warningLabel.setAlignmentX(0.0f);
        warningLabel.setForeground(Color.RED);
        textPanel.add(warningLabel);
        dialogPanel.add((Component)textPanel, "South");
        JPanel settingsPanel = new JPanel();
        switch (protocolId) {
            case 0: {
                StopAndWaitState s1 = (StopAndWaitState)state;
                this.timeoutLabel = new JLabel(this.language.getString("timeout"));
                this.timeoutLabel.setHorizontalAlignment(0);
                this.timeoutSlide = new JSlider();
                this.timeoutSlide.setMaximum(2000);
                this.timeoutSlide.addChangeListener(this);
                this.timeoutSlide.setValue(s1.getTimeout());
                settingsPanel.setLayout(new GridLayout(1, 2));
                settingsPanel.add(this.timeoutLabel);
                settingsPanel.add(this.timeoutSlide);
                break;
            }
            case 1: 
            case 2: {
                GoBackNState s2 = (GoBackNState)state;
                this.timeoutLabel = new JLabel(this.language.getString("timeout"));
                this.timeoutLabel.setHorizontalAlignment(0);
                this.timeoutSlide = new JSlider();
                this.timeoutSlide.setMaximum(2000);
                this.timeoutSlide.addChangeListener(this);
                this.timeoutSlide.setValue(s2.getTimeout());
                this.windowLabel = new JLabel(this.language.getString("window"));
                this.windowLabel.setHorizontalAlignment(0);
                this.windowSlide = new JSlider();
                this.windowSlide.addChangeListener(this);
                this.windowSlide.setValue(s2.getWinSize());
                settingsPanel.setLayout(new GridLayout(2, 2));
                settingsPanel.add(this.timeoutLabel);
                settingsPanel.add(this.timeoutSlide);
                settingsPanel.add(this.windowLabel);
                settingsPanel.add(this.windowSlide);
                break;
            }
            case 3: 
            case 4: {
                SelectiveRepeatState s3 = (SelectiveRepeatState)state;
                this.timeoutLabel = new JLabel(this.language.getString("timeout"));
                this.timeoutLabel.setHorizontalAlignment(0);
                this.timeoutSlide = new JSlider();
                this.timeoutSlide.setMaximum(2000);
                this.timeoutSlide.addChangeListener(this);
                this.timeoutSlide.setValue(s3.getTimeout());
                this.windowLabel = new JLabel(this.language.getString("window"));
                this.windowLabel.setHorizontalAlignment(0);
                this.windowSlide = new JSlider();
                this.windowSlide.addChangeListener(this);
                this.windowSlide.setValue(s3.getWinSize());
                settingsPanel.setLayout(new GridLayout(2, 2));
                settingsPanel.add(this.timeoutLabel);
                settingsPanel.add(this.timeoutSlide);
                settingsPanel.add(this.windowLabel);
                settingsPanel.add(this.windowSlide);
            }
        }
        dialogPanel.add((Component)settingsPanel, "Center");
        int result = JOptionPane.showConfirmDialog(dialogPanel, dialogPanel, "Globale Settings", 2);
        if (result == 0) {
            ProtocolState s = null;
            switch (protocolId) {
                case 0: {
                    s = new StopAndWaitState(this.timeoutSlide.getValue());
                    break;
                }
                case 1: 
                case 2: {
                    s = new GoBackNState(this.timeoutSlide.getValue(), this.windowSlide.getValue(), ((GoBackNState)state).getNAK());
                    break;
                }
                case 3: 
                case 4: {
                    s = new SelectiveRepeatState(this.timeoutSlide.getValue(), this.windowSlide.getValue(), ((SelectiveRepeatState)state).getNAK());
                }
            }
            if (s != null) {
                this.controller.setProtocolSettings(s);
            }
        }
    }

    private void setLanguage(Locale l) {
        Settings s = new Settings();
        s.setLanguage(l);
        try {
            this.controller.saveSettings(s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.language = ResourceBundle.getBundle("view.Languages", l);
        this.file.setText(this.language.getString("file"));
        this.scenarien.setText(this.language.getString("scenarios"));
        this.control.setText(this.language.getString("control"));
        this.extras.setText(this.language.getString("tools"));
        this.help.setText(this.language.getString("help"));
        this.openA.putValue("Name", this.language.getString("open"));
        this.exportA.putValue("Name", this.language.getString("export"));
        this.exitA.putValue("Name", this.language.getString("close"));
        this.playA.putValue("Name", this.language.getString("play/pause"));
        this.stopA.putValue("Name", this.language.getString("stop"));
        this.stepA.putValue("Name", this.language.getString("step"));
        this.settingsA.putValue("Name", this.language.getString("settings"));
        this.addA.putValue("Name", this.language.getString("add"));
        this.prSettingsA.putValue("Name", this.language.getString("protocolSettings"));
        this.aboutA.putValue("Name", this.language.getString("about"));
        this.protocolLabelToolbar.setText(this.language.getString("protocol"));
        this.speedLabelToolbar.setText(" " + this.language.getString("speed"));
        this.protocolDrop.removeItemListener(this);
        ExtendedItem item = (ExtendedItem)this.protocolDrop.getItemAt(2);
        item.setText("Go-Back-N " + this.language.getString("with") + " NACK");
        this.protocolDrop.repaint();
        this.protocolDrop.addItemListener(this);
        this.scenarioLabelToolbar.setText(this.language.getString("scenarios"));
        this.szenarienDrop.removeItemListener(this);
        ((ExtendedItem)this.szenarienDrop.getItemAt(0)).setText(this.language.getString("empty"));
        ((ExtendedItem)this.szenarienDrop.getItemAt(1)).setText(this.language.getString("manageScenarios"));
        ExtendedItem lastItem = (ExtendedItem)this.szenarienDrop.getItemAt(this.szenarienDrop.getItemCount() - 1);
        if (lastItem.getId() == -3) {
            lastItem.setText(this.language.getString("newScenario"));
        }
        this.szenarienDrop.repaint();
        this.szenarienDrop.addItemListener(this);
    }

    private void editEmptyScenario() {
        if (this.isNewScenario || this.addNewItem) {
            this.szenarienDrop.removeItemListener(this);
            ExtendedItem eI = new ExtendedItem(this.language.getString("newScenario"), -3);
            this.szenarienDrop.addItem(eI);
            this.szenarienDrop.setSelectedItem(eI);
            this.szenarienDrop.addItemListener(this);
            this.currentScenarioID = this.szenarienDrop.getSelectedIndex();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.speed_Slide && !this.speed_Slide.getValueIsAdjusting()) {
            this.controller.setSpeed(this.speed_Slide.getValue());
        }
        if (e.getSource() == this.timeoutSlide) {
            this.timeoutLabel.setText(String.valueOf(this.language.getString("timeout")) + ":  " + this.timeoutSlide.getValue());
        }
        if (e.getSource() == this.windowSlide) {
            this.windowLabel.setText(String.valueOf(this.language.getString("window")) + ":  " + this.windowSlide.getValue());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.protocolDrop && e.getStateChange() == 1) {
            this.controller.setProtocol(this.protocolDrop.getSelectedIndex());
        }
        if (e.getSource() == this.szenarienDrop && e.getStateChange() == 1) {
            if (((ExtendedItem)e.getItem()).getId() == -2) {
                this.szenarienDrop.removeItemListener(this);
                this.szenarienDrop.setSelectedIndex(this.currentScenarioID);
                this.szenarienDrop.addItemListener(this);
                this.manageScenarios();
            } else if (((ExtendedItem)e.getItem()).getId() == -1) {
                this.graph.reset();
                this.currentScenarioID = 0;
                this.controller.newScenario();
                this.updateScenarioDrop();
            } else {
                this.openScenario(((ExtendedItem)e.getItem()).getId());
                this.currentScenarioID = this.szenarienDrop.getSelectedIndex();
                this.updateScenarioDrop();
            }
        }
    }

    private void manageScenarios() {
        if (!this.controller.isInSimulationMode() && !this.controller.isPaused()) {
            this.scenarioList = this.controller.getScenarioList().getScenarios();
            JPanel managePanel = new JPanel();
            managePanel.setLayout(new BorderLayout());
            this.listOfScenarios = new JTable();
            this.updateTable();
            this.listOfScenarios.setModel(this.tableModel);
            managePanel.add((Component)this.listOfScenarios, "Center");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridLayout(6, 1));
            this.add = new JButton(this.language.getString("add"));
            this.add.addActionListener(this);
            buttonPanel.add(this.add);
            this.export = new JButton(this.language.getString("export"));
            this.export.addActionListener(this);
            buttonPanel.add(this.export);
            this.remove = new JButton(this.language.getString("remove"));
            this.remove.addActionListener(this);
            buttonPanel.add(this.remove);
            this.up = new JButton(this.upIcon);
            this.up.addActionListener(this);
            buttonPanel.add(this.up);
            this.down = new JButton(this.downIcon);
            this.down.addActionListener(this);
            buttonPanel.add(this.down);
            managePanel.add((Component)buttonPanel, "East");
            JOptionPane.showConfirmDialog(managePanel, managePanel, String.valueOf(this.language.getString("scenarios")) + " " + this.language.getString("manageScenarios"), 2);
        }
    }

    private void openScenario(int id) {
        if (!this.controller.isInSimulationMode() && !this.controller.isPaused()) {
            if (id == -1) {
                this.graph.reset();
                this.controller.newScenario();
            } else {
                try {
                    this.graph.reset();
                    this.controller.openScenario(id);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, this.language.getString("openError"), this.language.getString("error"), 0);
                }
            }
        }
    }

    private int getScenarioID(String name) {
        int ID = 0;
        int index = 0;
        for (String scenarioName : this.scenarioList) {
            if (scenarioName.equals(name)) {
                ID = index;
            }
            ++index;
        }
        return ID;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String url;
        int row;
        if (e.getSource() == this.up && (row = this.listOfScenarios.getSelectedRow()) > 0) {
            try {
                this.controller.shiftScenario(row, row - 1);
                if (((ExtendedItem)this.szenarienDrop.getSelectedItem()).getId() == -3) {
                    this.currentScenarioID = this.szenarienDrop.getItemCount() - 1;
                    this.addNewItem = true;
                } else if (row == this.currentScenarioID - 1) {
                    ++this.currentScenarioID;
                } else if (row == this.currentScenarioID - 2) {
                    --this.currentScenarioID;
                }
                this.updateScenarioList();
                this.listOfScenarios.setRowSelectionInterval(row - 1, row - 1);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (e.getSource() == this.down && (row = this.listOfScenarios.getSelectedRow()) < this.listOfScenarios.getRowCount() - 1) {
            try {
                this.controller.shiftScenario(row, row + 1);
                if (((ExtendedItem)this.szenarienDrop.getSelectedItem()).getId() == -3) {
                    this.addNewItem = true;
                } else if (row == this.currentScenarioID - 2) {
                    ++this.currentScenarioID;
                } else if (row == this.currentScenarioID - 3) {
                    --this.currentScenarioID;
                }
                this.updateScenarioList();
                this.listOfScenarios.setRowSelectionInterval(row + 1, row + 1);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (e.getSource() == this.add) {
            String url2 = this.showOpen(this.add.getParent());
            int scenarioId = this.scenarioList.size();
            if (url2 != null) {
                try {
                    this.controller.importScenario(url2, scenarioId);
                    if (((ExtendedItem)this.szenarienDrop.getSelectedItem()).getId() == -3) {
                        this.addNewItem = true;
                    }
                    this.updateScenarioList();
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(this, this.language.getString("importError"), this.language.getString("error"), 0);
                }
            }
        }
        if (e.getSource() == this.remove && this.listOfScenarios.getSelectedColumnCount() > 0 && this.listOfScenarios.getSelectedRowCount() > 0) {
            try {
                if (this.listOfScenarios.getSelectedRow() < this.currentScenarioID - 2) {
                    --this.currentScenarioID;
                }
                int id = this.getScenarioID(String.valueOf(this.listOfScenarios.getValueAt(this.listOfScenarios.getSelectedRow(), this.listOfScenarios.getSelectedColumn())));
                this.controller.removeScenario(id);
                if (((ExtendedItem)this.szenarienDrop.getSelectedItem()).getId() == -3 || ((ExtendedItem)this.szenarienDrop.getSelectedItem()).getId() == id) {
                    this.addNewItem = true;
                }
                this.updateScenarioList();
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this, this.language.getString("deleteError"), this.language.getString("error"), 0);
            }
        }
        if (e.getSource() == this.export && this.listOfScenarios.getSelectedColumnCount() > 0 && this.listOfScenarios.getSelectedRowCount() > 0 && (url = this.showExport(this.export.getParent())) != null) {
            int scenarioId = this.getScenarioID(String.valueOf(this.listOfScenarios.getValueAt(this.listOfScenarios.getSelectedRow(), this.listOfScenarios.getSelectedColumn())));
            try {
                this.controller.exportScenario(scenarioId, url);
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this, this.language.getString("exportError"), this.language.getString("error"), 0);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

