/*
 * Decompiled with CFR 0.152.
 */
package view;

import events.AckPacketState;
import events.BidirectionalLineState;
import events.BufferState;
import events.ComponentState;
import events.DeviceState;
import events.EventArgs;
import events.HostState;
import events.NakPacketState;
import events.PacketState;
import events.RouterState;
import events.UnidirectionalLineState;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import view.ACKPacket;
import view.Cell;
import view.DataPacket;
import view.Device;
import view.DraggableEdge;
import view.Edge;
import view.GUI;
import view.Host;
import view.NAKPacket;
import view.Packet;
import view.Router;
import view.Selection;
import view.Vertex;

public class Graph
extends JPanel
implements MouseListener,
KeyListener,
MouseMotionListener {
    private GUI gui;
    private List<Edge> edges = new LinkedList<Edge>();
    private List<Device> vertices = new LinkedList<Device>();
    private List<Packet> packets = new LinkedList<Packet>();
    private DraggableEdge draggableEdge = new DraggableEdge();
    private Selection selection = new Selection();
    private List<Cell> selectedCells = new LinkedList<Cell>();

    public Graph(GUI gui) {
        this.gui = gui;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setBackground(Color.WHITE);
        this.add(this.draggableEdge);
        this.draggableEdge.setVisible(false);
        this.add(this.selection);
        this.selection.setVisible(false);
    }

    public void singleSelectCell(Cell selected) {
        for (Cell c : this.selectedCells) {
            if (c == null) continue;
            c.deselect();
        }
        this.selectedCells.clear();
        if (selected != null) {
            this.selectedCells.add(selected);
        }
    }

    public void repaintDraggableLine(Point2D p) {
        this.draggableEdge.updateEdge(p);
    }

    public void repaintDevices() {
        for (Device d : this.vertices) {
            if (d == null) continue;
            d.repaint();
        }
    }

    public void showDraggableLine(Point2D p) {
        this.draggableEdge.setStartPoint(p);
        this.draggableEdge.updateEdge(p);
        this.draggableEdge.setVisible(true);
    }

    public void hideDraggableLine() {
        this.draggableEdge.setVisible(false);
    }

    public void changeComponentState(ComponentState s) {
        this.gui.isNewScenario = false;
        if (s instanceof BufferState) {
            Iterator<Device> deviceIt = this.vertices.iterator();
            boolean success = false;
            while (!success && deviceIt.hasNext()) {
                success = deviceIt.next().changeBuffer((BufferState)s);
            }
        } else if (s instanceof DeviceState) {
            Device d;
            if (s instanceof HostState && s.isNew()) {
                this.addDevice(new Host(s.getComponentId(), this));
            }
            if (s instanceof RouterState && s.isNew()) {
                this.addDevice(new Router(s.getComponentId(), this));
            }
            if ((d = this.findDevice(s.getComponentId())) != null) {
                d.changeDeviceState((DeviceState)s);
            }
        } else if (s instanceof BidirectionalLineState) {
            BidirectionalLineState b = (BidirectionalLineState)s;
            if (s.isDeleted()) {
                List<Edge> edges = this.findEdges(s.getComponentId());
                for (Edge e : edges) {
                    e.changeEdgeState(new UnidirectionalLineState(e.getId(), false, true, -1, -1, -1, -1, -1, -1, null, null));
                }
            } else {
                UnidirectionalLineState uState1 = ((BidirectionalLineState)s).getFromSourceToTargetLineState();
                UnidirectionalLineState uState2 = ((BidirectionalLineState)s).getFromTargetToSourceLineState();
                if (uState1 != null) {
                    if (uState1.isNew()) {
                        this.addEdge(uState1, b, true);
                    }
                    Edge u1 = this.findEdge(uState1.getComponentId());
                    u1.changeEdgeState(uState1);
                }
                if (uState2 != null) {
                    if (uState2.isNew()) {
                        this.addEdge(uState2, b, false);
                    }
                    Edge u2 = this.findEdge(uState2.getComponentId());
                    u2.changeEdgeState(uState2);
                }
            }
        } else if (s instanceof PacketState) {
            Packet p;
            PacketState packetState = (PacketState)s;
            if (packetState.isNew()) {
                p = s instanceof NakPacketState ? new NAKPacket(packetState.getComponentId(), this, this.findDevice(packetState.getSourceHostId()).getColor(), this.findDevice(packetState.getTargetHostId()).getColor(), packetState.getSequenceNumber()) : (s instanceof AckPacketState ? new ACKPacket(packetState.getComponentId(), this, this.findDevice(packetState.getSourceHostId()).getColor(), this.findDevice(packetState.getTargetHostId()).getColor(), packetState.getSequenceNumber()) : new DataPacket(packetState.getComponentId(), this, this.findDevice(packetState.getSourceHostId()).getColor(), this.findDevice(packetState.getTargetHostId()).getColor(), packetState.getSequenceNumber()));
                this.packets.add(p);
                this.add(p);
                this.setComponentZOrder(p, 0);
            } else {
                p = this.findPacket(packetState.getComponentId());
            }
            Iterator<Edge> edgeIt = this.edges.iterator();
            while (edgeIt.hasNext() && p == null) {
                Edge curEdge = edgeIt.next();
                if (curEdge == null) continue;
                p = curEdge.findPacket(packetState.getComponentId());
            }
            if (p != null) {
                if (packetState.isDeleted()) {
                    this.packets.remove(p);
                    this.remove(p);
                } else {
                    p.changePacketState(packetState);
                }
            }
        }
        this.repaint();
    }

    public void sendState(ComponentState s) {
        this.gui.sendState(s);
        this.requestFocus();
    }

    public Point2D getAbsolutePosition(Point2D p) {
        double absX = p.getX() * (double)this.getWidth() / 1000.0;
        double absY = p.getY() * (double)this.getHeight() / 1000.0;
        return new Point2D.Double(absX, absY);
    }

    public Point2D getRelativePosition(Point2D p) {
        double relX = p.getX() / (double)this.getWidth() * 1000.0;
        double relY = p.getY() / (double)this.getHeight() * 1000.0;
        return new Point2D.Double(relX, relY);
    }

    public void updateEdges() {
        for (Edge e : this.edges) {
            e.updateLine();
        }
    }

    public boolean isInSimulation() {
        return this.gui.isInSimulation();
    }

    public boolean isPaused() {
        return this.gui.isPaused();
    }

    public Device findDevice(int id) {
        for (Device v : this.vertices) {
            if (v.getId() != id) continue;
            return v;
        }
        return null;
    }

    public Packet findPacket(int id) {
        for (Packet p : this.packets) {
            if (p.getId() != id) continue;
            return p;
        }
        return null;
    }

    public Edge findEdge(int id) {
        for (Edge e : this.edges) {
            if (e.getId() != id) continue;
            return e;
        }
        return null;
    }

    public List<Edge> findEdges(int biId) {
        LinkedList<Edge> ret = new LinkedList<Edge>();
        for (Edge e : this.edges) {
            if (e.getBiId() != biId) continue;
            ret.add(e);
        }
        return ret;
    }

    public void addPacket(Packet p) {
        this.packets.add(p);
    }

    public Packet getPacket(int packetId) {
        Packet packet = null;
        for (Packet cur : this.packets) {
            if (cur.getId() != packetId) continue;
            packet = cur;
        }
        if (packet != null) {
            this.packets.remove(packet);
        }
        return packet;
    }

    public void removeEdge(Edge edge) {
        this.edges.remove(edge);
    }

    public void removeDevice(Device d) {
        this.vertices.remove(d);
    }

    public void reset() {
        this.removeAll();
        this.packets.clear();
        this.edges.clear();
        this.vertices.clear();
        this.selectedCells.clear();
        this.gui.isNewScenario = true;
        this.add(this.draggableEdge);
        this.add(this.selection);
        this.repaint();
    }

    public EventArgs getState(int id) {
        return this.gui.getState(id);
    }

    public ResourceBundle getLanguage() {
        return this.gui.getLanguage();
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        this.requestFocus();
        this.singleSelectCell(null);
        Iterator<Edge> edgeIt = this.edges.iterator();
        boolean success = false;
        while (edgeIt.hasNext() && !success) {
            Edge actualEdge = edgeIt.next();
            success = actualEdge.receiveMouseEvent(arg0);
            if (!success) continue;
            this.singleSelectCell(actualEdge);
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.selection.setStartPoint(arg0.getPoint());
        this.selection.updateSelection(arg0.getPoint());
        this.selection.setVisible(true);
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        Point2D start = this.selection.getStartPoint();
        Point end = arg0.getPoint();
        this.singleSelectCell(null);
        for (Vertex vertex : this.vertices) {
            if (!vertex.isInRange(start, end)) continue;
            vertex.select();
            this.selectedCells.add(vertex);
        }
        this.selection.setVisible(false);
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
        if (arg0.getKeyCode() == 127) {
            for (Cell c : this.selectedCells) {
                ComponentState s = c.getDeleteState();
                if (s == null || this.isInSimulation()) continue;
                this.sendState(s);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        this.selection.updateSelection(arg0.getPoint());
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    private void addDevice(Device d) {
        this.vertices.add(d);
        this.add(d);
        this.repaint();
        d.setVisible(false);
        d.setVisible(true);
    }

    private void addEdge(UnidirectionalLineState u, BidirectionalLineState s, boolean sTt) {
        int biId = s.getComponentId();
        int sourceId = sTt ? s.getSourceDeviceId() : s.getTargetDeviceId();
        int targetId = !sTt ? s.getSourceDeviceId() : s.getTargetDeviceId();
        Device sourceDevice = this.findDevice(sourceId);
        Device targetDevice = this.findDevice(targetId);
        if (sourceDevice != null && targetDevice != null) {
            Edge edge = new Edge(u.getComponentId(), biId, sourceDevice, targetDevice, this);
            this.edges.add(edge);
            this.add(edge);
        }
    }
}

