/*
 * Decompiled with CFR 0.152.
 */
package view;

import events.BufferState;
import events.ComponentState;
import events.ConnectionData;
import events.DeviceState;
import events.HostState;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import view.Device;
import view.Dialogs.EditHostDialog;
import view.Graph;
import view.HostBufferHandler;

public class Host
extends Device {
    public Host(int id, Graph g) {
        super(id, g);
        this.setIcon("Comp.png");
        this.maxLines = 1;
        this.bufferHandler = new HostBufferHandler(this, this.graph);
    }

    @Override
    public ComponentState getDeleteState() {
        return new HostState(this.getId(), false, true, null, null, -1, -1, null, -1, null);
    }

    @Override
    protected DeviceState getMovedState(Point2D p) {
        return new HostState(this.getId(), false, false, null, null, (int)p.getX(), (int)p.getY(), null, -1, null);
    }

    @Override
    public void changeDeviceState(DeviceState s) {
        HostState hostState = (HostState)s;
        if (!s.isDeleted()) {
            super.changeDeviceState(s);
            List<ConnectionData> cData = hostState.getConnections();
            if (cData != null) {
                for (ConnectionData c : cData) {
                    Device targetDevice = this.graph.findDevice(c.getTargetHostId());
                    if (!(targetDevice instanceof Host)) continue;
                    Host targetHost = (Host)targetDevice;
                    if (targetDevice != null) {
                        if (c.getIncomingBufferState() != null && c.getIncomingBufferState().isNew()) {
                            ((HostBufferHandler)targetHost.bufferHandler).createBuffer(c.getIncomingBufferState(), (Device)this, targetHost);
                        }
                        targetDevice.changeBuffer(c.getIncomingBufferState());
                    }
                    if (c.getOutgoingBufferState() != null && c.getOutgoingBufferState().isNew()) {
                        ((HostBufferHandler)this.bufferHandler).createBuffer(c.getOutgoingBufferState(), (Device)this, targetHost);
                    }
                    this.bufferHandler.changeBuffer(c.getOutgoingBufferState());
                }
            }
        } else {
            List<ConnectionData> cData = hostState.getConnections();
            if (cData != null) {
                for (ConnectionData c : cData) {
                    if (c.getIncomingBufferState() == null) continue;
                    this.graph.changeComponentState(new BufferState(c.getIncomingBufferState().getComponentId(), false, true, -1, null));
                }
            }
            super.changeDeviceState(s);
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        super.mouseClicked(arg0);
        if (!this.graph.isInSimulation() && !this.graph.isPaused() && arg0.getClickCount() == 2) {
            HostState hostState = (HostState)this.getState();
            EditHostDialog d = new EditHostDialog(this.graph, this.getName(), hostState, this.graph);
            HostState alteredState = d.showDialog();
            this.graph.sendState(alteredState);
        }
    }
}

