/*
 * Decompiled with CFR 0.152.
 */
package view;

import events.BufferState;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import view.AbstractBufferHandler;
import view.Buffer;
import view.Device;
import view.Graph;

public class HostBufferHandler
extends AbstractBufferHandler {
    public static final int X_OFFSET = 0;
    private List<Buffer> incomingBuffers = new LinkedList<Buffer>();
    private List<Buffer> outgoingBuffers = new LinkedList<Buffer>();
    private Buffer timeoutBuffer = null;
    private JLabel incomingLabel = new JLabel("I");
    private JLabel outgoingLabel = new JLabel("O");
    private JLabel timeoutLabel = new JLabel("T");

    public HostBufferHandler(Device device, Graph graph) {
        super(device, graph);
        this.incomingLabel.setBounds(0, 0, (int)this.incomingLabel.getPreferredSize().getWidth(), (int)this.incomingLabel.getPreferredSize().getHeight());
        this.incomingLabel.setVisible(false);
        this.incomingLabel.repaint();
        graph.add(this.incomingLabel);
        this.outgoingLabel.setBounds(0, 0, (int)this.outgoingLabel.getPreferredSize().getWidth(), (int)this.outgoingLabel.getPreferredSize().getHeight());
        this.outgoingLabel.setVisible(false);
        graph.add(this.outgoingLabel);
        this.timeoutLabel.setBounds(0, 0, (int)this.timeoutLabel.getPreferredSize().getWidth(), (int)this.timeoutLabel.getPreferredSize().getHeight());
        this.timeoutLabel.setVisible(false);
    }

    public void createBuffer(BufferState s, Device parentDevice, Device oppositeDevice) {
        if (parentDevice == this.device) {
            this.incomingBuffers.add(super.createBuffer(s, oppositeDevice, null));
            if (this.timeoutBuffer != null) {
                this.graph.remove(this.timeoutBuffer);
            }
        } else if (oppositeDevice == this.device) {
            this.outgoingBuffers.add(super.createBuffer(s, parentDevice, null));
        }
    }

    @Override
    public boolean changeBuffer(BufferState s) {
        boolean ret = false;
        if (s.isDeleted()) {
            ret = this.removeBuffer(this.outgoingBuffers, s);
            if (!ret) {
                ret = this.removeBuffer(this.incomingBuffers, s);
            }
        } else {
            ret = this.updateBuffer(this.outgoingBuffers, s);
            if (!ret) {
                ret = this.updateBuffer(this.incomingBuffers, s);
            }
        }
        if (ret) {
            this.repaintBuffers();
        }
        return ret;
    }

    @Override
    public void repaintBuffers() {
        this.repaintBufferLine(this.incomingBuffers, this.outgoingLabel, -1);
        this.repaintBufferLine(this.outgoingBuffers, this.incomingLabel, 1);
    }

    @Override
    public void removeAllBuffers() {
        for (Buffer b : this.incomingBuffers) {
            this.graph.remove(b);
        }
        for (Buffer b : this.outgoingBuffers) {
            this.graph.remove(b);
        }
        this.incomingBuffers.clear();
        this.outgoingBuffers.clear();
        this.graph.remove(this.incomingLabel);
        this.graph.remove(this.outgoingLabel);
        this.graph.remove(this.timeoutLabel);
        this.graph.remove(this.timeoutBuffer);
    }

    private void repaintBufferLine(List<Buffer> buffers, JLabel label, int direction) {
        if (buffers != null && !buffers.isEmpty()) {
            int i = 0;
            Rectangle r = this.device.getBounds();
            int x = (int)Math.round(r.getCenterX()) + direction * 0 + direction * 14;
            int y = (int)r.getMaxY();
            label.setBounds(x - label.getWidth() / 2, y, label.getWidth(), label.getHeight());
            label.setVisible(true);
            if (label == this.outgoingLabel) {
                this.timeoutLabel.setBounds(x - this.timeoutLabel.getWidth() / 2 - 28, y, this.timeoutLabel.getWidth(), this.timeoutLabel.getHeight());
                this.timeoutLabel.setVisible(true);
                if (this.timeoutBuffer != null) {
                    this.timeoutBuffer.setBounds(x - 14 - 28, y + this.timeoutLabel.getHeight(), this.timeoutBuffer.getWidth(), this.timeoutBuffer.getHeight());
                    this.timeoutBuffer.setVisible(true);
                    this.timeoutBuffer.setFilled(0.25);
                }
            }
            y += label.getHeight();
            int yDistance = 28;
            for (Buffer b : buffers) {
                b.setBounds(x - 14, y + i * yDistance, b.getWidth(), b.getHeight());
                ++i;
            }
        } else {
            label.setVisible(false);
            if (label == this.outgoingLabel) {
                this.timeoutLabel.setVisible(false);
                if (this.timeoutBuffer != null) {
                    this.timeoutBuffer.setVisible(false);
                }
            }
        }
    }
}

